package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.SQLServerDDLBuilder;
import cn.schoolwow.quickdao.builder.dql.AbstractDQLBuilder;
import cn.schoolwow.quickdao.dao.sql.dcl.AbstractDCLDAO;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdao.query.condition.SQLServerCondition;
import cn.schoolwow.quickdao.query.subCondition.AbstractSubCondition;
import cn.schoolwow.quickdao.query.subCondition.SubCondition;

public class SQLServerDatabaseProvider extends AbstractDatabaseProvider {

    @Override
    public AbstractDDLBuilder getDDLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new SQLServerDDLBuilder(quickDAOConfig);
    }

    @Override
    public AbstractDCLDAO getDCLDAOInstance(QuickDAOConfig quickDAOConfig) {
        return new AbstractDCLDAO(quickDAOConfig);
    }

    @Override
    public AbstractDQLBuilder getDQLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new AbstractDQLBuilder(quickDAOConfig);
    }

    @Override
    public Condition getConditionInstance(Query query) {
        return new SQLServerCondition(query);
    }

    @Override
    public SubCondition getSubConditionInstance(SubQuery subQuery) {
        return new AbstractSubCondition(subQuery);
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\""+value +"\"";
    }

    @Override
    public String name() {
        return "sqlserver";
    }
}
