package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.builder.dcl.AbstractDCLBuilder;
import cn.schoolwow.quickdao.builder.dcl.PostgreDCLBuilder;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.PostgreDDLBuilder;
import cn.schoolwow.quickdao.builder.dql.AbstractDQLBuilder;
import cn.schoolwow.quickdao.dao.sql.dcl.AbstractDCLDAO;
import cn.schoolwow.quickdao.dao.sql.dcl.OracleDCLDAO;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdao.query.condition.PostgreCondition;
import cn.schoolwow.quickdao.query.subCondition.AbstractSubCondition;
import cn.schoolwow.quickdao.query.subCondition.SubCondition;

public class PostgreDatabaseProvider extends AbstractDatabaseProvider {

    @Override
    public AbstractDDLBuilder getDDLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new PostgreDDLBuilder(quickDAOConfig);
    }

    @Override
    public AbstractDCLBuilder getDCLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new PostgreDCLBuilder(quickDAOConfig);
    }

    @Override
    public AbstractDCLDAO getDCLDAOInstance(QuickDAOConfig quickDAOConfig) {
        return new OracleDCLDAO(quickDAOConfig);
    }

    @Override
    public AbstractDQLBuilder getDQLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new AbstractDQLBuilder(quickDAOConfig);
    }

    @Override
    public Condition getConditionInstance(Query query) {
        return new PostgreCondition(query);
    }

    @Override
    public SubCondition getSubConditionInstance(SubQuery subQuery) {
        return new AbstractSubCondition(subQuery);
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\""+value +"\"";
    }

    @Override
    public String name() {
        return "postgresql";
    }
}
