package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.builder.dcl.AbstractDCLBuilder;
import cn.schoolwow.quickdao.builder.dcl.MySQLDCLBuilder;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.MySQLDDLBuilder;
import cn.schoolwow.quickdao.builder.dql.AbstractDQLBuilder;
import cn.schoolwow.quickdao.dao.sql.dcl.AbstractDCLDAO;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.AbstractCondition;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdao.query.subCondition.AbstractSubCondition;
import cn.schoolwow.quickdao.query.subCondition.SubCondition;

public class MySQLDatabaseProvider extends AbstractDatabaseProvider {

    @Override
    public AbstractDDLBuilder getDDLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new MySQLDDLBuilder(quickDAOConfig);
    }

    @Override
    public AbstractDCLBuilder getDCLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new MySQLDCLBuilder(quickDAOConfig);
    }

    @Override
    public AbstractDCLDAO getDCLDAOInstance(QuickDAOConfig quickDAOConfig) {
        return new AbstractDCLDAO(quickDAOConfig);
    }

    @Override
    public AbstractDQLBuilder getDQLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        return new AbstractDQLBuilder(quickDAOConfig);
    }

    @Override
    public Condition getConditionInstance(Query query) {
        return new AbstractCondition(query);
    }

    @Override
    public SubCondition getSubConditionInstance(SubQuery subQuery) {
        return new AbstractSubCondition(subQuery);
    }

    @Override
    public String comment(String comment) {
        return "comment \"" + comment + "\"";
    }

    @Override
    public String escape(String value) {
        return "`"+value+"`";
    }

    @Override
    public String name() {
        return "mysql";
    }
}
