package cn.schoolwow.quickdao.domain.provider;

import cn.schoolwow.quickdao.builder.dcl.AbstractDCLBuilder;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.builder.dql.AbstractDQLBuilder;
import cn.schoolwow.quickdao.dao.sql.dcl.AbstractDCLDAO;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdao.query.subCondition.SubCondition;

/**数据库提供者*/
public interface DatabaseProvider {
    /**
     * 获取DDL实例
     * */
    AbstractDDLBuilder getDDLBuilderInstance(QuickDAOConfig quickDAOConfig);

    /**
     * 获取DCL Builder对象
     * */
    AbstractDCLBuilder getDCLBuilderInstance(QuickDAOConfig quickDAOConfig);

    /**
     * 获取DCL DAO对象
     * */
    AbstractDCLDAO getDCLDAOInstance(QuickDAOConfig quickDAOConfig);

    /**
     * 获取DQL实例
     * */
    AbstractDQLBuilder getDQLBuilderInstance(QuickDAOConfig quickDAOConfig);

    /**
     * 获取Condition实例
     * */
    Condition getConditionInstance(Query query);

    /**
     * 获取SubCondition实例
     * */
    SubCondition getSubConditionInstance(SubQuery subQuery);

    /**
     * 返回注释语句
     * */
    String comment(String comment);

    /**
     * 转义表,列等
     * */
    String escape(String value);

    /**
     * 数据库类型名称
     * */
    String name();
}
