/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.handler;

import cn.schoolwow.quickdao.QuickDAO;
import cn.schoolwow.quickdao.annotation.ColumnName;
import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Constraint;
import cn.schoolwow.quickdao.annotation.ForeignKey;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.Index;
import cn.schoolwow.quickdao.annotation.TableField;
import cn.schoolwow.quickdao.annotation.TableName;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.handler.DefaultTablePropertyDefiner;
import cn.schoolwow.quickdao.handler.TableDefiner;
import cn.schoolwow.quickdao.handler.TablePropertyDefiner;
import cn.schoolwow.quickdao.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableDefiner
implements TableDefiner {
    private static Logger logger = LoggerFactory.getLogger(DefaultTableDefiner.class);
    private QuickDAO quickDAO;
    private QuickDAOConfig quickDAOConfig;
    private Entity entity;

    public DefaultTableDefiner(QuickDAO quickDAO, QuickDAOConfig quickDAOConfig) {
        this.quickDAO = quickDAO;
        this.quickDAOConfig = quickDAOConfig;
    }

    public TableDefiner define(Class clazz) {
        this.entity = this.quickDAOConfig.entityMap.get(clazz.getName());
        return this;
    }

    @Override
    public TableDefiner tableName(String tableName) {
        this.entity.tableName = tableName;
        return this;
    }

    @Override
    public TableDefiner comment(String comment) {
        this.entity.comment = comment;
        return this;
    }

    @Override
    public TablePropertyDefiner property(String fieldName) {
        for (Property property : this.entity.properties) {
            if (!property.name.equals(fieldName)) continue;
            return new DefaultTablePropertyDefiner(property, this);
        }
        return null;
    }

    @Override
    public QuickDAO done() {
        return this.quickDAO;
    }

    public synchronized void getEntityMap() throws Exception {
        Entity entity;
        ArrayList<Class> classList = new ArrayList<Class>();
        for (String packageName : this.quickDAOConfig.packageNameMap.keySet()) {
            List<Class> packageClassList = this.scanEntity(packageName);
            for (Class c : packageClassList) {
                Entity entity2 = new Entity();
                if (c.getDeclaredAnnotation(TableName.class) != null) {
                    entity2.tableName = c.getDeclaredAnnotation(TableName.class).value();
                } else if (packageName.length() + c.getSimpleName().length() + 1 == c.getName().length()) {
                    entity2.tableName = this.quickDAOConfig.packageNameMap.get(packageName) + StringUtil.Camel2Underline(c.getSimpleName());
                } else {
                    String prefix = c.getName().substring(packageName.length() + 1, c.getName().lastIndexOf(".")).replace(".", "_");
                    entity2.tableName = this.quickDAOConfig.packageNameMap.get(packageName) + prefix + "@" + StringUtil.Camel2Underline(c.getSimpleName());
                }
                entity2.clazz = c;
                this.quickDAOConfig.entityMap.put(c.getName(), entity2);
            }
            classList.addAll(packageClassList);
        }
        for (Class c : this.quickDAOConfig.entityClassMap.keySet()) {
            entity = new Entity();
            entity.tableName = this.quickDAOConfig.entityClassMap.get(c).isEmpty() ? StringUtil.Camel2Underline(c.getSimpleName()) : this.quickDAOConfig.entityClassMap.get(c) + "@" + StringUtil.Camel2Underline(c.getSimpleName());
            entity.clazz = c;
            this.quickDAOConfig.entityMap.put(c.getName(), entity);
            classList.add(c);
        }
        for (Class c : classList) {
            Field[] fields;
            entity = this.quickDAOConfig.entityMap.get(c.getName());
            entity.escapeTableName = this.quickDAOConfig.database.escape(entity.tableName);
            entity.className = c.getSimpleName();
            if (c.getDeclaredAnnotation(Comment.class) != null) {
                Comment comment = c.getDeclaredAnnotation(Comment.class);
                entity.comment = comment.value();
            }
            ArrayList<Property> propertyList = new ArrayList<Property>();
            ArrayList<Field> compositFieldList = new ArrayList<Field>();
            for (Field field : fields = this.getAllField(c, compositFieldList)) {
                TableField tableField;
                Id id;
                Property property = new Property();
                property.column = null != field.getAnnotation(ColumnName.class) ? field.getAnnotation(ColumnName.class).value() : StringUtil.Camel2Underline(field.getName());
                if (null != field.getAnnotation(ColumnType.class)) {
                    property.columnType = field.getAnnotation(ColumnType.class).value();
                }
                property.name = field.getName();
                property.simpleTypeName = field.getType().getSimpleName().toLowerCase();
                property.className = field.getType().getName();
                Constraint constraint = field.getDeclaredAnnotation(Constraint.class);
                if (null != constraint) {
                    property.notNull = constraint.notNull();
                    property.unique = constraint.unique();
                    property.check = constraint.check();
                    property.defaultValue = constraint.defaultValue();
                    property.unionUnique = constraint.unionUnique();
                }
                if (property.name.equals("id")) {
                    property.id = true;
                    property.strategy = IdStrategy.AutoIncrement;
                }
                if (null != (id = field.getDeclaredAnnotation(Id.class))) {
                    property.id = true;
                    property.strategy = id.strategy();
                }
                if (null != (tableField = field.getDeclaredAnnotation(TableField.class))) {
                    if (!tableField.function().isEmpty()) {
                        property.function = tableField.function().replace("#{" + property.name + "}", "?");
                    }
                    property.createdAt = tableField.createdAt();
                    property.updateAt = tableField.updatedAt();
                }
                boolean bl = property.index = field.getDeclaredAnnotation(Index.class) != null;
                if (null != field.getDeclaredAnnotation(Comment.class)) {
                    property.comment = field.getDeclaredAnnotation(Comment.class).value();
                }
                property.foreignKey = field.getDeclaredAnnotation(ForeignKey.class);
                property.entity = entity;
                propertyList.add(property);
            }
            entity.properties = propertyList.toArray(new Property[0]);
            if (compositFieldList.size() <= 0) continue;
            entity.compositFields = compositFieldList.toArray(new Field[0]);
        }
        logger.debug("[\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f]\u5b9e\u4f53\u7c7b\u4e2a\u6570:{}", (Object)this.quickDAOConfig.entityMap.size());
    }

    public synchronized void handleEntityMap() {
        for (Entity entity : this.quickDAOConfig.entityMap.values()) {
            ArrayList<Property> indexPropertyList = new ArrayList<Property>();
            ArrayList<Property> uniquePropertyList = new ArrayList<Property>();
            ArrayList<Property> checkPropertyList = new ArrayList<Property>();
            ArrayList<Property> foreignKeyPropertyList = new ArrayList<Property>();
            for (Property property : entity.properties) {
                if (property.id) {
                    entity.id = property;
                    property.notNull = true;
                    property.unique = true;
                    property.comment = "\u81ea\u589eid";
                    if (property.strategy == IdStrategy.AutoIncrement && null != this.quickDAOConfig.idStrategy) {
                        property.strategy = this.quickDAOConfig.idStrategy;
                    }
                }
                if (property.unique) {
                    property.notNull = true;
                    if (!property.id) {
                        property.index = true;
                    }
                }
                if (property.index) {
                    indexPropertyList.add(property);
                }
                if (property.unique && property.unionUnique) {
                    uniquePropertyList.add(property);
                }
                if (null != property.check && !property.check.isEmpty()) {
                    checkPropertyList.add(property);
                }
                if (null == property.foreignKey) continue;
                foreignKeyPropertyList.add(property);
            }
            entity.indexProperties = indexPropertyList.toArray(new Property[0]);
            entity.uniqueKeyProperties = uniquePropertyList.toArray(new Property[0]);
            entity.checkProperties = checkPropertyList.toArray(new Property[0]);
            entity.foreignKeyProperties = foreignKeyPropertyList.toArray(new Property[0]);
        }
    }

    private List<Class> scanEntity(String packageName) throws ClassNotFoundException, IOException {
        String packageNamePath = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(packageNamePath);
        if (url == null) {
            logger.warn("[\u5b9e\u4f53\u7c7b\u8def\u5f84\u4e0d\u5b58\u5728]{}", (Object)packageNamePath);
            return new ArrayList<Class>();
        }
        final ArrayList<Class> classList = new ArrayList<Class>();
        switch (url.getProtocol()) {
            case "file": {
                File file = new File(url.getFile());
                logger.info("[\u7c7b\u6587\u4ef6\u8def\u5f84]{}", (Object)file.getAbsolutePath());
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                }
                final String indexOfString = packageName.replace(".", "/");
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        File f = file.toFile();
                        if (f.getName().endsWith(".class")) {
                            String path = f.getAbsolutePath().replace("\\", "/");
                            int startIndex = path.indexOf(indexOfString);
                            String className = path.substring(startIndex, path.length() - 6).replace("/", ".");
                            try {
                                classList.add(Class.forName(className));
                            }
                            catch (ClassNotFoundException e) {
                                logger.warn("[\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728]{}", (Object)className);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            case "jar": {
                JarFile jarFile;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    classList.add(classLoader.loadClass(className));
                }
                break;
            }
        }
        if (classList.size() == 0) {
            logger.warn("[\u626b\u63cf\u5b9e\u4f53\u7c7b\u4fe1\u606f\u4e3a\u7a7a]\u524d\u7f00:{},\u5305\u540d:{}", (Object)this.quickDAOConfig.packageNameMap.get(packageName), (Object)packageName);
            return classList;
        }
        Stream<Class> stream = classList.stream().filter(clazz -> !this.needIgnoreClass((Class)clazz));
        return stream.collect(Collectors.toList());
    }

    private Field[] getAllField(Class clazz, List<Field> compositFieldList) {
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        Class tempClass = clazz;
        while (null != tempClass) {
            AccessibleObject[] fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers()) || Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isTransient(((Field)field).getModifiers())) {
                    logger.debug("[\u8df3\u8fc7\u5e38\u91cf\u6216\u9759\u6001\u53d8\u91cf]{},\u8be5\u5c5e\u6027\u88abstatic\u6216\u8005final\u4fee\u9970!", (Object)((Field)field).getName());
                    continue;
                }
                if (field.getDeclaredAnnotation(Ignore.class) != null) {
                    logger.debug("[\u8df3\u8fc7\u5b9e\u4f53\u5c5e\u6027]{},\u8be5\u5c5e\u6027\u88abIgnore\u6ce8\u89e3\u4fee\u9970!", (Object)((Field)field).getName());
                    continue;
                }
                if (((Field)field).getType().isArray() || !((Field)field).getType().isPrimitive() && this.isCollection(((Field)field).getType()) || this.needIgnoreClass(((Field)field).getType())) continue;
                if (this.isCompositProperty(((Field)field).getType())) {
                    compositFieldList.add((Field)field);
                    continue;
                }
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
            if (null == (tempClass = tempClass.getSuperclass()) || !"java.lang.Object".equals(tempClass.getName())) continue;
            break;
        }
        return fieldList.toArray(new Field[0]);
    }

    private boolean isCompositProperty(Class clazz) {
        Set<String> packageNameSet = this.quickDAOConfig.packageNameMap.keySet();
        for (String packageName : packageNameSet) {
            if (!clazz.getName().contains(packageName)) continue;
            return true;
        }
        Set<Class> classSet = this.quickDAOConfig.entityClassMap.keySet();
        for (Class c : classSet) {
            if (!c.getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCollection(Class _class) {
        Stack<Class<?>[]> stack = new Stack<Class<?>[]>();
        stack.push(_class.getInterfaces());
        while (!stack.isEmpty()) {
            Class[] classes;
            for (Class clazz : classes = (Class[])stack.pop()) {
                if (clazz.getName().equals(Collection.class.getName())) {
                    return true;
                }
                Class<?>[] subClasses = clazz.getInterfaces();
                if (null == subClasses || subClasses.length <= 0) continue;
                stack.push(subClasses);
            }
        }
        return false;
    }

    private boolean needIgnoreClass(Class clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        if (clazz.getAnnotation(Ignore.class) != null) {
            return true;
        }
        if (null != this.quickDAOConfig.ignoreClassList) {
            for (Class _clazz : this.quickDAOConfig.ignoreClassList) {
                if (!_clazz.getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        if (null != this.quickDAOConfig.ignorePackageNameList) {
            for (String ignorePackageName : this.quickDAOConfig.ignorePackageNameList) {
                if (!clazz.getName().contains(ignorePackageName)) continue;
                return true;
            }
            for (Class _clazz : this.quickDAOConfig.entityClassMap.keySet()) {
                if (!_clazz.getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        return null != this.quickDAOConfig.predicate && this.quickDAOConfig.predicate.test(clazz);
    }
}

