/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.dql;

import cn.schoolwow.quickdao.builder.sql.dql.AbstractDQLSQLBuilder;
import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.dao.response.AbstractResponse;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.dql.DQLDAO;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.MDC;

public class AbstractDQLDAO
extends AbstractSQLDAO
implements DQLDAO {
    private AbstractDQLSQLBuilder dqlsqlBuilder;

    public AbstractDQLDAO(AbstractDAO abstractDAO) {
        super(abstractDAO);
        this.dqlsqlBuilder = (AbstractDQLSQLBuilder)this.sqlBuilder;
    }

    @Override
    public <T> T fetch(Class<T> clazz, long id) {
        return this.fetch(clazz, this.abstractDAO.quickDAOConfig.entityMap.get((Object)clazz.getName()).id.column, (Object)id);
    }

    @Override
    public <T> T fetch(Class<T> clazz, String field, Object value) {
        List<T> list = this.fetchList(clazz, field, value);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, String field, Object value) {
        try {
            PreparedStatement ps = null;
            ps = null == value ? this.dqlsqlBuilder.fetchNull(clazz, field) : this.dqlsqlBuilder.fetch(clazz, field, value);
            Entity entity = this.abstractDAO.quickDAOConfig.entityMap.get(clazz.getName());
            ResultSet resultSet = ps.executeQuery();
            JSONArray array = new JSONArray();
            while (resultSet.next()) {
                array.add((Object)AbstractResponse.getObject(entity, "t", resultSet));
            }
            resultSet.close();
            ps.close();
            MDC.put((String)"count", (String)(array.size() + ""));
            return array.toJavaList(clazz);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public JSONObject fetch(String tableName, String field, Object value) {
        JSONArray array = this.fetchList(tableName, field, value);
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray fetchList(String tableName, String field, Object value) {
        try {
            PreparedStatement ps = null;
            ps = null == value ? this.dqlsqlBuilder.fetchNull(tableName, field) : this.dqlsqlBuilder.fetch(tableName, field, value);
            Entity dbEntity = this.abstractDAO.quickDAOConfig.getDbEntityByTableName(tableName);
            ResultSet resultSet = ps.executeQuery();
            JSONArray array = new JSONArray();
            while (resultSet.next()) {
                array.add((Object)AbstractResponse.getObject(dbEntity, "t", resultSet));
            }
            resultSet.close();
            ps.close();
            MDC.put((String)"count", (String)(array.size() + ""));
            return array;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

