/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.dml;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.sql.dml.AbstractDMLSQLBuilder;
import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.dml.DMLDAO;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.MDC;

public class AbstractDMLDAO
extends AbstractSQLDAO
implements DMLDAO {
    private AbstractDMLSQLBuilder dmlsqlBuilder;

    public AbstractDMLDAO(AbstractDAO abstractDAO) {
        super(abstractDAO);
        this.sqlBuilder = new AbstractDMLSQLBuilder(abstractDAO.quickDAOConfig);
        this.dmlsqlBuilder = (AbstractDMLSQLBuilder)this.sqlBuilder;
    }

    @Override
    public int insert(Object instance) {
        if (null == instance) {
            return 0;
        }
        int effect = 0;
        try {
            PreparedStatement ps = this.dmlsqlBuilder.insert(instance);
            effect = ps.executeUpdate();
            Entity entity = this.dmlsqlBuilder.quickDAOConfig.entityMap.get(instance.getClass().getName());
            if (effect > 0 && null != entity.id && entity.id.strategy.equals((Object)IdStrategy.AutoIncrement)) {
                ResultSet rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    Field idField = instance.getClass().getDeclaredField(entity.id.name);
                    idField.setAccessible(true);
                    switch (idField.getType().getSimpleName().toLowerCase()) {
                        case "int": 
                        case "integer": {
                            if (idField.getType().isPrimitive()) {
                                idField.setInt(instance, rs.getInt(1));
                                break;
                            }
                            idField.set(instance, rs.getInt(1));
                            break;
                        }
                        case "long": {
                            if (idField.getType().isPrimitive()) {
                                idField.setLong(instance, rs.getLong(1));
                                break;
                            }
                            idField.set(instance, rs.getLong(1));
                            break;
                        }
                        case "string": {
                            idField.set(instance, rs.getString(1));
                        }
                    }
                }
                rs.close();
            }
            ps.close();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int insert(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        try {
            PreparedStatement[] preparedStatements = this.dmlsqlBuilder.insert(instances);
            Entity entity = this.dmlsqlBuilder.quickDAOConfig.entityMap.get(instances[0].getClass().getName());
            Field idField = null;
            if (null != entity.id && entity.id.strategy.equals((Object)IdStrategy.AutoIncrement)) {
                idField = instances[0].getClass().getDeclaredField(entity.id.name);
                idField.setAccessible(true);
            }
            for (int i = 0; i < preparedStatements.length; ++i) {
                if ((effect += preparedStatements[i].executeUpdate()) > 0 && null != idField) {
                    ResultSet rs = preparedStatements[i].getGeneratedKeys();
                    if (rs.next()) {
                        switch (idField.getType().getSimpleName().toLowerCase()) {
                            case "int": 
                            case "integer": {
                                if (idField.getType().isPrimitive()) {
                                    idField.setInt(instances[i], rs.getInt(1));
                                    break;
                                }
                                idField.set(instances[i], rs.getInt(1));
                                break;
                            }
                            case "long": {
                                if (idField.getType().isPrimitive()) {
                                    idField.setLong(instances[i], rs.getLong(1));
                                    break;
                                }
                                idField.set(instances[i], rs.getLong(1));
                                break;
                            }
                            case "string": {
                                idField.set(instances[i], rs.getString(1));
                            }
                        }
                    }
                    rs.close();
                }
                preparedStatements[i].close();
            }
            this.dmlsqlBuilder.connection.commit();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int insert(Collection instanceCollection) {
        return this.insert(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int insertBatch(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        try {
            int[] batches;
            PreparedStatement ps = this.dmlsqlBuilder.insertBatch(instances);
            for (int batch : batches = ps.executeBatch()) {
                effect += batch;
            }
            ps.close();
            this.dmlsqlBuilder.connection.commit();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int insertBatch(Collection instanceCollection) {
        return this.insertBatch(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int update(Object instance) {
        if (null == instance) {
            return 0;
        }
        int effect = 0;
        PreparedStatement ps = null;
        Entity entity = this.dmlsqlBuilder.quickDAOConfig.entityMap.get(instance.getClass().getName());
        try {
            if (entity.uniqueKeyProperties.length > 0 && entity.uniqueKeyProperties.length + 1 != entity.properties.length) {
                ps = this.dmlsqlBuilder.updateByUniqueKey(instance);
                effect = ps.executeUpdate();
            } else if (null != entity.id) {
                ps = this.dmlsqlBuilder.updateById(instance);
                effect = ps.executeUpdate();
            } else {
                this.logger.warn("[\u5ffd\u7565\u66f4\u65b0\u64cd\u4f5c]\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id,\u5ffd\u7565\u8be5\u5b9e\u4f8b\u7684\u66f4\u65b0\u64cd\u4f5c!");
            }
            if (null != ps) {
                ps.close();
            }
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int update(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        Statement ps = null;
        try {
            int[] batches;
            Entity entity = this.dmlsqlBuilder.quickDAOConfig.entityMap.get(instances[0].getClass().getName());
            if (null != entity.uniqueKeyProperties && entity.uniqueKeyProperties.length > 0 && entity.uniqueKeyProperties.length + 1 != entity.properties.length) {
                ps = this.dmlsqlBuilder.updateByUniqueKey(instances);
            } else if (null != entity.id) {
                ps = this.dmlsqlBuilder.updateById(instances);
            }
            for (int batch : batches = ps.executeBatch()) {
                effect += batch;
            }
            ps.close();
            this.dmlsqlBuilder.connection.commit();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int update(Collection instanceCollection) {
        return this.update(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int save(Object instance) {
        if (null == instance) {
            return 0;
        }
        if (this.exist(instance)) {
            return this.update(instance);
        }
        return this.insert(instance);
    }

    @Override
    public int save(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        ArrayList<Object> insertList = new ArrayList<Object>();
        ArrayList<Object> updateList = new ArrayList<Object>();
        int effect = 0;
        for (Object instance : instances) {
            if (this.exist(instance)) {
                updateList.add(instance);
                continue;
            }
            insertList.add(instance);
        }
        effect += this.update(updateList);
        MDC.put((String)"count", (String)((effect += this.insert(insertList)) + ""));
        return effect;
    }

    @Override
    public int save(Collection instanceCollection) {
        return this.save(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int delete(Class clazz, long id) {
        Entity entity = this.dmlsqlBuilder.quickDAOConfig.entityMap.get(clazz.getName());
        return this.delete(clazz, entity.id.column, (Object)id);
    }

    @Override
    public int delete(Class clazz, String id) {
        Entity entity = this.dmlsqlBuilder.quickDAOConfig.entityMap.get(clazz.getName());
        return this.delete(clazz, entity.id.column, (Object)id);
    }

    @Override
    public int delete(Class clazz, String field, Object value) {
        int effect = 0;
        try {
            PreparedStatement ps = this.dmlsqlBuilder.deleteByProperty(clazz, field, value);
            effect = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int delete(String tableName, String field, Object value) {
        int effect = 0;
        try {
            PreparedStatement ps = this.dmlsqlBuilder.deleteByProperty(tableName, field, value);
            effect = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }

    @Override
    public int clear(Class clazz) {
        int effect = 0;
        try {
            PreparedStatement ps = this.dmlsqlBuilder.clear(clazz);
            effect = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(effect + ""));
        return effect;
    }
}

