/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql;

import cn.schoolwow.quickdao.dao.condition.Condition;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SQLDAOInvocationHandler
implements InvocationHandler {
    private Logger logger = LoggerFactory.getLogger(SQLDAOInvocationHandler.class);
    private AbstractSQLDAO abstractSQLDAO;

    public SQLDAOInvocationHandler(AbstractSQLDAO abstractSQLDAO) {
        this.abstractSQLDAO = abstractSQLDAO;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (null != this.abstractSQLDAO.sqlBuilder.quickDAOConfig.reentrantLock) {
                this.abstractSQLDAO.sqlBuilder.quickDAOConfig.reentrantLock.lock();
            }
            if (this.abstractSQLDAO.transaction) {
                if (null == this.abstractSQLDAO.sqlBuilder.connection || this.abstractSQLDAO.sqlBuilder.connection.isClosed()) {
                    this.abstractSQLDAO.sqlBuilder.connection = this.abstractSQLDAO.sqlBuilder.quickDAOConfig.dataSource.getConnection();
                    if (this.abstractSQLDAO.transactionIsolation > 0) {
                        this.abstractSQLDAO.sqlBuilder.connection.setTransactionIsolation(this.abstractSQLDAO.transactionIsolation);
                    }
                    this.abstractSQLDAO.sqlBuilder.connection.setAutoCommit(false);
                }
            } else {
                this.abstractSQLDAO.sqlBuilder.connection = this.abstractSQLDAO.sqlBuilder.quickDAOConfig.dataSource.getConnection();
            }
            long startTime = System.currentTimeMillis();
            Object result = method.invoke((Object)this.abstractSQLDAO, args);
            long endTime = System.currentTimeMillis();
            if (null != MDC.get((String)"name")) {
                this.logger.debug("[{}]\u884c\u6570:{},\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", new Object[]{MDC.get((String)"name"), MDC.get((String)"count"), endTime - startTime, MDC.get((String)"sql")});
            }
            if (!(result instanceof Condition || this.abstractSQLDAO.transaction || this.abstractSQLDAO.sqlBuilder.connection.isClosed())) {
                this.abstractSQLDAO.sqlBuilder.connection.close();
            }
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            if (null != MDC.get((String)"name")) {
                this.logger.debug("[{}]\u539f\u59cbSQL:{}", (Object)MDC.get((String)"name"), (Object)MDC.get((String)"sql"));
            }
            throw e.getTargetException();
        }
        finally {
            if (null != this.abstractSQLDAO.sqlBuilder.quickDAOConfig.reentrantLock) {
                this.abstractSQLDAO.sqlBuilder.quickDAOConfig.reentrantLock.unlock();
            }
        }
    }
}

