/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql;

import cn.schoolwow.quickdao.builder.sql.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.SQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.AbstractDQLSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.DQLSQLBuilder;
import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.dao.condition.AbstractCondition;
import cn.schoolwow.quickdao.dao.condition.Condition;
import cn.schoolwow.quickdao.dao.condition.H2Condition;
import cn.schoolwow.quickdao.dao.condition.MySQLCondition;
import cn.schoolwow.quickdao.dao.condition.PostgreCondition;
import cn.schoolwow.quickdao.dao.condition.SQLServerCondition;
import cn.schoolwow.quickdao.dao.condition.SQLiteCondition;
import cn.schoolwow.quickdao.dao.sql.SQLDAO;
import cn.schoolwow.quickdao.database.H2Database;
import cn.schoolwow.quickdao.database.MySQLDatabase;
import cn.schoolwow.quickdao.database.PostgreDatabase;
import cn.schoolwow.quickdao.database.SQLServerDatabase;
import cn.schoolwow.quickdao.database.SQLiteDatabase;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AbstractSQLDAO
implements SQLDAO {
    protected Logger logger = LoggerFactory.getLogger(SQLDAO.class);
    public AbstractSQLBuilder sqlBuilder;
    public AbstractDAO abstractDAO;
    public boolean transaction = false;
    public int transactionIsolation;

    public AbstractSQLDAO(AbstractDAO abstractDAO) {
        this.sqlBuilder = SQLBuilder.getDQLSQLBuilderInstance(abstractDAO.quickDAOConfig);
        this.abstractDAO = abstractDAO;
    }

    @Override
    public boolean exist(Object instance) {
        if (null == instance) {
            return false;
        }
        boolean result = false;
        try {
            Entity entity = this.abstractDAO.quickDAOConfig.entityMap.get(instance.getClass().getName());
            PreparedStatement ps = null;
            if (null != entity.uniqueKeyProperties && entity.uniqueKeyProperties.length > 0) {
                ps = this.sqlBuilder.selectCountByUniqueKey(instance);
            } else if (null != entity.id) {
                ps = this.sqlBuilder.selectCountById(instance);
            } else {
                throw new IllegalArgumentException("\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id\u503c,\u65e0\u6cd5\u5224\u65ad!\u7c7b\u540d:" + instance.getClass().getName());
            }
            MDC.put((String)"count", (String)"0");
            ResultSet resultSet = ps.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getLong(1) > 0L;
                MDC.put((String)"count", (String)"1");
            }
            resultSet.close();
            ps.close();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return result;
    }

    @Override
    public Condition query(Class clazz) {
        Entity entity = this.abstractDAO.quickDAOConfig.entityMap.get(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u5b9e\u4f53\u7c7b:" + clazz.getName() + "!");
        }
        return this.query(entity);
    }

    @Override
    public Condition query(String tableName) {
        for (Entity entity : this.abstractDAO.quickDAOConfig.dbEntityList) {
            if (!entity.tableName.equals(tableName)) continue;
            return this.query(entity);
        }
        for (Entity entity : this.abstractDAO.quickDAOConfig.visualTableList) {
            if (!entity.tableName.equals(tableName)) continue;
            return this.query(entity);
        }
        throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8868\u540d:" + tableName + "!");
    }

    @Override
    public Condition query(Condition condition) {
        condition.execute();
        Query fromQuery = ((AbstractCondition)condition).query;
        Entity entity = new Entity();
        entity.clazz = JSONObject.class;
        AbstractDQLSQLBuilder dqlsqlBuilder = null;
        dqlsqlBuilder = this.sqlBuilder instanceof DQLSQLBuilder ? (AbstractDQLSQLBuilder)this.sqlBuilder : SQLBuilder.getDQLSQLBuilderInstance(fromQuery.quickDAOConfig);
        entity.escapeTableName = entity.tableName = "( " + dqlsqlBuilder.getArraySQL(fromQuery).toString() + " )";
        entity.properties = new Property[0];
        AbstractCondition condition1 = (AbstractCondition)this.query(entity);
        condition1.query.fromQuery = fromQuery;
        return condition1;
    }

    private Condition query(Entity entity) {
        Query query = new Query();
        query.entity = entity;
        query.quickDAOConfig = this.abstractDAO.quickDAOConfig;
        AbstractDQLSQLBuilder dqlsqlBuilder = null;
        if (this.sqlBuilder instanceof DQLSQLBuilder) {
            dqlsqlBuilder = (AbstractDQLSQLBuilder)this.sqlBuilder;
        } else {
            dqlsqlBuilder = SQLBuilder.getDQLSQLBuilderInstance(query.quickDAOConfig);
            dqlsqlBuilder.connection = this.sqlBuilder.connection;
        }
        query.dqlsqlBuilder = dqlsqlBuilder;
        query.dao = this.abstractDAO;
        query.abstractSQLDAO = this;
        if (query.quickDAOConfig.database instanceof MySQLDatabase) {
            return new MySQLCondition(query);
        }
        if (query.quickDAOConfig.database instanceof H2Database) {
            return new H2Condition(query);
        }
        if (query.quickDAOConfig.database instanceof SQLiteDatabase) {
            return new SQLiteCondition(query);
        }
        if (query.quickDAOConfig.database instanceof PostgreDatabase) {
            return new PostgreCondition(query);
        }
        if (query.quickDAOConfig.database instanceof SQLServerDatabase) {
            return new SQLServerCondition(query);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }
}

