/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.response;

import cn.schoolwow.quickdao.dao.response.Response;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AbstractResponse<T>
implements Response<T> {
    private Logger logger = LoggerFactory.getLogger(AbstractResponse.class);
    public Query query;

    public AbstractResponse(Query query) {
        this.query = query;
    }

    @Override
    public long count() {
        long count = 0L;
        this.query.parameterIndex = 1;
        try {
            PreparedStatement ps = this.query.dqlsqlBuilder.count(this.query);
            ResultSet resultSet = ps.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            resultSet.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        this.query.parameterIndex = 1;
        return count;
    }

    @Override
    public int insert() {
        int count = 0;
        try {
            if (null != this.query.insertArray) {
                PreparedStatement[] preparedStatements = this.query.dqlsqlBuilder.insertArray(this.query);
                for (int i = 0; i < preparedStatements.length; ++i) {
                    if ((count += preparedStatements[i].executeUpdate()) > 0) {
                        ResultSet rs = preparedStatements[i].getGeneratedKeys();
                        if (rs.next()) {
                            this.query.insertArray.getJSONObject(i).put("generatedKeys", (Object)rs.getString(1));
                        }
                        rs.close();
                    }
                    preparedStatements[i].close();
                }
                this.query.dqlsqlBuilder.connection.commit();
            } else {
                PreparedStatement ps = this.query.dqlsqlBuilder.insert(this.query);
                count = ps.executeUpdate();
                if (count > 0 && null != this.query.insertValue) {
                    ResultSet rs = ps.getGeneratedKeys();
                    if (rs.next()) {
                        this.query.insertValue.put("generatedKeys", (Object)rs.getString(1));
                    }
                    rs.close();
                }
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(count + ""));
        return count;
    }

    @Override
    public int update() {
        int count = 0;
        try {
            PreparedStatement ps = this.query.dqlsqlBuilder.update(this.query);
            count = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(count + ""));
        return count;
    }

    @Override
    public int delete() {
        int count = 0;
        try {
            PreparedStatement ps = this.query.dqlsqlBuilder.delete(this.query);
            count = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        MDC.put((String)"count", (String)(count + ""));
        return count;
    }

    @Override
    public T getOne() {
        List list = this.getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <E> E getOne(Class<E> clazz) {
        List<E> list = this.getList(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <E> E getSingleColumn(Class<E> clazz) {
        List<E> list = this.getSingleColumnList(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <E> List<E> getSingleColumnList(Class<E> clazz) {
        try {
            PreparedStatement ps = this.query.dqlsqlBuilder.getArray(this.query);
            JSONArray array = new JSONArray(this.query.dqlsqlBuilder.getResultSetRowCount(this.query));
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                array.add((Object)resultSet.getString(1));
            }
            resultSet.close();
            ps.close();
            return array.toJavaList(clazz);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public List getList() {
        return this.getList(this.query.entity.clazz);
    }

    @Override
    public <E> List<E> getList(Class<E> clazz) {
        return this.getArray().toJavaList(clazz);
    }

    @Override
    public PageVo<T> getPagingList() {
        this.query.pageVo.setList(this.getArray().toJavaList(this.query.entity.clazz));
        this.setPageVo();
        return this.query.pageVo;
    }

    @Override
    public JSONObject getObject() {
        JSONArray array = this.getArray();
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray getArray() {
        JSONArray array = null;
        try {
            PreparedStatement ps = this.query.dqlsqlBuilder.getArray(this.query);
            array = new JSONArray(this.query.dqlsqlBuilder.getResultSetRowCount(this.query));
            ResultSet resultSet = ps.executeQuery();
            if (this.query.columnBuilder.length() > 0) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                String[] columnNames = new String[metaData.getColumnCount()];
                for (int i = 1; i <= columnNames.length; ++i) {
                    columnNames[i - 1] = metaData.getColumnLabel(i);
                }
                while (resultSet.next()) {
                    JSONObject o = new JSONObject(true);
                    for (int i = 1; i <= columnNames.length; ++i) {
                        o.put(columnNames[i - 1], (Object)resultSet.getString(i));
                    }
                    array.add((Object)o);
                }
            } else {
                while (resultSet.next()) {
                    JSONObject o = AbstractResponse.getObject(this.query.entity, this.query.tableAliasName, resultSet);
                    if (this.query.compositField) {
                        this.getCompositObject(resultSet, o);
                    }
                    array.add((Object)o);
                }
            }
            MDC.put((String)"count", (String)(array.size() + ""));
            resultSet.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return array;
    }

    private void setPageVo() {
        if (this.query.pageVo == null) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528page()\u51fd\u6570!");
        }
        this.query.pageVo.setTotalSize(this.count());
        this.query.pageVo.setTotalPage((int)(this.query.pageVo.getTotalSize() / (long)this.query.pageVo.getPageSize() + (long)(this.query.pageVo.getTotalSize() % (long)this.query.pageVo.getPageSize() > 0L ? 1 : 0)));
        this.query.pageVo.setHasMore(this.query.pageVo.getCurrentPage() < this.query.pageVo.getTotalPage());
    }

    public static JSONObject getObject(Entity entity, String tableAliasName, ResultSet resultSet) throws SQLException {
        JSONObject subObject = new JSONObject(true);
        block21: for (Property property : entity.properties) {
            String key;
            String columnName = tableAliasName + "_" + property.column;
            String string = key = property.name == null ? property.column : property.name;
            if (null == property.simpleTypeName) {
                subObject.put(key, (Object)resultSet.getString(columnName));
                continue;
            }
            switch (property.simpleTypeName) {
                case "boolean": {
                    subObject.put(key, (Object)resultSet.getBoolean(columnName));
                    continue block21;
                }
                case "int": 
                case "integer": {
                    subObject.put(key, (Object)resultSet.getInt(columnName));
                    continue block21;
                }
                case "float": {
                    subObject.put(key, (Object)Float.valueOf(resultSet.getFloat(columnName)));
                    continue block21;
                }
                case "long": {
                    subObject.put(key, (Object)resultSet.getLong(columnName));
                    continue block21;
                }
                case "double": {
                    subObject.put(key, (Object)resultSet.getDouble(columnName));
                    continue block21;
                }
                case "string": {
                    subObject.put(key, (Object)resultSet.getString(columnName));
                    continue block21;
                }
                case "localdate": {
                    Timestamp date = resultSet.getTimestamp(columnName);
                    LocalDate localDate = Instant.ofEpochMilli(((Date)date).getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                    subObject.put(key, (Object)localDate);
                    continue block21;
                }
                case "localdatetime": {
                    Timestamp date = resultSet.getTimestamp(columnName);
                    LocalDateTime localDateTime = Instant.ofEpochMilli(((Date)date).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                    subObject.put(key, (Object)localDateTime);
                    continue block21;
                }
                default: {
                    subObject.put(key, resultSet.getObject(columnName));
                }
            }
        }
        return subObject;
    }

    private void getCompositObject(ResultSet resultSet, JSONObject o) throws SQLException {
        for (SubQuery subQuery : this.query.subQueryList) {
            if (null == subQuery.compositField || subQuery.compositField.isEmpty()) continue;
            JSONObject subObject = AbstractResponse.getObject(subQuery.entity, subQuery.tableAliasName, resultSet);
            SubQuery parentSubQuery = subQuery.parentSubQuery;
            if (parentSubQuery == null) {
                o.put(subQuery.compositField, (Object)subObject);
                continue;
            }
            ArrayList<String> fieldNames = new ArrayList<String>();
            while (parentSubQuery != null) {
                fieldNames.add(parentSubQuery.compositField);
                parentSubQuery = parentSubQuery.parentSubQuery;
            }
            JSONObject oo = o;
            for (int i = fieldNames.size() - 1; i >= 0; --i) {
                oo = oo.getJSONObject((String)fieldNames.get(i));
            }
            oo.put(subQuery.compositField, (Object)subObject);
        }
    }
}

