/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.condition;

import cn.schoolwow.quickdao.builder.sql.SQLBuilder;
import cn.schoolwow.quickdao.dao.condition.Condition;
import cn.schoolwow.quickdao.dao.condition.subCondition.AbstractSubCondition;
import cn.schoolwow.quickdao.dao.condition.subCondition.SQLiteSubCondition;
import cn.schoolwow.quickdao.dao.condition.subCondition.SubCondition;
import cn.schoolwow.quickdao.dao.response.AbstractResponse;
import cn.schoolwow.quickdao.dao.response.Response;
import cn.schoolwow.quickdao.dao.response.ResponseInvocationHandler;
import cn.schoolwow.quickdao.dao.response.UnionType;
import cn.schoolwow.quickdao.database.SQLiteDatabase;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class AbstractCondition<T>
implements Condition<T>,
Serializable {
    public Query query;

    public AbstractCondition(Query query) {
        this.query = query;
    }

    @Override
    public Condition<T> tableAliasName(String tableAliasName) {
        this.query.tableAliasName = tableAliasName;
        return this;
    }

    @Override
    public Condition<T> distinct() {
        this.query.distinct = "distinct";
        return this;
    }

    @Override
    public Condition<T> addNullQuery(String field) {
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " is null) and ");
        return this;
    }

    @Override
    public Condition<T> addNotNullQuery(String field) {
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " is not null) and ");
        return this;
    }

    @Override
    public Condition<T> addEmptyQuery(String field) {
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " is not null and " + this.getQueryColumnNameByFieldName(field) + " = '') and ");
        return this;
    }

    @Override
    public Condition<T> addNotEmptyQuery(String field) {
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " is not null and " + this.getQueryColumnNameByFieldName(field) + " != '') and ");
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, String inQuery) {
        if (null == inQuery || inQuery.isEmpty()) {
            this.query.whereBuilder.append("( 1 = 2 ) and ");
            return this;
        }
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " in (" + inQuery + ") ) and ");
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "in");
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, Collection values) {
        return this.addInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public Condition<T> addNotInQuery(String field, String inQuery) {
        if (null == inQuery || inQuery.isEmpty()) {
            this.query.whereBuilder.append("( 1 = 2 ) and ");
            return this;
        }
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " not in (" + inQuery + ") ) and ");
        return this;
    }

    @Override
    public Condition<T> addNotInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "not in");
        return this;
    }

    @Override
    public Condition<T> addNotInQuery(String field, Collection values) {
        return this.addNotInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public Condition<T> addBetweenQuery(String field, Object start, Object end) {
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " between ? and ? ) and ");
        this.query.parameterList.add(start);
        this.query.parameterList.add(end);
        return this;
    }

    @Override
    public Condition<T> addLikeQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " like ?) and ");
        this.query.parameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addQuery(String field, Object value) {
        this.addQuery(field, "=", value);
        return this;
    }

    @Override
    public Condition<T> addQuery(String field, String operator, Object value) {
        if (null == value) {
            this.addNullQuery(field);
        } else if (value.toString().isEmpty()) {
            this.addEmptyQuery(field);
        } else {
            Property property = this.query.entity.getPropertyByFieldName(field);
            this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " " + operator + " " + (null == property || null == property.function ? "?" : property.function) + ") and ");
            this.query.parameterList.add(value);
        }
        return this;
    }

    @Override
    public Condition<T> addRawQuery(String query, Object ... parameterList) {
        this.query.whereBuilder.append("(" + query + ") and ");
        if (null != parameterList && parameterList.length > 0) {
            this.query.parameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> addSubQuery(String field, String operator, Condition subQuery) {
        subQuery.execute();
        AbstractCondition abstractCondition = (AbstractCondition)subQuery;
        abstractCondition.query.tableAliasName = this.query.tableAliasName + this.query.joinTableIndex++;
        this.query.whereBuilder.append(this.getQueryColumnNameByFieldName(field) + " " + operator + " (" + this.query.dqlsqlBuilder.getArraySQL(abstractCondition.query) + ") and ");
        this.query.parameterList.addAll(abstractCondition.query.parameterList);
        return this;
    }

    @Override
    public Condition<T> addExistSubQuery(Condition subQuery) {
        this.addExistSubQuery(subQuery, "exists");
        return this;
    }

    @Override
    public Condition<T> addNotExistSubQuery(Condition subQuery) {
        this.addExistSubQuery(subQuery, "not exists");
        return this;
    }

    @Override
    public Condition<T> addColumn(String ... fields) {
        for (String field : fields) {
            this.query.columnBuilder.append(this.query.entity.getColumnNameByFieldName(field) + ",");
        }
        return this;
    }

    @Override
    public Condition<T> addColumn(Condition subQuery) {
        subQuery.execute();
        Query selectQuery = ((AbstractCondition)subQuery).query;
        this.query.columnBuilder.append("( " + this.query.dqlsqlBuilder.getArraySQL(selectQuery) + " ),");
        this.query.parameterList.addAll(selectQuery.parameterList);
        return this;
    }

    @Override
    public Condition<T> addColumn(Condition subQuery, String columnNameAlias) {
        subQuery.execute();
        Query selectQuery = ((AbstractCondition)subQuery).query;
        this.query.columnBuilder.append("( " + this.query.dqlsqlBuilder.getArraySQL(selectQuery) + ") " + columnNameAlias + ",");
        this.query.selectQueryList.add(selectQuery);
        return this;
    }

    @Override
    public Condition<T> addInsert(String field, Object value) {
        this.query.insertBuilder.append(this.query.quickDAOConfig.database.escape(this.query.entity.getColumnNameByFieldName(field)) + ",");
        this.query.insertParameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addInsert(JSONObject value) {
        Property[] properties;
        if (null == value || value.isEmpty()) {
            throw new IllegalArgumentException("value\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (Property property : properties = this.query.entity.properties) {
            if (!value.containsKey((Object)property.column)) continue;
            this.addInsert(property.column, value.get((Object)property.column));
        }
        this.query.insertValue = value;
        return this;
    }

    @Override
    public Condition<T> addInsert(JSONArray array) {
        if (null == array || array.isEmpty()) {
            throw new IllegalArgumentException("array\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.query.insertArray = array;
        return this;
    }

    @Override
    public Condition<T> addUpdate(String field, Object value) {
        this.query.setBuilder.append(this.query.quickDAOConfig.database.escape(this.query.entity.getColumnNameByFieldName(field)) + " = ?,");
        this.query.updateParameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addJSONObjectQuery(JSONObject queryCondition) {
        JSONArray _joinTables;
        int i;
        JSONArray array;
        Property[] properties;
        for (Property property : properties = this.query.entity.properties) {
            if (queryCondition.containsKey((Object)property.name)) {
                this.addQuery(property.name, queryCondition.get((Object)property.name));
            }
            if (queryCondition.containsKey((Object)(property.name + "Start"))) {
                this.addQuery(property.name, ">=", queryCondition.get((Object)(property.name + "Start")));
            }
            if (queryCondition.containsKey((Object)(property.name + "End"))) {
                this.addQuery(property.name, "<=", queryCondition.get((Object)(property.name + "End")));
            }
            if (queryCondition.containsKey((Object)(property.name + "IN"))) {
                this.addInQuery(property.name, (Collection)queryCondition.getJSONArray(property.name + "IN"));
            }
            if (queryCondition.containsKey((Object)(property.name + "LIKE"))) {
                this.addLikeQuery(property.name, queryCondition.get((Object)(property.name + "LIKE")));
            }
            if (queryCondition.containsKey((Object)(property.name + "NOTNULL"))) {
                this.addNotNullQuery(property.name);
            }
            if (queryCondition.containsKey((Object)(property.name + "NULL"))) {
                this.addNullQuery(property.name);
            }
            if (!queryCondition.containsKey((Object)(property.name + "NOTEMPTY"))) continue;
            this.addNotEmptyQuery(property.name);
        }
        if (queryCondition.containsKey((Object)"_orderBy")) {
            if (queryCondition.get((Object)"_orderBy") instanceof String) {
                this.orderBy(queryCondition.getString("_orderBy"));
            } else if (queryCondition.get((Object)"_orderBy") instanceof JSONArray) {
                array = queryCondition.getJSONArray("_orderBy");
                for (i = 0; i < array.size(); ++i) {
                    this.orderBy(array.getString(i));
                }
            }
        }
        if (queryCondition.containsKey((Object)"_orderByDesc")) {
            if (queryCondition.get((Object)"_orderByDesc") instanceof String) {
                this.orderByDesc(queryCondition.getString("_orderByDesc"));
            } else if (queryCondition.get((Object)"_orderByDesc") instanceof JSONArray) {
                array = queryCondition.getJSONArray("_orderByDesc");
                for (i = 0; i < array.size(); ++i) {
                    this.orderByDesc(array.getString(i));
                }
            }
        }
        if (queryCondition.containsKey((Object)"_pageNumber") && queryCondition.containsKey((Object)"_pageSize")) {
            this.page(queryCondition.getInteger("_pageNumber"), queryCondition.getInteger("_pageSize"));
        }
        if ((_joinTables = queryCondition.getJSONArray("_joinTables")) == null || _joinTables.size() == 0) {
            return this;
        }
        try {
            Stack subConditionStack = new Stack();
            Stack<JSONArray> joinTablesStack = new Stack<JSONArray>();
            for (int i2 = 0; i2 < _joinTables.size(); ++i2) {
                JSONObject _joinTable = _joinTables.getJSONObject(i2);
                String primaryField = _joinTable.getString("_primaryField");
                String joinTableField = _joinTable.getString("_joinTableField");
                SubCondition subCondition = this.joinTable(Class.forName(_joinTable.getString("_class")), primaryField, joinTableField);
                this.addSubConditionQuery(subCondition, _joinTable);
                if (!_joinTable.containsKey((Object)"_joinTables")) continue;
                subConditionStack.push(subCondition);
                joinTablesStack.push(_joinTable.getJSONArray("_joinTables"));
                while (!joinTablesStack.isEmpty()) {
                    _joinTables = (JSONArray)joinTablesStack.pop();
                    subCondition = (SubCondition)subConditionStack.pop();
                    this.addSubConditionQuery(subCondition, _joinTable);
                    for (int j = 0; j < _joinTables.size(); ++j) {
                        _joinTable = _joinTables.getJSONObject(j);
                        primaryField = _joinTable.getString("_primaryField");
                        joinTableField = _joinTable.getString("_joinTableField");
                        SubCondition<?> _subCondition = subCondition.joinTable(Class.forName(_joinTable.getString("_class")), primaryField, joinTableField);
                        if (!_joinTable.containsKey((Object)"_joinTables")) continue;
                        subConditionStack.push(_subCondition);
                        joinTablesStack.push(_joinTable.getJSONArray("_joinTables"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    @Override
    public Condition<T> union(Condition<T> condition) {
        return this.union(condition, UnionType.Union);
    }

    @Override
    public Condition<T> union(Condition<T> condition, UnionType unionType) {
        AbstractCondition abstractCondition = (AbstractCondition)condition;
        abstractCondition.query.unionType = unionType;
        this.query.unionList.add(abstractCondition);
        return this;
    }

    @Override
    public Condition<T> or() {
        AbstractCondition orCondition = (AbstractCondition)this.query.dao.query(this.query.entity.clazz);
        this.query.orList.add(orCondition);
        return orCondition;
    }

    @Override
    public Condition<T> or(String or, Object ... parameterList) {
        this.query.whereBuilder.replace(this.query.whereBuilder.length() - 5, this.query.whereBuilder.length(), " or ");
        this.query.whereBuilder.append("(" + or + ") and ");
        if (null != parameterList && parameterList.length > 0) {
            this.query.parameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> groupBy(String ... fields) {
        for (String field : fields) {
            this.query.groupByBuilder.append(this.getQueryColumnNameByFieldName(field) + ",");
        }
        return this;
    }

    @Override
    public Condition<T> having(String having, Object ... parameterList) {
        this.query.havingBuilder.append("(" + having + ") and ");
        if (null != parameterList && parameterList.length > 0) {
            this.query.havingParameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> having(String field, String operator, Condition subQuery) {
        subQuery.execute();
        AbstractCondition abstractCondition = (AbstractCondition)subQuery;
        this.query.havingBuilder.append(this.getQueryColumnNameByFieldName(field) + " " + operator + " (" + this.query.dqlsqlBuilder.getArraySQL(abstractCondition.query) + ") and ");
        this.query.parameterList.addAll(abstractCondition.query.parameterList);
        return this;
    }

    @Override
    public <E> SubCondition<E> crossJoinTable(Class<E> clazz) {
        SubQuery subQuery = new SubQuery();
        subQuery.entity = this.query.quickDAOConfig.entityMap.get(clazz.getName());
        subQuery.tableAliasName = this.query.tableAliasName + this.query.joinTableIndex++;
        subQuery.join = "cross join";
        subQuery.query = this.query;
        subQuery.condition = this;
        AbstractSubCondition subCondition = null;
        subCondition = this.query.quickDAOConfig.database instanceof SQLiteDatabase ? new SQLiteSubCondition(subQuery) : new AbstractSubCondition(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public <E> SubCondition<E> crossJoinTable(String tableName) {
        SubQuery subQuery = new SubQuery();
        for (Entity entity : this.query.quickDAOConfig.dbEntityList) {
            if (!entity.tableName.equals(tableName)) continue;
            subQuery.entity = entity;
            break;
        }
        if (null == subQuery.entity) {
            throw new IllegalArgumentException("\u5173\u8054\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        subQuery.tableAliasName = this.query.tableAliasName + this.query.joinTableIndex++;
        subQuery.join = "cross join";
        subQuery.query = this.query;
        subQuery.condition = this;
        AbstractSubCondition subCondition = null;
        subCondition = this.query.quickDAOConfig.database instanceof SQLiteDatabase ? new SQLiteSubCondition(subQuery) : new AbstractSubCondition(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public <E> SubCondition<E> joinTable(Class<E> clazz, String primaryField, String joinTableField) {
        return this.joinTable(clazz, primaryField, joinTableField, this.getUniqueCompositFieldInMainClass(this.query.entity.clazz, clazz));
    }

    @Override
    public <E> SubCondition<E> joinTable(Class<E> clazz, String primaryField, String joinTableField, String compositField) {
        SubQuery subQuery = new SubQuery();
        subQuery.entity = this.query.quickDAOConfig.entityMap.get(clazz.getName());
        subQuery.tableAliasName = this.query.tableAliasName + this.query.joinTableIndex++;
        subQuery.primaryField = this.query.entity.getColumnNameByFieldName(primaryField);
        for (Property property : subQuery.entity.properties) {
            if (!property.name.equals(joinTableField)) continue;
            subQuery.joinTableField = property.column;
            break;
        }
        if (null == subQuery.joinTableField) {
            subQuery.joinTableField = joinTableField;
        }
        subQuery.compositField = compositField;
        subQuery.query = this.query;
        subQuery.condition = this;
        AbstractSubCondition subCondition = null;
        subCondition = this.query.quickDAOConfig.database instanceof SQLiteDatabase ? new SQLiteSubCondition(subQuery) : new AbstractSubCondition(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public <E> SubCondition<E> joinTable(Condition<E> joinCondition, String primaryField, String joinConditionField) {
        joinCondition.execute();
        Query joinQuery = ((AbstractCondition)joinCondition).query;
        SubQuery subQuery = new SubQuery();
        subQuery.entity = joinQuery.entity;
        subQuery.subQuerySQLBuilder = joinQuery.dqlsqlBuilder.getArraySQL(joinQuery);
        subQuery.tableAliasName = this.query.tableAliasName + this.query.joinTableIndex++;
        subQuery.primaryField = this.query.entity.getColumnNameByFieldName(primaryField);
        subQuery.joinTableField = joinConditionField;
        subQuery.subQuery = joinQuery;
        subQuery.condition = this;
        subQuery.query = this.query;
        AbstractSubCondition subCondition = null;
        subCondition = this.query.quickDAOConfig.database instanceof SQLiteDatabase ? new SQLiteSubCondition(subQuery) : new AbstractSubCondition(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public SubCondition<T> joinTable(String tableName, String primaryField, String joinTableField) {
        SubQuery subQuery = new SubQuery();
        for (Entity entity : this.query.quickDAOConfig.dbEntityList) {
            if (!entity.tableName.equals(tableName)) continue;
            subQuery.entity = entity;
            break;
        }
        if (null == subQuery.entity) {
            throw new IllegalArgumentException("\u5173\u8054\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        subQuery.tableAliasName = this.query.tableAliasName + this.query.joinTableIndex++;
        subQuery.primaryField = this.query.entity.getColumnNameByFieldName(primaryField);
        subQuery.joinTableField = joinTableField;
        subQuery.query = this.query;
        subQuery.condition = this;
        AbstractSubCondition subCondition = null;
        subCondition = this.query.quickDAOConfig.database instanceof SQLiteDatabase ? new SQLiteSubCondition(subQuery) : new AbstractSubCondition(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public Condition<T> orderBy(String ... fields) {
        for (String field : fields) {
            this.query.orderByBuilder.append(this.getQueryColumnNameByFieldName(field) + " asc,");
        }
        return this;
    }

    @Override
    public Condition<T> orderByDesc(String ... fields) {
        for (String field : fields) {
            this.query.orderByBuilder.append(this.getQueryColumnNameByFieldName(field) + " desc,");
        }
        return this;
    }

    @Override
    public Condition<T> limit(long offset, long limit) {
        this.query.limit = "limit " + offset + "," + limit;
        return this;
    }

    @Override
    public Condition<T> page(int pageNum, int pageSize) {
        this.query.limit = "limit " + (pageNum - 1) * pageSize + "," + pageSize;
        this.query.pageVo = new PageVo();
        this.query.pageVo.setPageSize(pageSize);
        this.query.pageVo.setCurrentPage(pageNum);
        return this;
    }

    @Override
    public Condition<T> compositField() {
        this.query.compositField = true;
        return this;
    }

    @Override
    public Response<T> execute() {
        if (this.query.columnBuilder.length() > 0) {
            this.query.columnBuilder.deleteCharAt(this.query.columnBuilder.length() - 1);
        }
        if (this.query.setBuilder.length() > 0) {
            this.query.setBuilder.deleteCharAt(this.query.setBuilder.length() - 1);
            this.query.setBuilder.insert(0, "set ");
        }
        if (this.query.insertBuilder.length() > 0) {
            this.query.insertBuilder.deleteCharAt(this.query.insertBuilder.length() - 1);
        }
        if (this.query.whereBuilder.length() > 0) {
            this.query.whereBuilder.delete(this.query.whereBuilder.length() - 5, this.query.whereBuilder.length());
            this.query.whereBuilder.insert(0, "where ");
        }
        if (this.query.groupByBuilder.length() > 0) {
            this.query.groupByBuilder.deleteCharAt(this.query.groupByBuilder.length() - 1);
            this.query.groupByBuilder.insert(0, "group by ");
        }
        if (this.query.havingBuilder.length() > 0) {
            this.query.havingBuilder.delete(this.query.havingBuilder.length() - 5, this.query.havingBuilder.length());
            this.query.havingBuilder.insert(0, "having ");
        }
        if (this.query.orderByBuilder.length() > 0) {
            this.query.orderByBuilder.deleteCharAt(this.query.orderByBuilder.length() - 1);
            this.query.orderByBuilder.insert(0, "order by ");
        }
        for (SubQuery subQuery : this.query.subQueryList) {
            if (subQuery.whereBuilder.length() <= 0) continue;
            subQuery.whereBuilder.delete(subQuery.whereBuilder.length() - 5, subQuery.whereBuilder.length());
        }
        for (AbstractCondition condition : this.query.unionList) {
            condition.execute();
        }
        for (AbstractCondition condition : this.query.orList) {
            condition.execute();
            condition.query.whereBuilder.delete(0, 5);
        }
        AbstractResponse abstractResponse = new AbstractResponse(this.query);
        ResponseInvocationHandler invocationHandler = new ResponseInvocationHandler(abstractResponse);
        return (Response)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Response.class}, (InvocationHandler)invocationHandler);
    }

    @Override
    public Condition<T> clone() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.query);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Query query = (Query)ois.readObject();
            AbstractCondition<T> abstractCondition = new AbstractCondition<T>(query);
            query.entity = this.query.entity;
            query.unionType = this.query.unionType;
            query.quickDAOConfig = this.query.quickDAOConfig;
            query.abstractSQLDAO = this.query.abstractSQLDAO;
            query.dqlsqlBuilder = SQLBuilder.getDQLSQLBuilderInstance(query.quickDAOConfig);
            if (query.abstractSQLDAO.transaction) {
                if (null == query.dqlsqlBuilder.connection || query.dqlsqlBuilder.connection.isClosed()) {
                    query.dqlsqlBuilder.connection = query.quickDAOConfig.dataSource.getConnection();
                    if (query.abstractSQLDAO.transactionIsolation > 0) {
                        query.dqlsqlBuilder.connection.setTransactionIsolation(query.abstractSQLDAO.transactionIsolation);
                    }
                    query.dqlsqlBuilder.connection.setAutoCommit(false);
                }
            } else {
                query.dqlsqlBuilder.connection = query.quickDAOConfig.dataSource.getConnection();
            }
            for (int i = 0; i < query.subQueryList.size(); ++i) {
                query.subQueryList.get((int)i).entity = this.query.subQueryList.get((int)i).entity;
                query.subQueryList.get((int)i).query = query;
                query.subQueryList.get((int)i).condition = abstractCondition;
            }
            return abstractCondition;
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUniqueCompositFieldInMainClass(Class mainClass, Class fieldClass) {
        if (!this.query.quickDAOConfig.entityMap.containsKey(mainClass.getName())) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728\u6216\u8005\u672a\u88ab\u626b\u63cf!\u5b9e\u4f53\u7c7b\u540d:" + mainClass.getName());
        }
        Entity entity = this.query.quickDAOConfig.entityMap.get(mainClass.getName());
        Field[] fields = entity.compositFields;
        if (fields == null || fields.length == 0) {
            return null;
        }
        int count = 0;
        String fieldName = null;
        for (Field field : fields) {
            if (!field.getType().getName().equalsIgnoreCase(fieldClass.getName())) continue;
            fieldName = field.getName();
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return fieldName;
        }
        throw new IllegalArgumentException("\u7c7b[" + mainClass.getName() + "]\u5b58\u5728[" + count + "]\u4e2a\u7c7b\u578b\u4e3a[" + fieldClass.getName() + "]\u7684\u6210\u5458\u53d8\u91cf!\u8bf7\u624b\u52a8\u6307\u5b9a\u9700\u8981\u5173\u8054\u7684\u5b9e\u4f53\u7c7b\u6210\u5458\u53d8\u91cf!");
    }

    private void addInQuery(String field, Object[] values, String in) {
        if (null == values || values.length == 0) {
            this.query.whereBuilder.append("( 1 = 2 ) and ");
            return;
        }
        this.query.whereBuilder.append("(" + this.getQueryColumnNameByFieldName(field) + " " + in + " (");
        for (int i = 0; i < values.length; ++i) {
            this.query.whereBuilder.append("?,");
        }
        this.query.whereBuilder.deleteCharAt(this.query.whereBuilder.length() - 1);
        this.query.whereBuilder.append(") ) and ");
        this.query.parameterList.addAll(Arrays.asList(values));
    }

    private void addExistSubQuery(Condition subQuery, String exist) {
        subQuery.execute();
        AbstractCondition abstractCondition = (AbstractCondition)subQuery;
        this.query.whereBuilder.append(exist + " (" + this.query.dqlsqlBuilder.getArraySQL(abstractCondition.query) + ") and ");
        this.query.parameterList.addAll(abstractCondition.query.parameterList);
    }

    private void addSubConditionQuery(SubCondition subCondition, JSONObject _joinTable) {
        int j;
        JSONArray array;
        Property[] properties;
        for (Property property : properties = this.query.quickDAOConfig.entityMap.get((Object)_joinTable.getString((String)"_class")).properties) {
            if (_joinTable.containsKey((Object)property.name)) {
                subCondition.addQuery(property.name, _joinTable.get((Object)property.name));
            }
            if (_joinTable.containsKey((Object)(property.name + "Start"))) {
                subCondition.addQuery(property.name, ">=", _joinTable.get((Object)(property.name + "Start")));
            }
            if (_joinTable.containsKey((Object)(property.name + "End"))) {
                subCondition.addQuery(property.name, "<=", _joinTable.get((Object)(property.name + "End")));
            }
            if (_joinTable.containsKey((Object)(property.name + "IN"))) {
                subCondition.addInQuery(property.name, (List)_joinTable.getJSONArray(property.name + "IN"));
            }
            if (_joinTable.containsKey((Object)(property.name + "LIKE"))) {
                subCondition.addLikeQuery(property.name, _joinTable.get((Object)(property.name + "LIKE")));
            }
            if (_joinTable.containsKey((Object)(property.name + "NOTNULL"))) {
                subCondition.addNotNullQuery(property.name);
            }
            if (_joinTable.containsKey((Object)(property.name + "NULL"))) {
                subCondition.addNullQuery(property.name);
            }
            if (!_joinTable.containsKey((Object)(property.name + "NOTEMPTY"))) continue;
            subCondition.addNotEmptyQuery(property.name);
        }
        if (_joinTable.containsKey((Object)"_orderBy")) {
            if (_joinTable.get((Object)"_orderBy") instanceof String) {
                subCondition.orderBy(_joinTable.getString("_orderBy"));
            } else if (_joinTable.get((Object)"_orderBy") instanceof JSONArray) {
                array = _joinTable.getJSONArray("_orderBy");
                for (j = 0; j < array.size(); ++j) {
                    subCondition.orderBy(array.getString(j));
                }
            }
        }
        if (_joinTable.containsKey((Object)"_orderByDesc")) {
            if (_joinTable.get((Object)"_orderByDesc") instanceof String) {
                subCondition.orderByDesc(_joinTable.getString("_orderByDesc"));
            } else if (_joinTable.get((Object)"_orderByDesc") instanceof JSONArray) {
                array = _joinTable.getJSONArray("_orderByDesc");
                for (j = 0; j < array.size(); ++j) {
                    subCondition.orderByDesc(array.getString(j));
                }
            }
        }
        subCondition.done();
    }

    private String getQueryColumnNameByFieldName(String field) {
        Property property = this.query.entity.getPropertyByFieldName(field);
        if (null == property) {
            return field;
        }
        if (this.query.unionList.isEmpty()) {
            return this.query.tableAliasName + "." + this.query.quickDAOConfig.database.escape(property.column);
        }
        return this.query.quickDAOConfig.database.escape(property.column);
    }
}

