/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.table.TableBuilder;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.condition.Condition;
import cn.schoolwow.quickdao.dao.sql.SQLDAOInvocationHandler;
import cn.schoolwow.quickdao.dao.sql.dml.AbstractDMLDAO;
import cn.schoolwow.quickdao.dao.sql.dml.DMLDAO;
import cn.schoolwow.quickdao.dao.sql.dql.AbstractDQLDAO;
import cn.schoolwow.quickdao.dao.sql.dql.DQLDAO;
import cn.schoolwow.quickdao.dao.sql.transaction.AbstractTransaction;
import cn.schoolwow.quickdao.dao.sql.transaction.Transaction;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDAO
implements DAO {
    private Logger logger = LoggerFactory.getLogger(DAO.class);
    private TableBuilder tableBuilder;
    public QuickDAOConfig quickDAOConfig;

    public AbstractDAO(TableBuilder tableBuilder, QuickDAOConfig quickDAOConfig) {
        this.tableBuilder = tableBuilder;
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public boolean exist(Object instance) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.exist(instance);
    }

    @Override
    public <T> T fetch(Class<T> clazz, long id) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.fetch(clazz, id);
    }

    @Override
    public <T> T fetch(Class<T> clazz, String property, Object value) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.fetch(clazz, property, value);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, String property, Object value) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.fetchList(clazz, property, value);
    }

    @Override
    public JSONObject fetch(String tableName, String field, Object value) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.fetch(tableName, field, value);
    }

    @Override
    public JSONArray fetchList(String tableName, String field, Object value) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.fetchList(tableName, field, value);
    }

    @Override
    public Condition query(Class clazz) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.query(clazz);
    }

    @Override
    public Condition query(String tableName) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.query(tableName);
    }

    @Override
    public Condition query(Condition condition) {
        DQLDAO dqldao = this.createDQLDAO();
        return dqldao.query(condition);
    }

    @Override
    public int insert(Object instance) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.insert(instance);
    }

    @Override
    public int insert(Object[] instances) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.insert(instances);
    }

    @Override
    public int insert(Collection instanceCollection) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.insert(instanceCollection);
    }

    @Override
    public int insertBatch(Object[] instances) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.insertBatch(instances);
    }

    @Override
    public int insertBatch(Collection instanceCollection) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.insertBatch(instanceCollection);
    }

    @Override
    public int update(Object instance) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.update(instance);
    }

    @Override
    public int update(Object[] instances) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.update(instances);
    }

    @Override
    public int update(Collection instanceCollection) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.update(instanceCollection);
    }

    @Override
    public int save(Object instance) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.save(instance);
    }

    @Override
    public int save(Object[] instances) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.save(instances);
    }

    @Override
    public int save(Collection instanceCollection) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.save(instanceCollection);
    }

    @Override
    public int delete(Class delete, long id) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.delete(delete, id);
    }

    @Override
    public int delete(Class delete, String id) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.delete(delete, id);
    }

    @Override
    public int delete(Class clazz, String field, Object value) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.delete(clazz, field, value);
    }

    @Override
    public int delete(String tableName, String field, Object value) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.delete(tableName, field, value);
    }

    @Override
    public int clear(Class clazz) {
        DMLDAO dmldao = this.createDMLDAO();
        return dmldao.clear(clazz);
    }

    @Override
    public Transaction startTransaction() {
        AbstractTransaction transaction = new AbstractTransaction(this);
        transaction.transaction = true;
        SQLDAOInvocationHandler sqldaoInvocationHandler = new SQLDAOInvocationHandler(transaction);
        Transaction transactionProxy = (Transaction)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Transaction.class}, (InvocationHandler)sqldaoInvocationHandler);
        return transactionProxy;
    }

    @Override
    public boolean hasTable(String tableName) {
        for (Map.Entry<String, Entity> entry : this.quickDAOConfig.entityMap.entrySet()) {
            if (!entry.getValue().clazz.getSimpleName().equals(tableName)) continue;
            tableName = entry.getValue().tableName;
            break;
        }
        for (Entity dbEntity : this.quickDAOConfig.dbEntityList) {
            if (!dbEntity.tableName.equals(tableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void create(Class clazz) {
        this.create(this.quickDAOConfig.entityMap.get(clazz.getName()));
    }

    @Override
    public void create(Entity entity) {
        try {
            this.tableBuilder.createTable(entity);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void drop(Class clazz) {
        try {
            this.tableBuilder.dropTable(this.quickDAOConfig.entityMap.get((Object)clazz.getName()).tableName);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void drop(String tableName) {
        try {
            this.tableBuilder.dropTable(tableName);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rebuild(Class clazz) {
        try {
            this.tableBuilder.rebuild(this.quickDAOConfig.entityMap.get(clazz.getName()));
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.quickDAOConfig.dataSource;
    }

    @Override
    public Map<String, Entity> getEntityMap() {
        return this.quickDAOConfig.entityMap;
    }

    @Override
    public Entity[] getDbEntityList() {
        return this.quickDAOConfig.dbEntityList;
    }

    @Override
    public void refreshDbEntityList() {
        try {
            this.quickDAOConfig.tableBuilder.connection = this.quickDAOConfig.dataSource.getConnection();
            List<Entity> dbEntityList = this.quickDAOConfig.tableBuilder.getDatabaseEntity();
            this.quickDAOConfig.tableBuilder.connection.close();
            for (Entity dbEntity : dbEntityList) {
                dbEntity.escapeTableName = this.quickDAOConfig.database.escape(dbEntity.tableName);
                dbEntity.clazz = JSONObject.class;
            }
            this.quickDAOConfig.dbEntityList = dbEntityList.toArray(new Entity[0]);
            this.logger.info("[\u5237\u65b0\u6570\u636e\u5e93\u8868\u4fe1\u606f]\u6570\u636e\u5e93\u8868\u4e2a\u6570:{}", (Object)dbEntityList.size());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateEntityFile(String sourcePath, String[] tableNames) {
        List<Entity> dbEntityList;
        if (this.quickDAOConfig.packageNameMap.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528packageName\u65b9\u6cd5\u6307\u5b9a\u5305\u540d");
        }
        this.quickDAOConfig.autoCreateTable = false;
        this.quickDAOConfig.autoCreateProperty = false;
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("varchar", "String");
        mapping.put("longvarchar", "String");
        mapping.put("text", "String");
        mapping.put("mediumtext", "String");
        mapping.put("longtext", "String");
        mapping.put("boolean", "boolean");
        mapping.put("tinyint", "byte");
        mapping.put("blob", "byte[]");
        mapping.put("char", "String");
        mapping.put("smallint", "short");
        mapping.put("int", "int");
        mapping.put("integer", "int");
        mapping.put("bigint", "long");
        mapping.put("float", "float");
        mapping.put("double", "double");
        mapping.put("decimal", "double");
        mapping.put("date", "java.util.Date");
        mapping.put("time", "java.util.Time");
        mapping.put("datetime", "java.util.Date");
        mapping.put("timestamp", "java.sql.Timestamp");
        if (null == tableNames || tableNames.length == 0) {
            dbEntityList = Arrays.asList(this.quickDAOConfig.dbEntityList);
        } else {
            dbEntityList = new ArrayList<Entity>(tableNames.length);
            block2: for (String tableName : tableNames) {
                for (Entity dbEntity : this.quickDAOConfig.dbEntityList) {
                    if (!dbEntity.tableName.equals(tableName)) continue;
                    dbEntityList.add(dbEntity);
                    continue block2;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        String packageName = this.quickDAOConfig.packageNameMap.keySet().iterator().next();
        for (Entity dbEntity : dbEntityList) {
            dbEntity.className = StringUtil.Underline2Camel(dbEntity.tableName);
            dbEntity.className = dbEntity.className.toUpperCase().charAt(0) + dbEntity.className.substring(1);
            Path target = Paths.get(sourcePath + "/" + packageName.replace(".", "/") + "/" + dbEntity.className + ".java", new String[0]);
            if (Files.exists(target, new LinkOption[0])) {
                this.logger.warn("[\u5b9e\u4f53\u7c7b\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728]{}", (Object)target);
                continue;
            }
            builder.setLength(0);
            builder.append("package " + packageName + ";\n");
            builder.append("import cn.schoolwow.quickdao.annotation.*;\n\n");
            if (null != dbEntity.comment) {
                builder.append("@Comment(\"" + dbEntity.comment + "\")\n");
            }
            if (null != dbEntity.tableName) {
                builder.append("@TableName(\"" + dbEntity.tableName + "\")\n");
            }
            builder.append("public class " + dbEntity.className + "{\n\n");
            for (Property property : dbEntity.properties) {
                if (null != property.comment && !property.comment.isEmpty()) {
                    builder.append("\t@Comment(\"" + property.comment.replaceAll("\r\n", "") + "\")\n");
                }
                if (property.id) {
                    if (property.strategy.equals((Object)IdStrategy.AutoIncrement)) {
                        builder.append("\t@Id\n");
                    } else {
                        builder.append("\t@Id(strategy = IdStrategy.None)\n");
                    }
                }
                builder.append("\t@ColumnName(\"" + property.column + "\")\n");
                builder.append("\t@ColumnType(\"" + property.columnType + "\")\n");
                if (property.columnType.contains("(")) {
                    property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
                }
                property.className = (String)mapping.get(property.columnType.toLowerCase());
                property.name = StringUtil.Underline2Camel(property.column);
                builder.append("\tprivate " + property.className + " " + property.name + ";\n\n");
            }
            for (Property property : dbEntity.properties) {
                builder.append("\tpublic " + property.className + " get" + StringUtil.firstLetterUpper(property.name) + "(){\n\t\treturn this." + property.name + ";\n\t}\n\n");
                builder.append("\tpublic void set" + StringUtil.firstLetterUpper(property.name) + "(" + property.className + " " + property.name + "){\n\t\tthis." + property.name + "= " + property.name + ";\n\t}\n\n");
            }
            builder.append("};");
            ByteArrayInputStream bais = new ByteArrayInputStream(builder.toString().getBytes());
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(bais, target, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private DMLDAO createDMLDAO() {
        SQLDAOInvocationHandler sqldaoInvocationHandler = new SQLDAOInvocationHandler(new AbstractDMLDAO(this));
        DMLDAO dmldao = (DMLDAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DMLDAO.class}, (InvocationHandler)sqldaoInvocationHandler);
        return dmldao;
    }

    private DQLDAO createDQLDAO() {
        SQLDAOInvocationHandler sqldaoInvocationHandler = new SQLDAOInvocationHandler(new AbstractDQLDAO(this));
        DQLDAO dqldao = (DQLDAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DQLDAO.class}, (InvocationHandler)sqldaoInvocationHandler);
        return dqldao;
    }
}

