/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.table;

import cn.schoolwow.quickdao.builder.table.AbstractTableBuilder;
import cn.schoolwow.quickdao.builder.table.IndexType;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLiteTableBuilder
extends AbstractTableBuilder {
    public SQLiteTableBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.fieldMapping.put("long", "INTEGER");
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        PreparedStatement tablePs = this.connection.prepareStatement("select name from sqlite_master where type='table' and name != 'sqlite_sequence';");
        ResultSet tableRs = tablePs.executeQuery();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (tableRs.next()) {
            Entity entity = new Entity();
            entity.tableName = tableRs.getString(1);
            ArrayList<Property> propertyList = new ArrayList<Property>();
            ResultSet propertiesRs = this.connection.prepareStatement("PRAGMA table_info(`" + entity.tableName + "`)").executeQuery();
            while (propertiesRs.next()) {
                Property property = new Property();
                property.column = propertiesRs.getString("name");
                property.columnType = propertiesRs.getString("type");
                property.notNull = "1".equals(propertiesRs.getString("notnull"));
                if (null != propertiesRs.getString("dflt_value")) {
                    property.defaultValue = propertiesRs.getString("dflt_value");
                }
                propertyList.add(property);
            }
            propertiesRs.close();
            this.updateTableIndex("SELECT sql FROM sqlite_master WHERE type='index' and tbl_name = '" + entity.tableName + "';", propertyList);
            entity.properties = propertyList.toArray(new Property[0]);
            entityList.add(entity);
        }
        tableRs.close();
        tablePs.close();
        return entityList;
    }

    @Override
    public String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + " primary key autoincrement";
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement("select name from sqlite_master where type='table' and name = '" + entity.tableName + "';").executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public boolean hasIndexExists(Entity entity, IndexType indexType) throws SQLException {
        String indexName = entity.tableName + "_" + indexType.name();
        String sql = "select count(1) from sqlite_master where type = 'index' and name = '" + indexName + "'";
        this.logger.trace("[\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728]\u8868\u540d:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)sql);
        ResultSet resultSet = this.connection.prepareStatement(sql).executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }
}

