/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.table;

import cn.schoolwow.quickdao.builder.table.AbstractTableBuilder;
import cn.schoolwow.quickdao.builder.table.IndexType;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLServerTableBuilder
extends AbstractTableBuilder {
    public SQLServerTableBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.fieldMapping.put("boolean", "bit");
        this.fieldMapping.put("float", "float(24)");
        this.fieldMapping.put("double", "float(53)");
        this.fieldMapping.put("date", "datetime");
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        PreparedStatement tablePs = this.connection.prepareStatement("select name from sysobjects where xtype='u' order by name;");
        ResultSet tableRs = tablePs.executeQuery();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (tableRs.next()) {
            Entity entity = new Entity();
            entity.tableName = tableRs.getString(1);
            ArrayList<Property> propertyList = new ArrayList<Property>();
            PreparedStatement propertyPs = this.connection.prepareStatement("select column_name,data_type,is_nullable from information_schema.columns where table_name = '" + entity.tableName + "'");
            ResultSet propertiesRs = propertyPs.executeQuery();
            while (propertiesRs.next()) {
                Property property = new Property();
                property.column = propertiesRs.getString("column_name");
                property.columnType = propertiesRs.getString("data_type");
                property.notNull = "NO".equals(propertiesRs.getString("is_nullable"));
                propertyList.add(property);
            }
            entity.properties = propertyList.toArray(new Property[0]);
            entityList.add(entity);
            propertiesRs.close();
            propertyPs.close();
        }
        tableRs.close();
        return entityList;
    }

    @Override
    public String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + " identity(1,1) unique ";
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement("select name from sysobjects where xtype='u' and name = '" + entity.tableName + "';").executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public boolean hasIndexExists(Entity entity, IndexType indexType) throws SQLException {
        String indexName = entity.tableName + "_" + indexType.name();
        String sql = "EXEC Sp_helpindex '" + entity.tableName + "'";
        this.logger.debug("[\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728]\u8868\u540d:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)sql);
        ResultSet resultSet = this.connection.prepareStatement(sql).executeQuery();
        boolean result = false;
        while (resultSet.next()) {
            if (!indexName.equals(resultSet.getString("index_name"))) continue;
            result = true;
            break;
        }
        resultSet.close();
        return result;
    }
}

