/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.table;

import cn.schoolwow.quickdao.builder.table.AbstractTableBuilder;
import cn.schoolwow.quickdao.builder.table.IndexType;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostgreTableBuilder
extends AbstractTableBuilder {
    public PostgreTableBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.fieldMapping.put("byte", "smallint");
        this.fieldMapping.put("date", "timestamp");
        this.fieldMapping.put("calendar", "timestamp");
        this.fieldMapping.put("localdate", "timestamp");
        this.fieldMapping.put("localdatetime", "timestamp");
        this.fieldMapping.put("float", "real");
        this.fieldMapping.put("double", "double precision");
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        PreparedStatement tablePs = this.connection.prepareStatement("select tablename from pg_tables where schemaname='public';");
        ResultSet tableRs = tablePs.executeQuery();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (tableRs.next()) {
            Entity entity = new Entity();
            entity.tableName = tableRs.getString(1);
            ArrayList<Property> propertyList = new ArrayList<Property>();
            ResultSet propertiesRs = this.connection.prepareStatement("select column_name,column_default,is_nullable,udt_name from information_schema.columns where table_name = '" + entity.tableName + "'").executeQuery();
            while (propertiesRs.next()) {
                Property property = new Property();
                property.column = propertiesRs.getString("column_name");
                property.columnType = propertiesRs.getString("udt_name");
                property.notNull = "NO".equals(propertiesRs.getString("is_nullable"));
                if (null != propertiesRs.getString("column_default")) {
                    property.defaultValue = propertiesRs.getString("column_default");
                }
                propertyList.add(property);
            }
            this.updateTableIndex("select indexdef from pg_indexes where tablename='" + entity.tableName + "';", propertyList);
            entity.properties = propertyList.toArray(new Property[0]);
            entityList.add(entity);
        }
        tableRs.close();
        tablePs.close();
        return entityList;
    }

    @Override
    public String getAutoIncrementSQL(Property property) {
        return property.column + " SERIAL unique";
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement("select tablename from pg_tables where schemaname='public' and tablename = '" + entity.tableName + "';").executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void createTable(Entity entity) throws SQLException {
        super.createTable(entity);
        String entityCommentSQL = "comment on table \"" + entity.tableName + "\" is '" + entity.comment + "'";
        this.connection.prepareStatement(entityCommentSQL).executeUpdate();
        for (Property property : entity.properties) {
            if (property.comment == null) continue;
            String columnCommentSQL = "comment on column \"" + entity.tableName + "\".\"" + property.column + "\" is '" + property.comment + "'";
            this.connection.prepareStatement(columnCommentSQL).executeUpdate();
        }
    }

    @Override
    public boolean hasIndexExists(Entity entity, IndexType indexType) throws SQLException {
        String indexName = entity.tableName + "_" + indexType.name();
        String sql = "select count(1) from pg_indexes where tablename = '" + entity.tableName + "' and indexname = '" + indexName + "'";
        this.logger.trace("[\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728]\u8868\u540d:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)sql);
        ResultSet resultSet = this.connection.prepareStatement(sql).executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }
}

