/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.table;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.table.AbstractTableBuilder;
import cn.schoolwow.quickdao.builder.table.IndexType;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MySQLTableBuilder
extends AbstractTableBuilder {
    public MySQLTableBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.fieldMapping.put("char", "char(4)");
        this.fieldMapping.put("integer", "integer(11)");
        this.fieldMapping.put("long", "bigint");
        this.fieldMapping.put("float", "float(4,2)");
        this.fieldMapping.put("double", "double(5,2)");
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        PreparedStatement tablePs = this.connection.prepareStatement("select table_name,table_comment from information_schema.tables where table_schema = database()");
        ResultSet tableRs = tablePs.executeQuery();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (tableRs.next()) {
            Entity entity = new Entity();
            entity.tableName = tableRs.getString(1);
            entity.comment = tableRs.getString(2);
            ArrayList<Property> propertyList = new ArrayList<Property>();
            this.connection.getMetaData().getUserName();
            ResultSet propertiesRs = this.connection.prepareStatement("show full columns from " + this.quickDAOConfig.database.escape(entity.tableName)).executeQuery();
            while (propertiesRs.next()) {
                Property property = new Property();
                property.column = propertiesRs.getString("Field");
                property.columnType = propertiesRs.getString("Type");
                if (property.columnType.contains(" ")) {
                    property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                }
                property.notNull = "NO".equals(propertiesRs.getString("Null"));
                String key = propertiesRs.getString("Key");
                if (null != key) {
                    switch (key) {
                        case "PRI": {
                            property.id = true;
                            break;
                        }
                        case "UNI": {
                            property.unique = true;
                        }
                    }
                }
                property.strategy = "auto_increment".equals(propertiesRs.getString("Extra")) ? IdStrategy.AutoIncrement : IdStrategy.None;
                if (null != propertiesRs.getString("Default")) {
                    property.defaultValue = propertiesRs.getString("Default");
                }
                property.comment = propertiesRs.getString("Comment");
                propertyList.add(property);
            }
            propertiesRs.close();
            ResultSet resultSet = this.connection.prepareStatement("show index from " + this.quickDAOConfig.database.escape(entity.tableName)).executeQuery();
            block10: while (resultSet.next()) {
                String columnName = resultSet.getString("Column_name");
                for (Property property : propertyList) {
                    if (!property.column.equals(columnName)) continue;
                    int nonUnique = resultSet.getInt("Non_unique");
                    if (nonUnique == 0) {
                        property.unique = true;
                        continue block10;
                    }
                    property.index = true;
                    continue block10;
                }
            }
            resultSet.close();
            entity.properties = propertyList.toArray(new Property[0]);
            entityList.add(entity);
        }
        tableRs.close();
        return entityList;
    }

    @Override
    public String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + " primary key auto_increment";
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement("show tables like '%" + entity.tableName + "%';").executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public boolean hasIndexExists(Entity entity, IndexType indexType) throws SQLException {
        String indexName = entity.tableName + "_" + indexType.name();
        String sql = "show index from " + this.quickDAOConfig.database.escape(entity.tableName) + " where key_name = '" + indexName + "'";
        this.logger.trace("[\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728]\u8868\u540d:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)sql);
        ResultSet resultSet = this.connection.prepareStatement(sql).executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void dropIndex(Entity entity, IndexType indexType) throws SQLException {
        String indexName = entity.tableName + "_" + indexType.name();
        String dropIndexSQL = "drop index " + this.quickDAOConfig.database.escape(indexName) + " on " + this.quickDAOConfig.database.escape(entity.tableName);
        this.logger.debug("[\u5220\u9664\u7d22\u5f15]\u8868:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)dropIndexSQL);
        this.connection.prepareStatement(dropIndexSQL).executeUpdate();
    }
}

