/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.table;

import cn.schoolwow.quickdao.builder.table.IndexType;
import cn.schoolwow.quickdao.builder.table.MySQLTableBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class H2TableBuilder
extends MySQLTableBuilder {
    public H2TableBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.fieldMapping.put("long", "BIGINT");
        this.fieldMapping.put("float", "REAL");
        this.fieldMapping.put("double", "DOUBLE");
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        PreparedStatement tablePs = this.connection.prepareStatement("show tables;");
        ResultSet tableRs = tablePs.executeQuery();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (tableRs.next()) {
            Entity entity = new Entity();
            entity.tableName = tableRs.getString(1);
            ArrayList<Property> propertyList = new ArrayList<Property>();
            ResultSet propertiesRs = this.connection.prepareStatement("show columns from " + this.quickDAOConfig.database.escape(entity.tableName)).executeQuery();
            while (propertiesRs.next()) {
                Property property = new Property();
                property.column = propertiesRs.getString("Field");
                property.columnType = propertiesRs.getString("Type");
                property.notNull = "NO".equals(propertiesRs.getString("Null"));
                property.unique = "UNI".equals(propertiesRs.getString("Key"));
                if (null != propertiesRs.getString("Default")) {
                    property.defaultValue = propertiesRs.getString("Default");
                }
                propertyList.add(property);
            }
            propertiesRs.close();
            this.updateTableIndex("SELECT SQL FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '" + entity.tableName.toUpperCase() + "'", propertyList);
            entity.properties = propertyList.toArray(new Property[0]);
            entityList.add(entity);
        }
        tableRs.close();
        return entityList;
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement("select table_name from information_schema.tables where table_name = '" + entity.tableName.toUpperCase() + "'").executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public boolean hasIndexExists(Entity entity, IndexType indexType) throws SQLException {
        String indexName = (entity.tableName + "_" + indexType.name()).toUpperCase();
        String sql = "select count(1) from information_schema.indexes where index_name = '" + indexName + "'";
        this.logger.trace("[\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728]\u8868\u540d:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)sql);
        ResultSet resultSet = this.connection.prepareStatement(sql).executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }
}

