/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.table;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.table.IndexType;
import cn.schoolwow.quickdao.builder.table.SQLiteTableBuilder;
import cn.schoolwow.quickdao.builder.table.TableBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableBuilder
implements TableBuilder {
    protected Logger logger = LoggerFactory.getLogger(TableBuilder.class);
    protected final Map<String, String> fieldMapping = new HashMap<String, String>();
    public Connection connection;
    public QuickDAOConfig quickDAOConfig;

    public AbstractTableBuilder(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
        this.fieldMapping.put("string", "varchar(255)");
        this.fieldMapping.put("boolean", "boolean");
        this.fieldMapping.put("byte", "tinyint");
        this.fieldMapping.put("char", "char");
        this.fieldMapping.put("short", "smallint");
        this.fieldMapping.put("int", "integer");
        this.fieldMapping.put("integer", "integer");
        this.fieldMapping.put("long", "bigint");
        this.fieldMapping.put("float", "float");
        this.fieldMapping.put("double", "double");
        this.fieldMapping.put("date", "datetime");
        this.fieldMapping.put("time", "time");
        this.fieldMapping.put("calendar", "datetime");
        this.fieldMapping.put("localdate", "date");
        this.fieldMapping.put("localdatetime", "datetime");
        this.fieldMapping.put("timestamp", "timestamp");
    }

    @Override
    public abstract List<Entity> getDatabaseEntity() throws SQLException;

    public void updateTableIndex(String executeSQL, List<Property> propertyList) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement(executeSQL).executeQuery();
        while (resultSet.next()) {
            String sql = resultSet.getString(1);
            if (null == sql) continue;
            sql = sql.toLowerCase();
            String[] columns = sql.substring(sql.indexOf("(") + 1, sql.indexOf(")")).toLowerCase().split(",");
            if (sql.contains("create unique index")) {
                block1: for (String column : columns) {
                    for (Property property : propertyList) {
                        if (!property.column.equals(column.substring(1, column.length() - 1))) continue;
                        property.unique = true;
                        continue block1;
                    }
                }
                continue;
            }
            if (!sql.contains("create index")) continue;
            block3: for (String column : columns) {
                for (Property property : propertyList) {
                    if (!property.column.equals(column.substring(1, column.length() - 1))) continue;
                    property.index = true;
                    continue block3;
                }
            }
        }
        resultSet.close();
    }

    @Override
    public abstract String getAutoIncrementSQL(Property var1);

    @Override
    public abstract boolean hasTableExists(Entity var1) throws SQLException;

    @Override
    public void createTable(Entity entity) throws SQLException {
        Property[] properties;
        StringBuilder createTableBuilder = new StringBuilder("create table " + entity.escapeTableName + "(");
        for (Property property : properties = entity.properties) {
            if (null == property.columnType || property.columnType.isEmpty()) continue;
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                createTableBuilder.append(this.getAutoIncrementSQL(property));
            } else {
                createTableBuilder.append(this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
                if (property.notNull) {
                    createTableBuilder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    createTableBuilder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    createTableBuilder.append(" " + this.quickDAOConfig.database.comment(property.comment));
                }
                if (null != property.check && !property.check.isEmpty()) {
                    createTableBuilder.append(" check " + property.check);
                }
                if (property.unique && !property.unionUnique) {
                    createTableBuilder.append(" unique ");
                }
            }
            createTableBuilder.append(",");
        }
        if (this.quickDAOConfig.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.length > 0) {
            if (this instanceof SQLiteTableBuilder) {
                this.connection.prepareStatement("PRAGMA foreign_keys = ON;").executeUpdate();
            }
            for (Property property : entity.foreignKeyProperties) {
                createTableBuilder.append("foreign key(" + this.quickDAOConfig.database.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                createTableBuilder.append(this.quickDAOConfig.database.escape(this.quickDAOConfig.entityMap.get((Object)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.database.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                createTableBuilder.append(",");
            }
        }
        createTableBuilder.deleteCharAt(createTableBuilder.length() - 1);
        createTableBuilder.append(")");
        if (null != entity.comment) {
            createTableBuilder.append(" " + this.quickDAOConfig.database.comment(entity.comment));
        }
        this.logger.debug("[\u751f\u6210\u65b0\u8868]\u7c7b\u540d:{},\u8868\u540d:{},\u6267\u884cSQL:{}", new Object[]{entity.className, entity.tableName, createTableBuilder.toString()});
        this.connection.prepareStatement(createTableBuilder.toString()).executeUpdate();
    }

    @Override
    public void alterColumn(Property property) throws SQLException {
        StringBuilder builder = new StringBuilder("alert table " + this.quickDAOConfig.database.escape(property.entity.tableName));
        builder.append(" alter column " + this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
        this.logger.debug("[\u4fee\u6539\u6570\u636e\u7c7b\u578b]:\u7c7b\u540d:{},\u8868\u540d:{},\u5217\u540d:{},\u6267\u884cSQL:{}", new Object[]{property.entity.className, property.entity.tableName, property.column, builder.toString()});
        this.connection.prepareStatement(builder.toString()).executeUpdate();
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        String sql = "drop table " + this.quickDAOConfig.database.escape(tableName);
        this.logger.debug("[\u5220\u9664\u8868]\u8868\u540d:{},\u6267\u884cSQL:{}", (Object)tableName, (Object)sql);
        this.connection.prepareStatement(sql).executeUpdate();
    }

    @Override
    public void rebuild(Entity entity) throws SQLException {
        if (this.hasTableExists(entity)) {
            this.dropTable(entity.tableName);
        }
        this.createTable(entity);
        this.createIndex(entity, IndexType.Index);
        this.createIndex(entity, IndexType.Unique);
    }

    @Override
    public abstract boolean hasIndexExists(Entity var1, IndexType var2) throws SQLException;

    @Override
    public void createIndex(Entity entity, IndexType indexType) throws SQLException {
        if (null == entity || null == indexType) {
            return;
        }
        String indexName = entity.tableName + "_" + indexType.name();
        switch (indexType) {
            case Index: {
                if (null == entity.indexProperties || entity.indexProperties.length == 0) {
                    return;
                }
                StringBuilder indexBuilder = new StringBuilder("create index " + this.quickDAOConfig.database.escape(indexName) + " on " + entity.escapeTableName + " (");
                for (Property property : entity.indexProperties) {
                    indexBuilder.append(this.quickDAOConfig.database.escape(property.column) + ",");
                }
                indexBuilder.deleteCharAt(indexBuilder.length() - 1);
                indexBuilder.append(");");
                this.logger.debug("[\u6dfb\u52a0\u7d22\u5f15]\u8868:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)indexBuilder.toString());
                this.connection.prepareStatement(indexBuilder.toString()).executeUpdate();
                break;
            }
            case Unique: {
                if (null == entity.uniqueKeyProperties || entity.uniqueKeyProperties.length == 0) {
                    return;
                }
                StringBuilder indexUniqueBuilder = new StringBuilder("create unique index " + this.quickDAOConfig.database.escape(indexName) + " on " + entity.escapeTableName + " (");
                for (Property property : entity.uniqueKeyProperties) {
                    indexUniqueBuilder.append(this.quickDAOConfig.database.escape(property.column) + ",");
                }
                indexUniqueBuilder.deleteCharAt(indexUniqueBuilder.length() - 1);
                indexUniqueBuilder.append(");");
                this.logger.debug("[\u6dfb\u52a0\u552f\u4e00\u6027\u7ea6\u675f]\u8868:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)indexUniqueBuilder.toString());
                this.connection.prepareStatement(indexUniqueBuilder.toString()).executeUpdate();
            }
        }
    }

    @Override
    public boolean hasConstraintExists(String tableName, String constraintName) throws SQLException {
        ResultSet resultSet = this.connection.prepareStatement("select count(1) from information_schema.KEY_COLUMN_USAGE where constraint_name='" + constraintName + "'").executeQuery();
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void dropIndex(Entity entity, IndexType indexType) throws SQLException {
        String indexName = entity.tableName + "_" + indexType.name();
        String dropIndexSQL = "drop index " + this.quickDAOConfig.database.escape(indexName);
        this.logger.debug("[\u5220\u9664\u7d22\u5f15]\u8868:{},\u6267\u884cSQL:{}", (Object)entity.tableName, (Object)dropIndexSQL);
        this.connection.prepareStatement(dropIndexSQL).executeUpdate();
    }

    public void autoBuildDatabase() throws SQLException {
        List<Entity> dbEntityList = this.getDatabaseEntity();
        this.logger.debug("[\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f]\u6570\u636e\u5e93\u8868\u4e2a\u6570:{}", (Object)dbEntityList.size());
        Collection<Entity> entityList = this.quickDAOConfig.entityMap.values();
        ArrayList<Entity> newEntityList = new ArrayList<Entity>();
        ArrayList<Entity> updateEntityList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            for (Property property : entity.properties) {
                if (null == property.columnType || property.columnType.isEmpty()) {
                    property.columnType = this.fieldMapping.get(property.simpleTypeName);
                }
                if (null == property.check || property.check.isEmpty()) continue;
                property.check = property.check.replace("#{" + property.name + "}", this.quickDAOConfig.database.escape(property.column));
                if (property.check.contains("(")) continue;
                property.check = "(" + property.check + ")";
            }
            for (Entity dbEntity : dbEntityList) {
                if (!entity.tableName.toLowerCase().equals(dbEntity.tableName.toLowerCase())) continue;
                updateEntityList.add(entity);
                break;
            }
            if (updateEntityList.contains(entity)) continue;
            newEntityList.add(entity);
        }
        ArrayList<Entity> finalNewEntityList = new ArrayList<Entity>(newEntityList.size());
        for (Entity entity : newEntityList) {
            this.changeNewEntityCreateOrder(entity, finalNewEntityList);
        }
        if (this.quickDAOConfig.autoCreateTable) {
            for (Entity entity : newEntityList) {
                this.createTable(entity);
                this.createIndex(entity, IndexType.Index);
                this.createIndex(entity, IndexType.Unique);
            }
        }
        if (this.quickDAOConfig.autoCreateProperty) {
            block5: for (Entity entity : updateEntityList) {
                for (Entity dbEntity : dbEntityList) {
                    if (!entity.tableName.equals(dbEntity.tableName)) continue;
                    this.compareEntityDatabase(entity, dbEntity);
                    continue block5;
                }
            }
        }
        for (Entity entity : dbEntityList) {
            entity.escapeTableName = this.quickDAOConfig.database.escape(entity.tableName);
            entity.clazz = JSONObject.class;
        }
        this.quickDAOConfig.dbEntityList = dbEntityList.toArray(new Entity[0]);
        Entity entity = new Entity();
        entity.tableName = "dual";
        entity.escapeTableName = "dual";
        entity.properties = new Property[0];
        this.quickDAOConfig.visualTableList = new Entity[]{entity};
    }

    private void compareEntityDatabase(Entity entity, Entity dbEntity) throws SQLException {
        Property[] entityProperties = entity.properties;
        Property[] dbEntityProperties = dbEntity.properties;
        boolean hasIndexProperty = false;
        boolean hasUniqueProperty = false;
        ArrayList<Property> foreignKeyPropertyList = new ArrayList<Property>();
        for (Property entityProperty : entityProperties) {
            boolean columnExist = false;
            for (Property dbEntityProperty : dbEntityProperties) {
                if (!dbEntityProperty.column.equals(entityProperty.column)) continue;
                columnExist = true;
                if (entityProperty.id) break;
                if (dbEntityProperty.unique != entityProperty.unique) {
                    hasUniqueProperty = true;
                }
                if (dbEntityProperty.index == entityProperty.index) break;
                hasIndexProperty = true;
                break;
            }
            if (columnExist || null == entityProperty.columnType || entityProperty.columnType.isEmpty()) continue;
            this.addProperty(entityProperty);
            if (entityProperty.index) {
                hasIndexProperty = true;
            }
            if (entityProperty.unique) {
                hasUniqueProperty = true;
            }
            if (null == entityProperty.foreignKey) continue;
            foreignKeyPropertyList.add(entityProperty);
        }
        if (hasIndexProperty) {
            if (this.hasIndexExists(entity, IndexType.Index)) {
                this.dropIndex(entity, IndexType.Index);
            }
            this.createIndex(entity, IndexType.Index);
        }
        if (hasUniqueProperty) {
            if (this.hasIndexExists(entity, IndexType.Unique)) {
                this.dropIndex(entity, IndexType.Unique);
            }
            this.createIndex(entity, IndexType.Unique);
        }
        for (Property property : foreignKeyPropertyList) {
            this.addForeignKey(property);
        }
    }

    private void addProperty(Property property) throws SQLException {
        StringBuilder addColumnBuilder = new StringBuilder();
        addColumnBuilder.append("alter table " + this.quickDAOConfig.database.escape(property.entity.tableName) + " add " + this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
        if (property.notNull) {
            addColumnBuilder.append(" not null");
        }
        if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
            addColumnBuilder.append(" default " + property.defaultValue);
        }
        if (null != property.check && !property.check.isEmpty()) {
            addColumnBuilder.append(" check " + property.check);
        }
        if (null != property.comment) {
            addColumnBuilder.append(" " + this.quickDAOConfig.database.comment(property.comment));
        }
        addColumnBuilder.append(";");
        this.logger.debug("[\u6dfb\u52a0\u65b0\u5217]\u8868:{},\u5217\u540d:{},\u6267\u884cSQL:{}", new Object[]{property.entity.tableName, property.column + "(" + property.columnType + ")", addColumnBuilder.toString()});
        this.connection.prepareStatement(addColumnBuilder.toString()).executeUpdate();
    }

    private void addForeignKey(Property property) throws SQLException {
        String operation = property.foreignKey.foreignKeyOption().getOperation();
        String reference = this.quickDAOConfig.database.escape(this.quickDAOConfig.entityMap.get((Object)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.database.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation;
        String foreignKeyName = "FK_" + property.entity.tableName + "_" + property.foreignKey.field() + "_" + this.quickDAOConfig.entityMap.get((Object)property.foreignKey.table().getName()).tableName + "_" + property.name;
        if (this.hasConstraintExists(property.entity.tableName, foreignKeyName)) {
            return;
        }
        String foreignKeySQL = "alter table " + this.quickDAOConfig.database.escape(property.entity.tableName) + " add constraint " + this.quickDAOConfig.database.escape(foreignKeyName) + " foreign key(" + this.quickDAOConfig.database.escape(property.column) + ") references " + reference;
        this.logger.info("[\u751f\u6210\u5916\u952e\u7ea6\u675f]\u7ea6\u675f\u540d:{},\u6267\u884cSQL:{}", (Object)foreignKeyName, (Object)foreignKeySQL);
        this.connection.prepareStatement(foreignKeySQL).executeUpdate();
    }

    private void changeNewEntityCreateOrder(Entity entity, List<Entity> finalNewEntityList) {
        if (null != entity.foreignKeyProperties && entity.foreignKeyProperties.length > 0) {
            for (Property property : entity.foreignKeyProperties) {
                this.changeNewEntityCreateOrder(this.quickDAOConfig.entityMap.get(property.foreignKey.table().getName()), finalNewEntityList);
            }
        }
        finalNewEntityList.add(entity);
    }
}

