/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.sql.dql;

import cn.schoolwow.quickdao.builder.sql.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.DQLSQLBuilder;
import cn.schoolwow.quickdao.dao.condition.AbstractCondition;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.MDC;

public class AbstractDQLSQLBuilder
extends AbstractSQLBuilder
implements DQLSQLBuilder {
    public AbstractDQLSQLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public PreparedStatement fetchNull(Class clazz, String field) throws SQLException {
        String key = "fetchNull_" + clazz.getName() + "_" + field + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(entity, "t"));
            builder.append(" from " + entity.escapeTableName + " as t where t." + this.quickDAOConfig.database.escape(entity.getColumnNameByFieldName(field)) + " is null");
            sqlCache.put(key, builder.toString());
        }
        String sql = (String)sqlCache.get(key);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        MDC.put((String)"name", (String)"Null\u67e5\u8be2");
        MDC.put((String)"sql", (String)sql);
        return ps;
    }

    @Override
    public PreparedStatement fetch(Class clazz, long id) throws SQLException {
        Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
        return this.fetch(clazz, entity.id.column, (Object)(id + ""));
    }

    @Override
    public PreparedStatement fetch(Class clazz, String field, Object value) throws SQLException {
        String key = "fetch_" + clazz.getName() + "_" + field + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(entity, "t"));
            Property property = entity.getPropertyByFieldName(field);
            builder.append(" from " + entity.escapeTableName + " as t where t." + this.quickDAOConfig.database.escape(entity.getColumnNameByFieldName(field)) + " = " + (null == property || null == property.function ? "?" : property.function) + "");
            sqlCache.put(key, builder.toString());
        }
        String sql = (String)sqlCache.get(key);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        ps.setObject(1, value);
        MDC.put((String)"name", (String)"\u5b57\u6bb5\u67e5\u8be2");
        MDC.put((String)"sql", (String)sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString()));
        return ps;
    }

    @Override
    public PreparedStatement fetchNull(String tableName, String field) throws SQLException {
        String key = "fetchNull_" + tableName + "_" + field + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            Entity dbEntity = this.quickDAOConfig.getDbEntityByTableName(tableName);
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(dbEntity, "t"));
            builder.append(" from " + dbEntity.escapeTableName + " as t where t." + this.quickDAOConfig.database.escape(dbEntity.getColumnNameByFieldName(field)) + " is null");
            sqlCache.put(key, builder.toString());
        }
        String sql = (String)sqlCache.get(key);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        MDC.put((String)"name", (String)"Null\u67e5\u8be2");
        MDC.put((String)"sql", (String)sql);
        return ps;
    }

    @Override
    public PreparedStatement fetch(String tableName, String field, Object value) throws SQLException {
        String key = "fetch_" + tableName + "_" + field + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            Entity dbEntity = this.quickDAOConfig.getDbEntityByTableName(tableName);
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(dbEntity, "t"));
            builder.append(" from " + dbEntity.escapeTableName + " as t where t." + this.quickDAOConfig.database.escape(dbEntity.getColumnNameByFieldName(field)) + " = ?");
            sqlCache.put(key, builder.toString());
        }
        String sql = (String)sqlCache.get(key);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        ps.setObject(1, value);
        MDC.put((String)"name", (String)"\u5b57\u6bb5\u67e5\u8be2");
        MDC.put((String)"sql", (String)sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString()));
        return ps;
    }

    @Override
    public int getResultSetRowCount(Query query) throws SQLException {
        query.parameterIndex = 1;
        StringBuilder builder = new StringBuilder("select count(1) from ( select " + query.distinct + " ");
        if (query.columnBuilder.length() > 0) {
            builder.append(query.columnBuilder.toString());
        } else {
            builder.append(this.columns(query.entity, query.tableAliasName));
        }
        builder.append(" from " + query.entity.escapeTableName);
        if (null != query.entity.clazz) {
            builder.append(" as " + query.tableAliasName);
        }
        this.addJoinTableStatement(query, builder);
        this.addWhereStatement(query, builder);
        builder.append(" " + query.groupByBuilder.toString() + " " + query.havingBuilder.toString());
        builder.append(" " + query.limit);
        builder.append(") as foo");
        PreparedStatement ps = this.connection.prepareStatement(builder.toString());
        builder = new StringBuilder(builder.toString().replace("?", "** NOT SPECIFIED **"));
        this.addArraySQLParameters(ps, query, query, builder);
        ResultSet resultSet = ps.executeQuery();
        int count = -1;
        if (resultSet.next()) {
            count = resultSet.getInt(1);
        }
        resultSet.close();
        ps.close();
        MDC.put((String)"count", (String)(count + ""));
        query.parameterIndex = 1;
        return count;
    }

    @Override
    public PreparedStatement count(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("select count(1) from ( select " + query.distinct + " ");
        if (query.columnBuilder.length() > 0) {
            builder.append(query.columnBuilder.toString());
        } else {
            builder.append(this.columns(query.entity, query.tableAliasName));
        }
        builder.append(" from " + query.entity.escapeTableName);
        if (null != query.entity.clazz) {
            builder.append(" as " + query.tableAliasName);
        }
        this.addJoinTableStatement(query, builder);
        this.addWhereStatement(query, builder);
        builder.append(" " + query.groupByBuilder.toString() + " " + query.havingBuilder.toString());
        builder.append(") as foo");
        PreparedStatement ps = this.connection.prepareStatement(builder.toString());
        builder = new StringBuilder(builder.toString().replace("?", "** NOT SPECIFIED **"));
        this.addArraySQLParameters(ps, query, query, builder);
        return ps;
    }

    @Override
    public PreparedStatement insert(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("insert into " + query.entity.escapeTableName + "(");
        builder.append(query.insertBuilder.toString() + ") values(");
        for (int i = 0; i < query.insertParameterList.size(); ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        PreparedStatement ps = this.connection.prepareStatement(builder.toString(), 1);
        builder = new StringBuilder(builder.toString().replace("?", "** NOT SPECIFIED **"));
        for (Object parameter : query.insertParameterList) {
            AbstractDQLSQLBuilder.setParameter(parameter, ps, query.parameterIndex++, builder);
        }
        MDC.put((String)"name", (String)"\u63d2\u5165\u8bb0\u5f55");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement[] insertArray(Query query) throws SQLException {
        Property[] properties;
        StringBuilder builder = new StringBuilder("insert into " + query.entity.escapeTableName + "(");
        for (Property property : properties = query.entity.properties) {
            builder.append(query.quickDAOConfig.database.escape(property.column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") values(");
        for (int i = 0; i < properties.length; ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        this.connection.setAutoCommit(false);
        JSONArray array = query.insertArray;
        PreparedStatement[] preparedStatements = new PreparedStatement[array.size()];
        String sql = builder.toString();
        for (int i = 0; i < array.size(); ++i) {
            PreparedStatement ps = this.connection.prepareStatement(sql, 1);
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            JSONObject o = array.getJSONObject(i);
            for (int j = 0; j < properties.length; ++j) {
                AbstractDQLSQLBuilder.setParameter(o.getString(properties[j].column), ps, j + 1, sqlBuilder);
            }
            builder.append(sqlBuilder.toString() + ";");
            preparedStatements[i] = ps;
        }
        MDC.put((String)"name", (String)"\u63d2\u5165\u8bb0\u5f55");
        MDC.put((String)"sql", (String)builder.toString());
        return preparedStatements;
    }

    @Override
    public PreparedStatement update(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("update " + query.entity.escapeTableName + " as t ");
        this.addJoinTableStatement(query, builder);
        builder.append(query.setBuilder.toString());
        this.addWhereStatement(query, builder);
        this.addJoinTableStatement(query, builder);
        PreparedStatement ps = this.connection.prepareStatement(builder.toString());
        builder = new StringBuilder(builder.toString().replace("?", "** NOT SPECIFIED **"));
        for (Object parameter : query.updateParameterList) {
            AbstractDQLSQLBuilder.setParameter(parameter, ps, query.parameterIndex++, builder);
        }
        this.addMainTableParameters(ps, query, query, builder);
        MDC.put((String)"name", (String)"\u6279\u91cf\u66f4\u65b0");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement delete(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("delete t from " + query.entity.escapeTableName + " as t");
        this.addJoinTableStatement(query, builder);
        this.addWhereStatement(query, builder);
        PreparedStatement ps = this.connection.prepareStatement(builder.toString());
        builder = new StringBuilder(builder.toString().replace("?", "** NOT SPECIFIED **"));
        this.addMainTableParameters(ps, query, query, builder);
        MDC.put((String)"name", (String)"\u6279\u91cf\u5220\u9664");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement getArray(Query query) throws SQLException {
        StringBuilder builder = this.getArraySQL(query);
        if (!query.unionList.isEmpty()) {
            for (AbstractCondition abstractCondition : query.unionList) {
                switch (abstractCondition.query.unionType) {
                    case Union: {
                        builder.append(" union ");
                        break;
                    }
                    case UnionAll: {
                        builder.append(" union all ");
                    }
                }
                builder.append((CharSequence)this.getArraySQL(abstractCondition.query));
            }
        }
        builder.append(" " + query.orderByBuilder.toString() + " " + query.limit);
        PreparedStatement ps = this.connection.prepareStatement(builder.toString());
        builder = new StringBuilder(builder.toString().replace("?", "** NOT SPECIFIED **"));
        this.addArraySQLParameters(ps, query, query, builder);
        for (Object parameter : query.havingParameterList) {
            AbstractDQLSQLBuilder.setParameter(parameter, ps, query.parameterIndex++, builder);
        }
        for (AbstractCondition abstractCondition : query.unionList) {
            Query unionQuery = abstractCondition.query;
            for (SubQuery subQuery : unionQuery.subQueryList) {
                if (null == subQuery.subQuery) continue;
                this.addMainTableParameters(ps, subQuery.subQuery, query, builder);
            }
            this.addMainTableParameters(ps, unionQuery, query, builder);
            for (SubQuery<Object> parameter : unionQuery.havingParameterList) {
                AbstractDQLSQLBuilder.setParameter(parameter, ps, query.parameterIndex++, builder);
            }
        }
        MDC.put((String)"name", (String)"\u83b7\u53d6\u5217\u8868");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public StringBuilder getArraySQL(Query query) {
        StringBuilder builder = new StringBuilder("select " + query.distinct + " ");
        if (query.columnBuilder.length() > 0) {
            builder.append(query.columnBuilder.toString());
        } else {
            builder.append(this.columns(query.entity, query.tableAliasName));
        }
        if (query.compositField) {
            for (SubQuery subQuery : query.subQueryList) {
                builder.append("," + this.columns(subQuery.entity, subQuery.tableAliasName));
            }
        }
        builder.append(" from " + query.entity.escapeTableName);
        if (null != query.entity.clazz) {
            builder.append(" as " + query.tableAliasName);
        }
        this.addJoinTableStatement(query, builder);
        this.addWhereStatement(query, builder);
        builder.append(" " + query.groupByBuilder.toString() + " " + query.havingBuilder.toString());
        return builder;
    }

    private void addJoinTableStatement(Query query, StringBuilder sqlBuilder) {
        for (SubQuery subQuery : query.subQueryList) {
            sqlBuilder.append(" " + subQuery.join + " ");
            if (null == subQuery.subQuerySQLBuilder) {
                sqlBuilder.append(query.quickDAOConfig.database.escape(subQuery.entity.tableName));
            } else {
                sqlBuilder.append("(" + subQuery.subQuerySQLBuilder.toString() + ")");
            }
            sqlBuilder.append(" as " + subQuery.tableAliasName);
            if (null == subQuery.primaryField || null == subQuery.joinTableField) continue;
            sqlBuilder.append(" on ");
            if (subQuery.parentSubQuery == null) {
                sqlBuilder.append(query.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.primaryField) + " = " + subQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.joinTableField) + " ");
                continue;
            }
            sqlBuilder.append(subQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.joinTableField) + " = " + subQuery.parentSubQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.primaryField) + " ");
        }
    }

    private void addWhereStatement(Query query, StringBuilder sqlBuilder) {
        sqlBuilder.append(" " + query.whereBuilder.toString());
        for (SubQuery subQuery : query.subQueryList) {
            if (subQuery.whereBuilder.length() <= 0) continue;
            sqlBuilder.append(" and " + subQuery.whereBuilder.toString() + " ");
        }
        for (AbstractCondition orCondition : query.orList) {
            sqlBuilder.append(" or (" + orCondition.query.whereBuilder.toString() + ")");
        }
    }

    private void addArraySQLParameters(PreparedStatement ps, Query query, Query mainQuery, StringBuilder builder) throws SQLException {
        for (Query selectQuery : query.selectQueryList) {
            this.addArraySQLParameters(ps, selectQuery, mainQuery, builder);
        }
        if (null != query.fromQuery) {
            this.addArraySQLParameters(ps, query.fromQuery, mainQuery, builder);
        }
        for (SubQuery subQuery : query.subQueryList) {
            if (null == subQuery.subQuery) continue;
            this.addArraySQLParameters(ps, subQuery.subQuery, mainQuery, builder);
        }
        this.addMainTableParameters(ps, query, mainQuery, builder);
    }

    protected void addMainTableParameters(PreparedStatement ps, Query query, Query mainQuery, StringBuilder sqlBuilder) throws SQLException {
        for (Object parameter : query.parameterList) {
            AbstractDQLSQLBuilder.setParameter(parameter, ps, mainQuery.parameterIndex++, sqlBuilder);
        }
        for (SubQuery subQuery : query.subQueryList) {
            for (Object parameter : subQuery.parameterList) {
                AbstractDQLSQLBuilder.setParameter(parameter, ps, mainQuery.parameterIndex++, sqlBuilder);
            }
        }
        for (AbstractCondition orCondition : query.orList) {
            for (Object parameter : orCondition.query.parameterList) {
                AbstractDQLSQLBuilder.setParameter(parameter, ps, mainQuery.parameterIndex++, sqlBuilder);
            }
        }
    }

    private String columns(Entity entity, String tableAlias) {
        String key = "columns_" + entity.tableName + "_" + tableAlias + this.quickDAOConfig.database.getClass().getName();
        if (!sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            for (Property property : entity.properties) {
                builder.append(tableAlias + "." + this.quickDAOConfig.database.escape(property.column) + " as " + tableAlias + "_" + property.column + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            sqlCache.put(key, builder.toString());
        }
        return (String)sqlCache.get(key);
    }
}

