/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.sql.dml;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.sql.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dml.DMLSQLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import org.slf4j.MDC;

public class AbstractDMLSQLBuilder
extends AbstractSQLBuilder
implements DMLSQLBuilder {
    public AbstractDMLSQLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public PreparedStatement insert(Object instance) throws Exception {
        String sql = this.insert(instance.getClass());
        StringBuilder builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        PreparedStatement ps = this.connection.prepareStatement(sql, 1);
        this.insert(ps, instance, builder);
        MDC.put((String)"name", (String)"\u63d2\u5165\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement[] insert(Object[] instances) throws Exception {
        String sql = this.insert(instances[0].getClass());
        this.connection.setAutoCommit(false);
        PreparedStatement[] preparedStatements = new PreparedStatement[instances.length];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < instances.length; ++i) {
            PreparedStatement ps = this.connection.prepareStatement(sql, 1);
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.insert(ps, instances[i], sqlBuilder);
            builder.append(sqlBuilder.toString() + ";");
            preparedStatements[i] = ps;
        }
        MDC.put((String)"name", (String)"\u6279\u91cf\u63d2\u5165\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return preparedStatements;
    }

    @Override
    public PreparedStatement insertBatch(Object[] instances) throws Exception {
        String sql = this.insert(instances[0].getClass());
        this.connection.setAutoCommit(false);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        StringBuilder builder = new StringBuilder();
        for (Object instance : instances) {
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.insert(ps, instance, sqlBuilder);
            builder.append(sqlBuilder.toString() + ";");
            ps.addBatch();
        }
        MDC.put((String)"name", (String)"\u6279\u91cf\u63d2\u5165\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement updateByUniqueKey(Object instance) throws Exception {
        String sql = this.updateByUniqueKey(instance.getClass());
        StringBuilder builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        PreparedStatement ps = this.connection.prepareStatement(sql);
        this.updateByUniqueKey(ps, instance, builder);
        MDC.put((String)"name", (String)"\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement updateByUniqueKey(Object[] instances) throws Exception {
        String sql = this.updateByUniqueKey(instances[0].getClass());
        this.connection.setAutoCommit(false);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        StringBuilder builder = new StringBuilder();
        for (Object instance : instances) {
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.updateByUniqueKey(ps, instance, sqlBuilder);
            builder.append(sqlBuilder.toString() + ";");
            ps.addBatch();
        }
        MDC.put((String)"name", (String)"\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u6279\u91cf\u66f4\u65b0\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement updateById(Object instance) throws Exception {
        String sql = this.updateById(instance.getClass());
        StringBuilder builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        PreparedStatement ps = this.connection.prepareStatement(sql);
        this.updateById(ps, instance, builder);
        MDC.put((String)"name", (String)"\u6839\u636eID\u66f4\u65b0\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement updateById(Object[] instances) throws Exception {
        String sql = this.updateById(instances[0].getClass());
        this.connection.setAutoCommit(false);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        StringBuilder builder = new StringBuilder();
        for (Object instance : instances) {
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.updateById(ps, instance, sqlBuilder);
            builder.append(sqlBuilder.toString() + ";");
            ps.addBatch();
        }
        MDC.put((String)"name", (String)"\u6839\u636eID\u6279\u91cf\u66f4\u65b0\u5bf9\u8c61");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    @Override
    public PreparedStatement deleteByProperty(Class clazz, String property, Object value) throws SQLException {
        String key = "deleteByProperty_" + clazz.getName() + "_" + property + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            StringBuilder builder = new StringBuilder();
            builder.append("delete from " + entity.escapeTableName + " where " + this.quickDAOConfig.database.escape(entity.getColumnNameByFieldName(property)) + " = ?");
            sqlCache.put(key, builder.toString());
        }
        String sql = (String)sqlCache.get(key);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        ps.setObject(1, value);
        MDC.put((String)"name", (String)"\u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u5220\u9664");
        MDC.put((String)"sql", (String)sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString()));
        return ps;
    }

    @Override
    public PreparedStatement deleteByProperty(String tableName, String property, Object value) throws SQLException {
        String sql = "delete from " + this.quickDAOConfig.database.escape(tableName) + " where " + this.quickDAOConfig.database.escape(property) + " = ?";
        PreparedStatement ps = this.connection.prepareStatement(sql);
        ps.setObject(1, value);
        MDC.put((String)"name", (String)"\u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u5220\u9664");
        MDC.put((String)"sql", (String)sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString()));
        return ps;
    }

    @Override
    public PreparedStatement clear(Class clazz) throws SQLException {
        String key = "clear_" + clazz.getName() + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            sqlCache.put(key, "delete from " + entity.escapeTableName);
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement((String)sqlCache.get(key));
        return preparedStatement;
    }

    private String insert(Class clazz) {
        String key = "insert_" + clazz.getName() + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            builder.append("insert into " + entity.escapeTableName + "(");
            for (Property property : entity.properties) {
                if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(") values(");
            for (Property property : entity.properties) {
                if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
                builder.append((null == property.function ? "?" : property.function) + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(")");
            sqlCache.put(key, builder.toString());
        }
        return (String)sqlCache.get(key);
    }

    private void insert(PreparedStatement preparedStatement, Object instance, StringBuilder sqlBuilder) throws Exception {
        int parameterIndex = 1;
        Entity entity = this.quickDAOConfig.entityMap.get(instance.getClass().getName());
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
            if (property.id && property.strategy == IdStrategy.IdGenerator) {
                Field idField = instance.getClass().getDeclaredField(property.name);
                idField.setAccessible(true);
                long value = this.quickDAOConfig.idGenerator.getNextId();
                switch (idField.getType().getSimpleName().toLowerCase()) {
                    case "int": 
                    case "integer": {
                        if (idField.getType().isPrimitive()) {
                            idField.setInt(instance, (int)value);
                            break;
                        }
                        idField.set(instance, Integer.valueOf(value + ""));
                        break;
                    }
                    case "long": {
                        if (idField.getType().isPrimitive()) {
                            idField.setLong(instance, value);
                            break;
                        }
                        idField.set(instance, value);
                        break;
                    }
                    case "string": {
                        idField.set(instance, value + "");
                    }
                }
            }
            if (property.createdAt || property.updateAt) {
                this.setCurrentDateTime(property, instance);
            }
            AbstractDMLSQLBuilder.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            ++parameterIndex;
        }
    }

    private String updateByUniqueKey(Class clazz) {
        String key = "updateByUniqueKey_" + clazz.getName() + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            builder.append("update " + entity.escapeTableName + " set ");
            for (Property property : entity.properties) {
                if (property.id || property.unique || property.createdAt) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(" where ");
            for (Property property : entity.properties) {
                if (!property.unique || property.id) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + " = ? and ");
            }
            builder.delete(builder.length() - 5, builder.length());
            sqlCache.put(key, builder.toString());
        }
        return (String)sqlCache.get(key);
    }

    private void updateByUniqueKey(PreparedStatement preparedStatement, Object instance, StringBuilder sqlBuilder) throws Exception {
        int parameterIndex = 1;
        Entity entity = this.quickDAOConfig.entityMap.get(instance.getClass().getName());
        for (Property property : entity.properties) {
            if (property.id || property.unique || property.createdAt) continue;
            if (property.updateAt) {
                this.setCurrentDateTime(property, instance);
            }
            AbstractDMLSQLBuilder.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            ++parameterIndex;
        }
        for (Property property : entity.properties) {
            if (!property.unique || property.id) continue;
            AbstractDMLSQLBuilder.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            ++parameterIndex;
        }
    }

    private String updateById(Class clazz) {
        String key = "updateById_" + clazz.getName() + "_" + this.quickDAOConfig.database.getClass().getSimpleName();
        if (!sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
            builder.append("update " + entity.escapeTableName + " set ");
            for (Property property : entity.properties) {
                if (property.id || property.createdAt) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + " = ?,");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(" where " + this.quickDAOConfig.database.escape(entity.id.column) + " = ?");
            sqlCache.put(key, builder.toString());
        }
        return (String)sqlCache.get(key);
    }

    private void updateById(PreparedStatement preparedStatement, Object instance, StringBuilder sqlBuilder) throws Exception {
        int parameterIndex = 1;
        Entity entity = this.quickDAOConfig.entityMap.get(instance.getClass().getName());
        for (Property property : entity.properties) {
            if (property.id || property.createdAt) continue;
            if (property.updateAt) {
                this.setCurrentDateTime(property, instance);
            }
            AbstractDMLSQLBuilder.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            ++parameterIndex;
        }
        AbstractDMLSQLBuilder.setParameter(instance, entity.id, preparedStatement, parameterIndex, sqlBuilder);
    }

    private void setCurrentDateTime(Property property, Object instance) throws Exception {
        Field field = property.entity.clazz.getDeclaredField(property.name);
        field.setAccessible(true);
        switch (property.simpleTypeName) {
            case "date": {
                field.set(instance, field.getType().getConstructor(Long.TYPE).newInstance(System.currentTimeMillis()));
                break;
            }
            case "timestamp": {
                field.set(instance, new Timestamp(System.currentTimeMillis()));
                break;
            }
            case "calendar": {
                field.set(instance, Calendar.getInstance());
                break;
            }
            case "localdate": {
                field.set(instance, LocalDate.now());
                break;
            }
            case "localdatetime": {
                field.set(instance, LocalDateTime.now());
                break;
            }
            default: {
                logger.warn("[\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b]{},\u76ee\u524d\u652f\u6301\u7684\u7c7b\u578b\u4e3aDate,Calendar,LocalDate,LocalDateTime!", (Object)property.simpleTypeName);
            }
        }
    }
}

