/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.sql;

import cn.schoolwow.quickdao.builder.sql.dql.AbstractDQLSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.H2DQLSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.MySQLDQLSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.PostgreDQLSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.SQLServerDQLSQLBuilder;
import cn.schoolwow.quickdao.builder.sql.dql.SQLiteDQLSQLBuilder;
import cn.schoolwow.quickdao.database.H2Database;
import cn.schoolwow.quickdao.database.MySQLDatabase;
import cn.schoolwow.quickdao.database.PostgreDatabase;
import cn.schoolwow.quickdao.database.SQLServerDatabase;
import cn.schoolwow.quickdao.database.SQLiteDatabase;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.PreparedStatement;

public interface SQLBuilder {
    public PreparedStatement selectCountById(Object var1) throws Exception;

    public PreparedStatement selectCountByUniqueKey(Object var1) throws Exception;

    public static AbstractDQLSQLBuilder getDQLSQLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        AbstractDQLSQLBuilder dqlsqlBuilder = null;
        if (quickDAOConfig.database instanceof MySQLDatabase) {
            dqlsqlBuilder = new MySQLDQLSQLBuilder(quickDAOConfig);
        } else if (quickDAOConfig.database instanceof SQLiteDatabase) {
            dqlsqlBuilder = new SQLiteDQLSQLBuilder(quickDAOConfig);
        } else if (quickDAOConfig.database instanceof H2Database) {
            dqlsqlBuilder = new H2DQLSQLBuilder(quickDAOConfig);
        } else if (quickDAOConfig.database instanceof PostgreDatabase) {
            dqlsqlBuilder = new PostgreDQLSQLBuilder(quickDAOConfig);
        } else if (quickDAOConfig.database instanceof SQLServerDatabase) {
            dqlsqlBuilder = new SQLServerDQLSQLBuilder(quickDAOConfig);
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
        }
        return dqlsqlBuilder;
    }
}

