/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.sql;

import cn.schoolwow.quickdao.builder.sql.SQLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AbstractSQLBuilder
implements SQLBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractSQLBuilder.class);
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
    protected static final String PLACEHOLDER = "** NOT SPECIFIED **";
    protected static final ConcurrentHashMap<String, String> sqlCache = new ConcurrentHashMap();
    public QuickDAOConfig quickDAOConfig;
    public volatile Connection connection;

    public AbstractSQLBuilder(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public PreparedStatement selectCountById(Object instance) throws Exception {
        String key = "selectCountById_" + instance.getClass().getName() + "_" + this.quickDAOConfig.database.getClass().getName();
        Entity entity = this.quickDAOConfig.entityMap.get(instance.getClass().getName());
        if (!sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            builder.append("select count(1) from " + entity.escapeTableName + " where ");
            builder.append(entity.id.column + " = " + (null == entity.id.function ? "?" : entity.id.function) + " ");
            sqlCache.put(key, builder.toString());
        }
        String sql = sqlCache.get(key);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        Field field = instance.getClass().getDeclaredField(entity.id.name);
        field.setAccessible(true);
        Object value = field.get(instance);
        ps.setObject(1, value);
        MDC.put((String)"name", (String)"\u6839\u636eid\u67e5\u8be2");
        MDC.put((String)"sql", (String)sql.replace("?", value == null ? "" : value.toString()));
        return ps;
    }

    @Override
    public PreparedStatement selectCountByUniqueKey(Object instance) throws Exception {
        String key = "selectCountByUniqueKey_" + instance.getClass().getName() + "_" + this.quickDAOConfig.database.getClass().getName();
        Entity entity = this.quickDAOConfig.entityMap.get(instance.getClass().getName());
        if (!sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            builder.append("select count(1) from " + entity.escapeTableName + " where ");
            for (Property property : entity.uniqueKeyProperties) {
                builder.append(this.quickDAOConfig.database.escape(property.column) + "= " + (null == property.function ? "?" : property.function) + " and ");
            }
            builder.delete(builder.length() - 5, builder.length());
            sqlCache.put(key, builder.toString());
        }
        String sql = sqlCache.get(key);
        StringBuilder builder = new StringBuilder(sql.replace("?", PLACEHOLDER));
        PreparedStatement ps = this.connection.prepareStatement(sql);
        int parameterIndex = 1;
        for (Property property : entity.uniqueKeyProperties) {
            AbstractSQLBuilder.setParameter(instance, property, ps, parameterIndex, builder);
            ++parameterIndex;
        }
        MDC.put((String)"name", (String)"\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u67e5\u8be2");
        MDC.put((String)"sql", (String)builder.toString());
        return ps;
    }

    protected static void setParameter(Object parameter, PreparedStatement ps, int parameterIndex, StringBuilder sqlBuilder) throws SQLException {
        if (null == parameter) {
            ps.setObject(parameterIndex, null);
            AbstractSQLBuilder.replaceFirst(sqlBuilder, "null");
            return;
        }
        switch (parameter.getClass().getSimpleName().toLowerCase()) {
            case "boolean": {
                ps.setBoolean(parameterIndex, (Boolean)parameter);
                break;
            }
            case "int": 
            case "integer": {
                ps.setInt(parameterIndex, (Integer)parameter);
                break;
            }
            case "float": {
                ps.setFloat(parameterIndex, ((Float)parameter).floatValue());
                break;
            }
            case "long": {
                ps.setLong(parameterIndex, (Long)parameter);
                break;
            }
            case "double": {
                ps.setDouble(parameterIndex, (Double)parameter);
                break;
            }
            case "string": {
                ps.setString(parameterIndex, (String)parameter);
                break;
            }
            case "date": {
                if (parameter instanceof Date) {
                    ps.setDate(parameterIndex, (Date)parameter);
                    break;
                }
                java.util.Date d = (java.util.Date)parameter;
                ps.setDate(parameterIndex, new Date(d.getTime()));
                break;
            }
            case "timestamp": {
                ps.setTimestamp(parameterIndex, (Timestamp)parameter);
                break;
            }
            default: {
                ps.setObject(parameterIndex, parameter);
            }
        }
        if (!logger.isDebugEnabled()) {
            return;
        }
        switch (parameter.getClass().getSimpleName().toLowerCase()) {
            case "boolean": {
                Boolean bool = Boolean.parseBoolean(parameter.toString());
                AbstractSQLBuilder.replaceFirst(sqlBuilder, bool != false ? "1" : "0");
                break;
            }
            case "int": 
            case "integer": 
            case "float": 
            case "long": 
            case "double": {
                AbstractSQLBuilder.replaceFirst(sqlBuilder, parameter.toString());
                break;
            }
            case "string": {
                AbstractSQLBuilder.replaceFirst(sqlBuilder, "'" + parameter.toString() + "'");
                break;
            }
            case "date": 
            case "timestamp": {
                java.util.Date date = (java.util.Date)parameter;
                LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                AbstractSQLBuilder.replaceFirst(sqlBuilder, "'" + dateTimeFormatter.format(localDateTime) + "'");
                break;
            }
            case "localdate": {
                LocalDate localDate = (LocalDate)parameter;
                AbstractSQLBuilder.replaceFirst(sqlBuilder, "'" + dateTimeFormatter.format(localDate) + "'");
                break;
            }
            case "localdatetime": {
                LocalDateTime localDateTime = (LocalDateTime)parameter;
                AbstractSQLBuilder.replaceFirst(sqlBuilder, "'" + dateTimeFormatter.format(localDateTime) + "'");
                break;
            }
            default: {
                AbstractSQLBuilder.replaceFirst(sqlBuilder, parameter.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setParameter(Object instance, Property property, PreparedStatement ps, int parameterIndex, StringBuilder sqlBuilder) throws Exception {
        Field field = instance.getClass().getDeclaredField(property.name);
        field.setAccessible(true);
        String parameter = null;
        switch (property.simpleTypeName) {
            case "boolean": {
                if (field.getType().isPrimitive()) {
                    ps.setBoolean(parameterIndex, field.getBoolean(instance));
                    parameter = "" + field.getBoolean(instance);
                    break;
                }
                ps.setObject(parameterIndex, field.get(instance));
                parameter = "" + field.get(instance);
                break;
            }
            case "int": {
                ps.setInt(parameterIndex, field.getInt(instance));
                parameter = "" + field.getInt(instance);
                break;
            }
            case "integer": {
                ps.setObject(parameterIndex, field.get(instance));
                parameter = "" + field.get(instance);
                break;
            }
            case "float": {
                if (field.getType().isPrimitive()) {
                    ps.setFloat(parameterIndex, field.getFloat(instance));
                    parameter = "" + field.getFloat(instance);
                    break;
                }
                ps.setObject(parameterIndex, field.get(instance));
                parameter = "" + field.get(instance);
                break;
            }
            case "long": {
                if (field.getType().isPrimitive()) {
                    ps.setLong(parameterIndex, field.getLong(instance));
                    parameter = "" + field.getLong(instance);
                    break;
                }
                ps.setObject(parameterIndex, field.get(instance));
                parameter = "" + field.get(instance);
                break;
            }
            case "double": {
                if (field.getType().isPrimitive()) {
                    ps.setDouble(parameterIndex, field.getDouble(instance));
                    parameter = "" + field.getDouble(instance);
                    break;
                }
                ps.setObject(parameterIndex, field.get(instance));
                parameter = "" + field.get(instance);
                break;
            }
            case "string": {
                ps.setString(parameterIndex, field.get(instance) == null ? null : field.get(instance).toString());
                parameter = "'" + (field.get(instance) == null ? "" : field.get(instance).toString()) + "'";
                break;
            }
            case "date": 
            case "timestamp": {
                Object o = field.get(instance);
                if (null == o) {
                    ps.setObject(parameterIndex, null);
                    parameter = "null";
                    break;
                }
                java.util.Date date = (java.util.Date)o;
                ps.setTimestamp(parameterIndex, new Timestamp(date.getTime()));
                SimpleDateFormat simpleDateFormat = AbstractSQLBuilder.simpleDateFormat;
                synchronized (simpleDateFormat) {
                    parameter = "'" + AbstractSQLBuilder.simpleDateFormat.format(date) + "'";
                    break;
                }
            }
            case "localdate": {
                Object o = field.get(instance);
                if (null == o) {
                    ps.setObject(parameterIndex, null);
                    parameter = "null";
                    break;
                }
                ps.setObject(parameterIndex, o);
                LocalDate localDate = (LocalDate)o;
                parameter = "'" + dateTimeFormatter.format(localDate) + "'";
                break;
            }
            case "localdatetime": {
                Object o = field.get(instance);
                if (null == o) {
                    ps.setObject(parameterIndex, null);
                    parameter = "null";
                    break;
                }
                ps.setObject(parameterIndex, o);
                LocalDateTime localDate = (LocalDateTime)o;
                parameter = "'" + dateTimeFormatter.format(localDate) + "'";
                break;
            }
            default: {
                ps.setObject(parameterIndex, field.get(instance));
                parameter = "'" + field.get(instance) + "'";
            }
        }
        AbstractSQLBuilder.replaceFirst(sqlBuilder, parameter);
    }

    protected static void replaceFirst(StringBuilder sqlBuilder, String parameter) {
        int indexOf = sqlBuilder.indexOf(PLACEHOLDER);
        if (indexOf >= 0) {
            sqlBuilder.replace(indexOf, indexOf + PLACEHOLDER.length(), parameter);
        }
    }
}

