/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.table.H2TableBuilder;
import cn.schoolwow.quickdao.builder.table.MySQLTableBuilder;
import cn.schoolwow.quickdao.builder.table.PostgreTableBuilder;
import cn.schoolwow.quickdao.builder.table.SQLServerTableBuilder;
import cn.schoolwow.quickdao.builder.table.SQLiteTableBuilder;
import cn.schoolwow.quickdao.builder.table.TableBuilder;
import cn.schoolwow.quickdao.builder.table.TableBuilderInvocationHandler;
import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.SQLiteDAO;
import cn.schoolwow.quickdao.dao.sql.dml.IDGenerator;
import cn.schoolwow.quickdao.database.H2Database;
import cn.schoolwow.quickdao.database.MySQLDatabase;
import cn.schoolwow.quickdao.database.PostgreDatabase;
import cn.schoolwow.quickdao.database.SQLServerDatabase;
import cn.schoolwow.quickdao.database.SQLiteDatabase;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.handler.DefaultTableDefiner;
import cn.schoolwow.quickdao.handler.TableDefiner;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAO {
    private Logger logger = LoggerFactory.getLogger(QuickDAO.class);
    private QuickDAOConfig quickDAOConfig = new QuickDAOConfig();

    public static QuickDAO newInstance() {
        return new QuickDAO();
    }

    public QuickDAO() {
        this.quickDAOConfig.defaultTableDefiner = new DefaultTableDefiner(this, this.quickDAOConfig);
    }

    public QuickDAO dataSource(DataSource dataSource) {
        this.quickDAOConfig.dataSource = dataSource;
        try {
            Connection connection = this.quickDAOConfig.dataSource.getConnection();
            connection.setAutoCommit(false);
            String url = connection.getMetaData().getURL();
            this.logger.info("[\u6570\u636e\u6e90\u5730\u5740]{}", (Object)url);
            if (url.contains("jdbc:h2")) {
                this.quickDAOConfig.database = new H2Database();
                this.quickDAOConfig.tableBuilder = new H2TableBuilder(this.quickDAOConfig);
            } else if (url.contains("jdbc:sqlite")) {
                this.quickDAOConfig.database = new SQLiteDatabase();
                this.quickDAOConfig.tableBuilder = new SQLiteTableBuilder(this.quickDAOConfig);
            } else if (url.contains("jdbc:mysql")) {
                this.quickDAOConfig.database = new MySQLDatabase();
                this.quickDAOConfig.tableBuilder = new MySQLTableBuilder(this.quickDAOConfig);
            } else if (url.contains("jdbc:postgresql")) {
                this.quickDAOConfig.database = new PostgreDatabase();
                this.quickDAOConfig.tableBuilder = new PostgreTableBuilder(this.quickDAOConfig);
            } else if (url.contains("jdbc:sqlserver:")) {
                this.quickDAOConfig.database = new SQLServerDatabase();
                this.quickDAOConfig.tableBuilder = new SQLServerTableBuilder(this.quickDAOConfig);
            } else {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
            }
            this.quickDAOConfig.tableBuilder.connection = connection;
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    public QuickDAO packageName(String packageName) {
        this.quickDAOConfig.packageNameMap.put(packageName, "");
        return this;
    }

    public QuickDAO packageName(String packageName, String prefix) {
        this.quickDAOConfig.packageNameMap.put(packageName, prefix + "_");
        return this;
    }

    public QuickDAO entity(Class entityClass) {
        this.quickDAOConfig.entityClassMap.put(entityClass, "");
        return this;
    }

    public QuickDAO entity(Class entityClass, String prefix) {
        this.quickDAOConfig.entityClassMap.put(entityClass, prefix);
        return this;
    }

    public QuickDAO ignorePackageName(String ignorePackageName) {
        if (this.quickDAOConfig.ignorePackageNameList == null) {
            this.quickDAOConfig.ignorePackageNameList = new ArrayList<String>();
        }
        this.quickDAOConfig.ignorePackageNameList.add(ignorePackageName);
        return this;
    }

    public QuickDAO ignoreClass(Class ignoreClass) {
        if (this.quickDAOConfig.ignoreClassList == null) {
            this.quickDAOConfig.ignoreClassList = new ArrayList<Class>();
        }
        this.quickDAOConfig.ignoreClassList.add(ignoreClass);
        return this;
    }

    public QuickDAO filter(Predicate<Class> predicate) {
        this.quickDAOConfig.predicate = predicate;
        return this;
    }

    public QuickDAO foreignKey(boolean openForeignKey) {
        this.quickDAOConfig.openForeignKey = openForeignKey;
        return this;
    }

    public QuickDAO autoCreateTable(boolean autoCreateTable) {
        this.quickDAOConfig.autoCreateTable = autoCreateTable;
        return this;
    }

    public QuickDAO autoCreateProperty(boolean autoCreateProperty) {
        this.quickDAOConfig.autoCreateProperty = autoCreateProperty;
        return this;
    }

    public QuickDAO idStrategy(IdStrategy idStrategy) {
        this.quickDAOConfig.idStrategy = idStrategy;
        return this;
    }

    public QuickDAO idGenerator(IDGenerator idGenerator) {
        this.quickDAOConfig.idGenerator = idGenerator;
        return this;
    }

    public TableDefiner define(Class clazz) {
        if (this.quickDAOConfig.entityMap.isEmpty()) {
            try {
                this.quickDAOConfig.defaultTableDefiner.getEntityMap();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.quickDAOConfig.entityMap.containsKey(clazz.getName())) {
            throw new IllegalArgumentException("\u672a\u626b\u63cf\u5230\u6b64\u7c7b\u4fe1\u606f!\u7c7b\u540d:" + clazz.getName());
        }
        if (null == this.quickDAOConfig.database) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        this.quickDAOConfig.defaultTableDefiner.define(clazz);
        return this.quickDAOConfig.defaultTableDefiner;
    }

    public DAO build() {
        if (null == this.quickDAOConfig.database) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        if (this.quickDAOConfig.entityMap.isEmpty()) {
            try {
                this.quickDAOConfig.defaultTableDefiner.getEntityMap();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.quickDAOConfig.defaultTableDefiner.handleEntityMap();
            this.quickDAOConfig.tableBuilder.autoBuildDatabase();
            this.quickDAOConfig.tableBuilder.connection.commit();
            this.quickDAOConfig.tableBuilder.connection.close();
            TableBuilderInvocationHandler invocationHandler = new TableBuilderInvocationHandler(this.quickDAOConfig.tableBuilder);
            TableBuilder tableBuilderProxy = (TableBuilder)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{TableBuilder.class}, (InvocationHandler)invocationHandler);
            AbstractDAO dao = null;
            dao = this.quickDAOConfig.database instanceof SQLiteDatabase ? new SQLiteDAO(tableBuilderProxy, this.quickDAOConfig) : new AbstractDAO(tableBuilderProxy, this.quickDAOConfig);
            return dao;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

