package cn.schoolwow.quickdao.domain;

import cn.schoolwow.quickdao.builder.sql.dql.DQLSQLBuilder;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.condition.AbstractCondition;
import cn.schoolwow.quickdao.dao.response.UnionType;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 查询
 */
public class Query implements Serializable {
    /**
     * 关联Entity
     */
    public Entity entity;
    /**
     * distinct
     */
    public String distinct = "";
    /**
     * 列名
     */
    public StringBuilder columnBuilder = new StringBuilder();
    /**
     * 待排除的字段
     * */
    public List<String> excludeColumns = new ArrayList<>();
    /**
     * 聚合函数列名
     */
    public StringBuilder aggregateColumnBuilder = new StringBuilder();
    /**
     * 字段更新
     */
    public StringBuilder setBuilder = new StringBuilder();
    /**
     * 查询条件
     */
    public StringBuilder whereBuilder = new StringBuilder();
    /**
     * 分组查询
     */
    public StringBuilder groupByBuilder = new StringBuilder("group by ");
    /**
     * 排序
     */
    public StringBuilder orderByBuilder = new StringBuilder();
    /**
     * 分页
     */
    public String limit = "";
    /**
     * 是否返回复杂属性
     */
    public boolean compositField;
    /**
     * union类型
     * */
    public UnionType unionType;
    /**
     * union语句列表
     * */
    public List<AbstractCondition> unionList = new ArrayList<>();
    /**
     * or查询语句列表
     * */
    public List<AbstractCondition> orList = new ArrayList<>();
    /**
     * 参数索引
     */
    public int parameterIndex = 1;
    /**
     * 查询参数
     */
    public List parameterList = new ArrayList();
    /**
     * 更新参数
     */
    public List updateParameterList = new ArrayList();
    /**
     * 分页对象
     * */
    public PageVo pageVo;
    /**
     * 关联子查询
     */
    public List<SubQuery> subQueryList = new ArrayList<>();
    /**
     * 关联QuickDAOConfig
     * */
    public QuickDAOConfig quickDAOConfig;
    /**
     * 关联DAO
     * */
    public DAO dao;
    /**
     * DQL查询语句构建
     * */
    public DQLSQLBuilder dqlsqlBuilder;
}
