/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.util;

import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.Unique;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionUtil {
    private static JSONObject sqlCache = new JSONObject();
    private static Map<String, Field[]> classFieldsCache = new HashMap<String, Field[]>();
    private static Map<String, Field[]> classCompositFieldsCache = new HashMap<String, Field[]>();
    private static Map<String, Field> compositFieldCache = new HashMap<String, Field>();
    public static Map<String, Field> idCache = new HashMap<String, Field>();
    public static Map<String, Field[]> uniqueFieldsCache = new HashMap<String, Field[]>();

    public static boolean isIdField(Field field) {
        return idCache.get(field.getDeclaringClass().getName()).getName().equals(field.getName());
    }

    public static Field getId(Class _class) {
        return idCache.get(_class.getName());
    }

    public static void setId(Object instance, long value) throws IllegalAccessException {
        Field id = ReflectionUtil.getId(instance.getClass());
        id.setLong(instance, value);
    }

    public static Field[] getFields(Class _class) {
        if (!classFieldsCache.containsKey(_class.getName())) {
            AccessibleObject[] fields = _class.getDeclaredFields();
            Field.setAccessible(fields, true);
            ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>(fields.length);
            Set<String> packageNameSet = QuickDAOConfig.packageNameMap.keySet();
            for (AccessibleObject field : fields) {
                boolean contains = false;
                for (String packageName : packageNameSet) {
                    if (!((Field)field).getType().getName().contains(packageName)) continue;
                    contains = true;
                    break;
                }
                if (contains) {
                    compositFieldCache.put(_class.getName() + "_" + ((Field)field).getType().getName() + "_" + ((Field)field).getName(), (Field)field);
                    continue;
                }
                if (field.getDeclaredAnnotation(Ignore.class) != null) continue;
                fieldList.add(field);
            }
            fields = fieldList.toArray(new Field[fieldList.size()]);
            classFieldsCache.put(_class.getName(), (Field[])fields);
        }
        return classFieldsCache.get(_class.getName());
    }

    public static Field[] getCompositField(Class _class, Class fieldType) {
        String target = _class.getName() + "_" + fieldType.getName();
        if (classCompositFieldsCache.containsKey(target)) {
            return classCompositFieldsCache.get(target);
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Set<String> keySet = compositFieldCache.keySet();
        for (String key : keySet) {
            if (!key.contains(target)) continue;
            fieldList.add(compositFieldCache.get(key));
        }
        if (fieldList.size() == 0) {
            return null;
        }
        Field[] fields = fieldList.toArray(new Field[fieldList.size()]);
        classCompositFieldsCache.put(target, fields);
        return fields;
    }

    public static boolean hasUniqueKey(Class _class) {
        String key = "hasUniqueKey_" + _class.getName();
        if (!sqlCache.containsKey((Object)key)) {
            Field[] fields = ReflectionUtil.getUniqueFields(_class);
            return fields != null && fields.length > 0;
        }
        return sqlCache.getBoolean(key);
    }

    public static Field[] getUniqueFields(Class _class) {
        return uniqueFieldsCache.get(_class.getName());
    }

    public static boolean hasId(Object instance) throws IllegalAccessException {
        Class<?> _class = instance.getClass();
        Field id = ReflectionUtil.getId(_class);
        switch (id.getType().getSimpleName().toLowerCase()) {
            case "int": {
                return id.getInt(instance) > 0;
            }
            case "integer": {
                return id.get(instance) != null && id.getInt(instance) > 0;
            }
            case "long": {
                return (id.getType().isPrimitive() || id.get(instance) != null) && id.getLong(instance) > 0L;
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u4e3b\u952e\u7c7b\u578b:" + id.getType().getSimpleName().toLowerCase());
    }

    public static String setValueWithInsertIgnore(PreparedStatement ps, Object instance, String sql) throws SQLException, IllegalAccessException {
        int parameterIndex = 1;
        Field[] fields = ReflectionUtil.getFields(instance.getClass());
        for (int i = 0; i < fields.length; ++i) {
            if (ReflectionUtil.isIdField(fields[i])) continue;
            sql = sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        return sql;
    }

    public static String setValueWithUpdateById(PreparedStatement ps, Object instance, String sql) throws SQLException, IllegalAccessException, NoSuchFieldException {
        int parameterIndex = 1;
        Field[] fields = ReflectionUtil.getFields(instance.getClass());
        for (int i = 0; i < fields.length; ++i) {
            if (ReflectionUtil.isIdField(fields[i])) continue;
            sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, ReflectionUtil.getId(instance.getClass())));
        return sql;
    }

    public static String setValueWithUpdateByUniqueKey(PreparedStatement ps, Object instance, String sql) throws SQLException, IllegalAccessException {
        int i;
        int parameterIndex = 1;
        Field[] fields = ReflectionUtil.getFields(instance.getClass());
        for (i = 0; i < fields.length; ++i) {
            if (fields[i].getAnnotation(Unique.class) != null) continue;
            sql = sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        for (i = 0; i < fields.length; ++i) {
            if (fields[i].getAnnotation(Unique.class) == null) continue;
            sql = sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        return sql;
    }

    public static <T> List<T> mappingSingleResultToList(ResultSet resultSet, int count, Class<T> _class) throws SQLException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        JSONArray array = new JSONArray(count);
        while (resultSet.next()) {
            array.add((Object)resultSet.getString(1));
        }
        resultSet.close();
        return array.toJavaList(_class);
    }

    public static JSONArray mappingResultSetToJSONArray(ResultSet resultSet, String tableNameAlias, int count) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int i = 1; i <= columnNames.length; ++i) {
            String label = metaData.getColumnLabel(i);
            columnNames[i - 1] = StringUtil.Underline2Camel(label.substring(label.indexOf("_") + 1));
        }
        JSONArray array = new JSONArray(count);
        while (resultSet.next()) {
            JSONObject o = new JSONObject();
            for (int i = 1; i <= columnCount; ++i) {
                o.put(columnNames[i - 1], (Object)resultSet.getString(i));
            }
            array.add((Object)o);
        }
        resultSet.close();
        return array;
    }

    private static String setParameter(Object instance, PreparedStatement ps, int parameterIndex, Field field) throws SQLException, IllegalAccessException {
        switch (field.getType().getSimpleName().toLowerCase()) {
            case "int": {
                ps.setInt(parameterIndex, field.getInt(instance));
                return "" + field.getInt(instance);
            }
            case "integer": {
                ps.setObject(parameterIndex, field.get(instance));
                return "" + field.get(instance);
            }
            case "long": {
                if (field.getType().isPrimitive()) {
                    ps.setLong(parameterIndex, field.getLong(instance));
                    return "" + field.getLong(instance);
                }
                ps.setObject(parameterIndex, field.get(instance));
                return "" + field.get(instance);
            }
            case "boolean": {
                if (field.getType().isPrimitive()) {
                    ps.setBoolean(parameterIndex, field.getBoolean(instance));
                    return "" + field.getBoolean(instance);
                }
                ps.setObject(parameterIndex, field.get(instance));
                return "" + field.get(instance);
            }
            case "string": {
                ps.setString(parameterIndex, field.get(instance) == null ? null : field.get(instance).toString());
                return "'" + (field.get(instance) == null ? "" : field.get(instance).toString()) + "'";
            }
        }
        ps.setObject(parameterIndex, field.get(instance));
        return "'" + field.get(instance) + "'";
    }
}

