/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteDAO
extends AbstractDAO {
    Logger logger = LoggerFactory.getLogger(SQLiteDAO.class);

    public SQLiteDAO(DataSource dataSource) {
        super(dataSource);
        this.fieldMapping.put("long", "INTEGER");
    }

    @Override
    protected String getSyntax(AbstractDAO.Syntax syntax, Object ... values) {
        switch (syntax) {
            case AutoIncrement: {
                return "autoincrement";
            }
            case InsertIgnore: {
                return "insert or ignore into ";
            }
            case Comment: {
                return "/*" + values[0] + "*/";
            }
        }
        return "";
    }

    @Override
    protected void createTable(JSONObject entity, Connection connection) throws SQLException {
        String tableName = entity.getString("tableName");
        StringBuilder createTableBuilder = new StringBuilder("create table `" + tableName + "`(");
        if (entity.containsKey((Object)"comment")) {
            createTableBuilder.append("/*" + entity.getString("comment") + "*/");
        }
        JSONArray properties = entity.getJSONArray("properties");
        for (int j = 0; j < properties.size(); ++j) {
            JSONObject property = properties.getJSONObject(j);
            if (property.getBoolean("ignore").booleanValue()) continue;
            createTableBuilder.append("`" + property.getString("column") + "` " + property.getString("columnType"));
            if (property.getBoolean("id").booleanValue()) {
                createTableBuilder.append(" primary key " + this.getSyntax(AbstractDAO.Syntax.AutoIncrement, new Object[0]));
            } else {
                if (property.containsKey((Object)"default")) {
                    createTableBuilder.append(" default " + property.getString("default"));
                }
                if (property.getBoolean("notNull").booleanValue()) {
                    createTableBuilder.append(" not null ");
                }
            }
            createTableBuilder.append(" " + this.getSyntax(AbstractDAO.Syntax.Comment, property.getString("comment")));
            createTableBuilder.append(",");
        }
        if (QuickDAOConfig.openForeignKey) {
            JSONArray foreignKeyProperties = entity.getJSONArray("foreignKeyProperties");
            for (int j = 0; j < foreignKeyProperties.size(); ++j) {
                JSONObject property = foreignKeyProperties.getJSONObject(j);
                createTableBuilder.append("foreign key(`" + property.getString("column") + "`) references " + property.getString("foreignKey") + ",");
            }
            connection.prepareStatement("PRAGMA foreign_keys = ON;").executeUpdate();
        }
        createTableBuilder.deleteCharAt(createTableBuilder.length() - 1);
        createTableBuilder.append(")");
        String sql = createTableBuilder.toString().replaceAll("\\s+", " ");
        this.logger.debug("[\u751f\u6210\u65b0\u8868{}=>{}]\u6267\u884csql:{}", new Object[]{entity.getString("className"), tableName, sql});
        connection.prepareStatement(sql).executeUpdate();
        this.createUniqueKey(entity, connection);
    }

    @Override
    protected void createUniqueKey(JSONObject entity, Connection connection) throws SQLException {
        String tableName = entity.getString("tableName");
        JSONArray uniqueKeyProperties = entity.getJSONArray("uniqueKeyProperties");
        if (uniqueKeyProperties.size() == 0) {
            return;
        }
        StringBuilder uniqueKeyBuilder = new StringBuilder("create unique index `" + tableName + "_unique_index` on `" + tableName + "` (");
        for (int i = 0; i < uniqueKeyProperties.size(); ++i) {
            uniqueKeyBuilder.append("`" + uniqueKeyProperties.getString(i) + "`,");
        }
        uniqueKeyBuilder.deleteCharAt(uniqueKeyBuilder.length() - 1);
        uniqueKeyBuilder.append(");");
        String uniqueKeySQL = uniqueKeyBuilder.toString().replaceAll("\\s+", " ");
        this.logger.debug("[\u6dfb\u52a0\u552f\u4e00\u6027\u7ea6\u675f]\u8868:{},\u6267\u884cSQL:{}", (Object)tableName, (Object)uniqueKeySQL);
        connection.prepareStatement(uniqueKeySQL).executeUpdate();
    }

    @Override
    protected void createForeignKey(JSONArray entityList, Connection connection) throws SQLException {
    }

    @Override
    public JSONArray getDatabaseInfo() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement tablePs = connection.prepareStatement("select name from sqlite_master where type='table';");
        ResultSet tableRs = tablePs.executeQuery();
        JSONArray entityList = new JSONArray();
        while (tableRs.next()) {
            JSONObject entity = new JSONObject();
            entity.put("tableName", (Object)tableRs.getString(1));
            JSONArray properties = new JSONArray();
            PreparedStatement propertyPs = connection.prepareStatement("PRAGMA table_info(`" + tableRs.getString(1) + "`)");
            ResultSet propertiesRs = propertyPs.executeQuery();
            while (propertiesRs.next()) {
                JSONObject property = new JSONObject();
                property.put("column", (Object)propertiesRs.getString("name"));
                property.put("columnType", (Object)propertiesRs.getString("type"));
                property.put("notNull", (Object)"1".equals(propertiesRs.getString("notnull")));
                if (null != propertiesRs.getString("dflt_value")) {
                    property.put("default", (Object)propertiesRs.getString("dflt_value"));
                }
                properties.add((Object)property);
            }
            entity.put("properties", (Object)properties);
            entityList.add((Object)entity);
            propertiesRs.close();
            propertyPs.close();
        }
        tableRs.close();
        tablePs.close();
        connection.close();
        return entityList;
    }
}

