/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.DefaultValue;
import cn.schoolwow.quickdao.annotation.ForeignKey;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.NotNull;
import cn.schoolwow.quickdao.annotation.Unique;
import cn.schoolwow.quickdao.condition.AbstractCondition;
import cn.schoolwow.quickdao.condition.Condition;
import cn.schoolwow.quickdao.condition.SqliteCondition;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.H2DAO;
import cn.schoolwow.quickdao.dao.SQLiteDAO;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.util.ReflectionUtil;
import cn.schoolwow.quickdao.util.SQLUtil;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickdao.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDAO
implements DAO {
    Logger logger = LoggerFactory.getLogger(AbstractDAO.class);
    protected Map<String, String> fieldMapping = new HashMap<String, String>();
    protected DataSource dataSource;
    private Connection connection;
    public boolean startTranscation = false;
    private JSONArray entityList = null;

    public AbstractDAO(DataSource dataSource) {
        this.dataSource = dataSource;
        this.fieldMapping.put("string", "VARCHAR(255)");
        this.fieldMapping.put("boolean", "BOOLEAN");
        this.fieldMapping.put("byte", "TINYINT");
        this.fieldMapping.put("char", "char(4)");
        this.fieldMapping.put("short", "SMALLINT");
        this.fieldMapping.put("int", "INTEGER");
        this.fieldMapping.put("integer", "INTEGER(11)");
        this.fieldMapping.put("long", "BIGINT");
        this.fieldMapping.put("float", "FLOAT(4,2)");
        this.fieldMapping.put("double", "DOUBLE(5,2)");
        this.fieldMapping.put("date", "DATETIME");
        this.fieldMapping.put("time", "TIME");
        this.fieldMapping.put("timestamp", "TIMESTAMP");
    }

    protected abstract String getSyntax(Syntax var1, Object ... var2);

    @Override
    public boolean exist(Object instance) {
        try {
            if (ReflectionUtil.hasId(instance)) {
                return true;
            }
            Condition condition = this.getUniqueCondition(instance);
            if (condition == null) {
                return false;
            }
            return condition.count() > 0L;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public <T> T fetch(Class<T> _class, long id) {
        String name = ReflectionUtil.getId(_class).getName();
        return this.fetch(_class, name, id);
    }

    @Override
    public <T> T fetch(Class<T> _class, String property, Object value) {
        List<T> instanceList = this.fetchList(_class, property, value);
        if (ValidateUtil.isNotEmpty(instanceList)) {
            return instanceList.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> fetchList(Class<T> _class, String property, Object value) {
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ps = null;
            int count = -1;
            if (value == null) {
                String fetchNullSQL = SQLUtil.fetchNull(_class, property);
                this.logger.debug("[\u6839\u636e\u5c5e\u6027{}=>{}\u83b7\u53d6\u5bf9\u8c61]\u6267\u884csql:{}", new Object[]{property, value, fetchNullSQL});
                ps = connection.prepareStatement(fetchNullSQL);
                count = (int)this.query(_class).addNullQuery(property).count();
            } else {
                String fetchSQL = SQLUtil.fetch(_class, property);
                this.logger.debug("[\u6839\u636e\u5c5e\u6027{}=>{}\u83b7\u53d6\u5bf9\u8c61]\u6267\u884csql:{}", new Object[]{property, value, fetchSQL.replace("?", value.toString())});
                ps = connection.prepareStatement(fetchSQL);
                switch (value.getClass().getSimpleName().toLowerCase()) {
                    case "int": {
                        ps.setInt(1, (Integer)value);
                        break;
                    }
                    case "integer": {
                        ps.setObject(1, (Integer)value);
                        break;
                    }
                    case "long": {
                        if (value.getClass().isPrimitive()) {
                            ps.setLong(1, (Long)value);
                            break;
                        }
                        ps.setObject(1, value);
                        break;
                    }
                    case "boolean": {
                        if (value.getClass().isPrimitive()) {
                            ps.setBoolean(1, (Boolean)value);
                            break;
                        }
                        ps.setObject(1, value);
                        break;
                    }
                    case "string": {
                        ps.setString(1, value.toString());
                        break;
                    }
                    default: {
                        ps.setObject(1, value);
                    }
                }
                count = (int)this.query(_class).addQuery(property, value).count();
            }
            ResultSet resultSet = ps.executeQuery();
            List instanceList = ReflectionUtil.mappingResultSetToJSONArray(resultSet, "t", count).toJavaList(_class);
            ps.close();
            connection.close();
            return instanceList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <T> Condition<T> query(Class<T> _class) {
        if (this instanceof SQLiteDAO || this instanceof H2DAO) {
            return new SqliteCondition((Class)_class, this.dataSource, this);
        }
        return new AbstractCondition<T>(_class, this.dataSource, this);
    }

    @Override
    public long save(Object instance) {
        if (instance == null) {
            return 0L;
        }
        try {
            Connection connection = this.getConnection();
            Class<?> _class = instance.getClass();
            Statement ps = null;
            long effect = 0L;
            if (this.exist(instance)) {
                if (ReflectionUtil.hasUniqueKey(instance.getClass())) {
                    String updateByUniqueKey = SQLUtil.updateByUniqueKey(instance.getClass());
                    ps = connection.prepareStatement(updateByUniqueKey);
                    this.logger.debug("[\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateByUniqueKey((PreparedStatement)ps, instance, updateByUniqueKey));
                    effect = ps.executeUpdate();
                    Condition condition = this.getUniqueCondition(instance);
                    List<Long> ids = condition.getValueList(Long.class, ReflectionUtil.getId(_class).getName());
                    if (ids.size() > 0) {
                        ReflectionUtil.setId(instance, ids.get(0));
                    }
                } else if (ReflectionUtil.hasId(instance)) {
                    String updateById = SQLUtil.updateById(instance.getClass());
                    ps = connection.prepareStatement(updateById);
                    this.logger.debug("[\u6839\u636eid\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateById((PreparedStatement)ps, instance, updateById));
                    effect = ps.executeUpdate();
                }
            } else {
                String insertIgnore = SQLUtil.insertIgnore(instance.getClass(), this.getSyntax(Syntax.InsertIgnore, new Object[0]));
                ps = connection.prepareStatement(insertIgnore, 1);
                this.logger.debug("[\u6267\u884c\u63d2\u5165\u64cd\u4f5c]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithInsertIgnore((PreparedStatement)ps, instance, insertIgnore));
                effect = ps.executeUpdate();
                if (effect > 0L) {
                    ResultSet rs = ps.getGeneratedKeys();
                    if (rs.next()) {
                        long id = rs.getLong(1);
                        ReflectionUtil.setId(instance, id);
                    }
                    rs.close();
                }
            }
            ps.close();
            if (!this.startTranscation) {
                connection.close();
            }
            return effect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public long save(List instanceList) {
        if (instanceList == null || instanceList.size() == 0) {
            return 0L;
        }
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            String updateByUniqueKey = SQLUtil.updateByUniqueKey(instanceList.get(0).getClass());
            PreparedStatement _updateByUniqueKeyPs = null;
            Field[] uniqueFields = ReflectionUtil.getUniqueFields(instanceList.get(0).getClass());
            if (uniqueFields != null && uniqueFields.length > 0) {
                this.logger.debug("[\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0]SQL\u8bed\u53e5:{}", (Object)updateByUniqueKey);
                _updateByUniqueKeyPs = connection.prepareStatement(updateByUniqueKey);
            }
            PreparedStatement updateByUniqueKeyPs = _updateByUniqueKeyPs;
            String updateById = SQLUtil.updateById(instanceList.get(0).getClass());
            PreparedStatement updateByIdPs = connection.prepareStatement(updateById);
            String insertIgnore = SQLUtil.insertIgnore(instanceList.get(0).getClass(), this.getSyntax(Syntax.InsertIgnore, new Object[0]));
            PreparedStatement insertIgnorePs = connection.prepareStatement(insertIgnore);
            instanceList.stream().forEach(instance -> {
                try {
                    if (this.exist(instance)) {
                        if (ReflectionUtil.hasUniqueKey(instance.getClass())) {
                            this.logger.debug("[\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateByUniqueKey(updateByUniqueKeyPs, instance, updateByUniqueKey));
                            updateByUniqueKeyPs.addBatch();
                        } else if (ReflectionUtil.hasId(instance)) {
                            this.logger.debug("[\u6839\u636eid\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateById(updateByIdPs, instance, updateById));
                            updateByIdPs.addBatch();
                        }
                    } else {
                        this.logger.debug("[\u6267\u884c\u63d2\u5165\u64cd\u4f5c]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithInsertIgnore(insertIgnorePs, instance, insertIgnore));
                        insertIgnorePs.addBatch();
                    }
                }
                catch (Exception e) {
                    this.logger.warn("[\u63d2\u5165\u5355\u4e2a\u8bb0\u5f55\u5931\u8d25]{}", (Object)JSON.toJSONString((Object)instance));
                    e.printStackTrace();
                }
            });
            long effect = 0L;
            PreparedStatement[] preparedStatements = new PreparedStatement[]{updateByUniqueKeyPs, updateByIdPs, insertIgnorePs};
            for (int i = 0; i < preparedStatements.length; ++i) {
                int[] results;
                if (preparedStatements[i] == null) continue;
                int[] nArray = results = preparedStatements[i].executeBatch();
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    long result = nArray[j];
                    effect += result;
                }
                preparedStatements[i].close();
            }
            if (!this.startTranscation) {
                connection.commit();
                connection.close();
            }
            return effect;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return -1L;
        }
    }

    @Override
    public long save(Object[] instances) {
        return this.save(Arrays.asList(instances));
    }

    @Override
    public long delete(Class _class, long id) {
        String name = ReflectionUtil.getId(_class).getName();
        return this.delete(_class, name, id);
    }

    @Override
    public long delete(Class _class, String field, Object value) {
        try {
            Connection connection = this.getConnection();
            String deleteSQL = SQLUtil.delete(_class, field);
            PreparedStatement ps = connection.prepareStatement(deleteSQL);
            ps.setObject(1, value);
            this.logger.debug("[\u6839\u636e\u5c5e\u6027{}=>{}\u5220\u9664]\u6267\u884cSQL:{}", new Object[]{field, value, deleteSQL.replace("?", value.toString())});
            long effect = ps.executeUpdate();
            ps.close();
            if (!this.startTranscation) {
                connection.close();
            }
            return effect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public long clear(Class _class) {
        try {
            Connection connection = this.getConnection();
            String sql = "delete from `" + SQLUtil.classTableMap.get(_class.getName()) + "`";
            this.logger.debug("[\u5220\u9664{}\u8868]\u6267\u884cSQL:{}", (Object)_class.getSimpleName(), (Object)sql);
            PreparedStatement ps = connection.prepareStatement(sql);
            long effect = ps.executeUpdate();
            ps.close();
            if (!this.startTranscation) {
                connection.close();
            }
            return effect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public void startTransaction() {
        this.startTranscation = true;
        try {
            this.connection = this.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.connection.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public Savepoint setSavePoint(String name) {
        if (this.connection == null) {
            return null;
        }
        try {
            return this.connection.setSavepoint(name);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void rollback() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void rollback(Savepoint savePoint) {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.rollback(savePoint);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void commit() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endTransaction() {
        this.startTranscation = false;
        if (this.connection == null) {
            this.logger.warn("\u6570\u636e\u5e93\u4e8b\u52a1\u8fde\u63a5\u4e3a\u7a7a!\u4e0d\u505a\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public void create(Class _class) {
        String tableName = SQLUtil.classTableMap.get(_class.getName());
        for (int i = 0; i < this.entityList.size(); ++i) {
            JSONObject o = this.entityList.getJSONObject(i);
            if (!o.getString("tableName").equals(tableName)) continue;
            try {
                Connection connection = this.dataSource.getConnection();
                this.createTable(o, connection);
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(Class _class) {
        String tableName = SQLUtil.classTableMap.get(_class.getName());
        String sql = "drop table if exists `" + tableName + "`;";
        this.logger.debug("[\u5220\u9664\u8868=>{}]\u6267\u884cSQL:{}", (Object)_class.getSimpleName(), (Object)sql);
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.prepareStatement(sql).execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void rebuild(Class _class) {
        this.drop(_class);
        this.create(_class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.startTranscation) {
            AbstractDAO abstractDAO = this;
            synchronized (abstractDAO) {
                if (this.connection == null) {
                    this.connection = this.dataSource.getConnection();
                    this.connection.setAutoCommit(false);
                }
            }
            return this.connection;
        }
        return this.dataSource.getConnection();
    }

    private <T> Condition<T> getUniqueCondition(Object instance) throws IllegalAccessException {
        Field[] fields = ReflectionUtil.getUniqueFields(instance.getClass());
        if (fields == null || fields.length == 0) {
            return null;
        }
        Condition<?> condition = this.query(instance.getClass());
        for (Field field : fields) {
            condition.addQuery(field.getName(), field.get(instance));
        }
        return condition;
    }

    private JSONArray getEntityInfo() throws ClassNotFoundException, IOException {
        Set<String> keySet = QuickDAOConfig.packageNameMap.keySet();
        JSONArray entityList = new JSONArray();
        for (String packageName : keySet) {
            JarFile jarFile;
            JarURLConnection jarURLConnection;
            List<Object> classList = new ArrayList();
            String packageNamePath = packageName.replace(".", "/");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(packageNamePath);
            if (url == null) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u5305\u8def\u5f84:" + packageNamePath);
            }
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.getFile());
                this.logger.info("[\u7c7b\u6587\u4ef6\u8def\u5f84]{}", (Object)file.getAbsolutePath());
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                }
                Stack<File> stack = new Stack<File>();
                stack.push(file);
                String string = packageName.replace(".", "/");
                while (!stack.isEmpty()) {
                    file = (File)stack.pop();
                    for (File f : file.listFiles()) {
                        if (f.isDirectory()) {
                            stack.push(f);
                            continue;
                        }
                        if (!f.isFile() || !f.getName().endsWith(".class")) continue;
                        String path = f.getAbsolutePath().replace("\\", "/");
                        int startIndex = path.indexOf(string);
                        String className = path.substring(startIndex, path.length() - 6).replace("/", ".");
                        classList.add(Class.forName(className));
                    }
                }
            } else if ("jar".equals(url.getProtocol()) && null != (jarURLConnection = (JarURLConnection)url.openConnection()) && null != (jarFile = jarURLConnection.getJarFile())) {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    classList.add(Class.forName(className));
                }
            }
            if (classList.size() == 0) {
                this.logger.warn("[\u626b\u63cf\u5b9e\u4f53\u7c7b\u4fe1\u606f\u4e3a\u7a7a]\u524d\u7f00:{},\u5305\u540d:{}", (Object)QuickDAOConfig.packageNameMap.get(packageName), (Object)packageName);
                continue;
            }
            Stream<Class> stream = classList.stream().filter(_class -> {
                boolean result = true;
                if (QuickDAOConfig.ignoreClassList != null && QuickDAOConfig.ignoreClassList.contains(_class)) {
                    this.logger.warn("[\u5ffd\u7565\u7c7b\u540d]\u7c7b\u540d:{}!", (Object)_class.getName());
                    result = false;
                }
                if (QuickDAOConfig.ignorePackageNameList != null) {
                    for (String ignorePackageName : QuickDAOConfig.ignorePackageNameList) {
                        if (!_class.getName().contains(ignorePackageName)) continue;
                        this.logger.warn("[\u5ffd\u7565\u5305\u540d]\u5305\u540d:{}\u7c7b\u540d:{}", (Object)ignorePackageName, (Object)_class.getName());
                        result = false;
                    }
                }
                return result;
            });
            if (QuickDAOConfig.predicate != null) {
                stream.filter(QuickDAOConfig.predicate);
            }
            classList = stream.collect(Collectors.toList());
            for (Class clazz : classList) {
                String tableName = null;
                if (packageName.length() + clazz.getSimpleName().length() + 1 == clazz.getName().length()) {
                    tableName = StringUtil.Camel2Underline(clazz.getSimpleName());
                } else {
                    String prefix = clazz.getName().substring(packageName.length() + 1, clazz.getName().lastIndexOf(".")).replace(".", "_");
                    tableName = prefix + "@" + StringUtil.Camel2Underline(clazz.getSimpleName());
                }
                SQLUtil.classTableMap.put(clazz.getName(), QuickDAOConfig.packageNameMap.get(packageName) + tableName);
            }
            for (Class clazz : classList) {
                JSONObject entity = new JSONObject();
                entity.put("ignore", (Object)(clazz.getDeclaredAnnotation(Ignore.class) != null ? 1 : 0));
                if (entity.getBoolean("ignore").booleanValue()) {
                    this.logger.debug("[\u5ffd\u7565\u5b9e\u4f53\u7c7b=>{}]\u8be5\u7c7b\u88ab@Ignore\u6ce8\u89e3\u4fee\u9970,\u5c06\u8df3\u8fc7\u8be5\u5b9e\u4f53\u7c7b!", (Object)clazz.getName());
                    continue;
                }
                entity.put("tableName", (Object)SQLUtil.classTableMap.get(clazz.getName()));
                entity.put("className", (Object)clazz.getSimpleName());
                if (clazz.getDeclaredAnnotation(Comment.class) != null) {
                    Comment comment = clazz.getDeclaredAnnotation(Comment.class);
                    entity.put("comment", (Object)comment.value());
                }
                Field[] fields = ReflectionUtil.getFields(clazz);
                JSONArray properties = new JSONArray();
                JSONArray uniqueKeyProperties = new JSONArray();
                JSONArray foreignKeyProperties = new JSONArray();
                ArrayList<Field> uniqueFieldList = new ArrayList<Field>();
                for (int i = 0; i < fields.length; ++i) {
                    ForeignKey foreignKey;
                    JSONObject property = new JSONObject();
                    boolean ignore = fields[i].getType().getName().contains(packageName) || fields[i].getDeclaredAnnotation(Ignore.class) != null;
                    property.put("ignore", (Object)ignore);
                    property.put("column", (Object)StringUtil.Camel2Underline(fields[i].getName()));
                    property.put("name", (Object)fields[i].getName());
                    property.put("type", (Object)fields[i].getType().getSimpleName().toLowerCase());
                    property.put("unique", (Object)(fields[i].getDeclaredAnnotation(Unique.class) != null ? 1 : 0));
                    property.put("notNull", (Object)(fields[i].getDeclaredAnnotation(NotNull.class) != null ? 1 : 0));
                    property.put("id", (Object)(fields[i].getDeclaredAnnotation(Id.class) != null || "id".equals(property.getString("column")) ? 1 : 0));
                    if (property.getBoolean("id").booleanValue()) {
                        property.put("notNull", (Object)true);
                        fields[i].setAccessible(true);
                        ReflectionUtil.idCache.put(clazz.getName(), fields[i]);
                    }
                    if (fields[i].getDeclaredAnnotation(ColumnType.class) != null) {
                        property.put("columnType", (Object)fields[i].getDeclaredAnnotation(ColumnType.class).value());
                    } else {
                        property.put("columnType", (Object)this.fieldMapping.get(property.getString("type")));
                    }
                    if (fields[i].getDeclaredAnnotation(DefaultValue.class) != null) {
                        property.put("default", (Object)fields[i].getDeclaredAnnotation(DefaultValue.class).value());
                    }
                    property.put("comment", (Object)"");
                    if (fields[i].getDeclaredAnnotation(Comment.class) != null) {
                        property.put("comment", (Object)fields[i].getDeclaredAnnotation(Comment.class).value());
                    }
                    if (property.getBoolean("unique").booleanValue()) {
                        uniqueKeyProperties.add((Object)property.getString("column"));
                        uniqueFieldList.add(fields[i]);
                    }
                    if ((foreignKey = fields[i].getDeclaredAnnotation(ForeignKey.class)) != null) {
                        String operation = foreignKey.foreignKeyOption().getOperation();
                        property.put("foreignKey", (Object)("`" + SQLUtil.classTableMap.get(foreignKey.table().getName()) + "`(`" + foreignKey.field() + "`) ON DELETE " + operation + " ON UPDATE " + operation));
                        property.put("foreignKeyName", (Object)("FK_" + entity.getString("tableName") + "_" + foreignKey.field() + "_" + SQLUtil.classTableMap.get(foreignKey.table().getName()) + "_" + property.getString("name")));
                        foreignKeyProperties.add((Object)property);
                    }
                    properties.add((Object)property);
                }
                ReflectionUtil.uniqueFieldsCache.put(clazz.getName(), uniqueFieldList.toArray(new Field[uniqueFieldList.size()]));
                entity.put("properties", (Object)properties);
                entity.put("uniqueKeyProperties", (Object)uniqueKeyProperties);
                entity.put("foreignKeyProperties", (Object)foreignKeyProperties);
                entityList.add((Object)entity);
            }
        }
        this.logger.debug("[\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f]\u5b9e\u4f53\u7c7b\u4e2a\u6570:{}", (Object)entityList.size());
        return entityList;
    }

    protected JSONArray getDatabaseInfo() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement tablePs = connection.prepareStatement("show tables;");
        ResultSet tableRs = tablePs.executeQuery();
        JSONArray entityList = new JSONArray();
        while (tableRs.next()) {
            JSONObject entity = new JSONObject();
            entity.put("tableName", (Object)tableRs.getString(1));
            JSONArray properties = new JSONArray();
            PreparedStatement propertyPs = connection.prepareStatement("show columns from `" + tableRs.getString(1) + "`");
            ResultSet propertiesRs = propertyPs.executeQuery();
            while (propertiesRs.next()) {
                JSONObject property = new JSONObject();
                property.put("column", (Object)propertiesRs.getString("Field"));
                property.put("columnType", (Object)propertiesRs.getString("Type"));
                property.put("notNull", (Object)"NO".equals(propertiesRs.getString("Null")));
                property.put("unique", (Object)"UNI".equals(propertiesRs.getString("Key")));
                if (null != propertiesRs.getString("Default")) {
                    property.put("default", (Object)propertiesRs.getString("Default"));
                }
                properties.add((Object)property);
            }
            entity.put("properties", (Object)properties);
            entityList.add((Object)entity);
            propertiesRs.close();
            propertyPs.close();
        }
        tableRs.close();
        tablePs.close();
        connection.close();
        return entityList;
    }

    public void autoBuildDatabase() {
        try {
            this.entityList = this.getEntityInfo();
            if (!QuickDAOConfig.autoCreateTable) {
                return;
            }
            JSONArray dbEntityList = this.getDatabaseInfo();
            this.logger.debug("[\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f]\u6570\u636e\u5e93\u8868\u4e2a\u6570:{}", (Object)dbEntityList.size());
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            for (int i = 0; i < this.entityList.size(); ++i) {
                JSONObject entity = this.entityList.getJSONObject(i);
                String tableName = entity.getString("tableName");
                JSONObject dbEntity = this.getValue(dbEntityList, "tableName", tableName);
                if (dbEntity == null) {
                    this.createTable(entity, connection);
                    continue;
                }
                this.compareEntityDatabase(entity, dbEntity, connection);
            }
            if (QuickDAOConfig.openForeignKey) {
                this.createForeignKey(this.entityList, connection);
            }
            connection.commit();
            connection.setAutoCommit(true);
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createTable(JSONObject entity, Connection connection) throws SQLException {
        String tableName = entity.getString("tableName");
        StringBuilder createTableBuilder = new StringBuilder("create table if not exists `" + tableName + "`(");
        JSONArray properties = entity.getJSONArray("properties");
        for (int j = 0; j < properties.size(); ++j) {
            JSONObject property = properties.getJSONObject(j);
            if (property.getBoolean("ignore").booleanValue()) continue;
            createTableBuilder.append("`" + property.getString("column") + "` " + property.getString("columnType"));
            if (property.getBoolean("id").booleanValue()) {
                createTableBuilder.append(" primary key " + this.getSyntax(Syntax.AutoIncrement, new Object[0]));
            } else {
                if (property.containsKey((Object)"default")) {
                    createTableBuilder.append(" default " + property.getString("default"));
                }
                if (property.getBoolean("notNull").booleanValue()) {
                    createTableBuilder.append(" not null ");
                }
            }
            createTableBuilder.append(" " + this.getSyntax(Syntax.Comment, property.getString("comment")));
            createTableBuilder.append(",");
        }
        createTableBuilder.deleteCharAt(createTableBuilder.length() - 1);
        createTableBuilder.append(")");
        if (entity.containsKey((Object)"comment")) {
            createTableBuilder.append("comment='" + entity.getString("comment") + "';");
        }
        String sql = createTableBuilder.toString().replaceAll("\\s+", " ");
        this.logger.debug("[\u751f\u6210\u65b0\u8868{}=>{}]\u6267\u884csql:{}", new Object[]{entity.getString("className"), tableName, sql});
        connection.prepareStatement(sql).executeUpdate();
        this.createUniqueKey(entity, connection);
    }

    protected void compareEntityDatabase(JSONObject entity, JSONObject dbEntity, Connection connection) throws SQLException {
        String tableName = entity.getString("tableName");
        JSONArray sourceProperties = entity.getJSONArray("properties");
        JSONArray dbEntityProperties = dbEntity.getJSONArray("properties");
        for (int j = 0; j < sourceProperties.size(); ++j) {
            String column;
            JSONObject dbProperty;
            JSONObject sourceProperty = sourceProperties.getJSONObject(j);
            if (sourceProperty.getBoolean("ignore").booleanValue() || (dbProperty = this.getValue(dbEntityProperties, "column", column = sourceProperty.getString("column"))) != null) continue;
            String columnType = sourceProperty.getString("columnType");
            StringBuilder addColumnBuilder = new StringBuilder();
            addColumnBuilder.append("alter table `" + tableName + "` add column `" + column + "` " + columnType + " ");
            if (sourceProperty.containsKey((Object)"default")) {
                addColumnBuilder.append(" default " + sourceProperty.getString("default"));
            }
            addColumnBuilder.append(" " + this.getSyntax(Syntax.Comment, sourceProperty.getString("comment")));
            String foreignKey = sourceProperty.getString("foreignKey");
            if (foreignKey != null) {
                addColumnBuilder.append(",constraint `" + sourceProperty.containsKey((Object)"foreignKeyName") + "` foreign key(`" + column + "`) references " + foreignKey);
            }
            addColumnBuilder.append(";");
            String sql = addColumnBuilder.toString().replaceAll("\\s+", " ");
            this.logger.debug("[\u6dfb\u52a0\u65b0\u5217]\u8868:{},\u5217\u540d:{},\u6267\u884cSQL:{}", new Object[]{tableName, column + "(" + columnType + ")", sql});
            connection.prepareStatement(sql).executeUpdate();
            if (!sourceProperty.getBoolean("unique").booleanValue()) continue;
            this.createUniqueKey(entity, connection);
        }
    }

    protected void createUniqueKey(JSONObject entity, Connection connection) throws SQLException {
        String tableName = entity.getString("tableName");
        JSONArray uniqueKeyProperties = entity.getJSONArray("uniqueKeyProperties");
        if (uniqueKeyProperties.size() == 0) {
            return;
        }
        StringBuilder uniqueKeyBuilder = new StringBuilder("alter table `" + tableName + "` add unique index `" + tableName + "_unique_index` (");
        for (int i = 0; i < uniqueKeyProperties.size(); ++i) {
            uniqueKeyBuilder.append("`" + uniqueKeyProperties.getString(i) + "`,");
        }
        uniqueKeyBuilder.deleteCharAt(uniqueKeyBuilder.length() - 1);
        uniqueKeyBuilder.append(");");
        String uniqueKeySQL = uniqueKeyBuilder.toString().replaceAll("\\s+", " ");
        this.logger.debug("[\u6dfb\u52a0\u552f\u4e00\u6027\u7ea6\u675f]\u8868:{},\u6267\u884cSQL:{}", (Object)tableName, (Object)uniqueKeySQL);
        connection.prepareStatement(uniqueKeySQL).executeUpdate();
    }

    protected void createForeignKey(JSONArray entityList, Connection connection) throws SQLException {
        for (int i = 0; i < entityList.size(); ++i) {
            JSONObject source = entityList.getJSONObject(i);
            JSONArray foreignKeyProperties = source.getJSONArray("foreignKeyProperties");
            for (int j = 0; j < foreignKeyProperties.size(); ++j) {
                JSONObject property = foreignKeyProperties.getJSONObject(j);
                String foreignKeyName = property.getString("foreignKeyName");
                ResultSet resultSet = connection.prepareStatement("SELECT count(1) FROM information_schema.KEY_COLUMN_USAGE WHERE CONSTRAINT_NAME='" + foreignKeyName + "'").executeQuery();
                if (resultSet.next() && resultSet.getInt(1) == 0) {
                    String foreignKeySQL = "alter table `" + source.getString("tableName") + "` add constraint `" + foreignKeyName + "` foreign key(`" + property.getString("column") + "`) references " + property.getString("foreignKey");
                    this.logger.info("[\u751f\u6210\u5916\u952e\u7ea6\u675f=>{}]\u6267\u884cSQL:{}", (Object)foreignKeyName, (Object)foreignKeySQL);
                    connection.prepareStatement(foreignKeySQL).executeUpdate();
                }
                resultSet.close();
            }
        }
    }

    private JSONObject getValue(JSONArray array, String propertyName, String value) {
        for (int i = 0; i < array.size(); ++i) {
            if (!array.getJSONObject(i).getString(propertyName).equals(value)) continue;
            return array.getJSONObject(i);
        }
        return null;
    }

    protected static enum Syntax {
        AutoIncrement,
        InsertIgnore,
        Comment;

    }
}

