/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.condition;

import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.condition.Condition;
import cn.schoolwow.quickdao.condition.SubCondition;
import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.util.ReflectionUtil;
import cn.schoolwow.quickdao.util.SQLUtil;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickdao.util.ValidateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCondition<T>
implements Condition<T>,
Serializable {
    Logger logger = LoggerFactory.getLogger(AbstractCondition.class);
    protected String distinct = "";
    protected StringBuilder columnBuilder = new StringBuilder();
    protected StringBuilder aggerateColumnBuilder = new StringBuilder();
    protected StringBuilder setBuilder = new StringBuilder();
    protected StringBuilder whereBuilder = new StringBuilder();
    protected StringBuilder groupByBuilder = new StringBuilder("group by ");
    protected StringBuilder havingBuilder = new StringBuilder("having ");
    protected StringBuilder orderByBuilder = new StringBuilder();
    protected String limit = "";
    protected List parameterList = new ArrayList();
    protected int parameterIndex = 1;
    protected List updateParameterList;
    protected Class<T> _class;
    protected transient DataSource dataSource;
    protected transient AbstractDAO abstractDAO;
    protected StringBuilder sqlBuilder = new StringBuilder();
    protected String sql;
    private int joinTableIndex = 1;
    private List<AbstractSubCondition> subConditionList = new ArrayList<AbstractSubCondition>();
    protected String tableName = null;
    protected boolean hasDone = false;
    protected PageVo<T> pageVo = null;
    private static String[] patterns = new String[]{"%", "_", "[", "[^", "[!", "]"};

    public AbstractCondition(Class<T> _class, DataSource dataSource, AbstractDAO abstractDAO) {
        this._class = _class;
        this.tableName = "`" + SQLUtil.classTableMap.get(_class.getName()) + "`";
        this.dataSource = dataSource;
        this.abstractDAO = abstractDAO;
    }

    @Override
    public Condition distinct() {
        this.distinct = "distinct";
        return this;
    }

    @Override
    public Condition addNullQuery(String field) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` is null) and ");
        return this;
    }

    @Override
    public Condition addNotNullQuery(String field) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` is not null) and ");
        return this;
    }

    @Override
    public Condition addNotEmptyQuery(String field) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` is not null and t.`" + StringUtil.Camel2Underline(field) + "` != '') and ");
        return this;
    }

    @Override
    public Condition addInQuery(String field, Object[] values) {
        if (values == null || values.length == 0) {
            return this;
        }
        this.addINQuery("t", field, values, "in");
        return this;
    }

    @Override
    public Condition addInQuery(String field, List values) {
        return this.addInQuery(field, values.toArray(new Object[values.size()]));
    }

    @Override
    public Condition addNotInQuery(String field, Object[] values) {
        if (values == null || values.length == 0) {
            return this;
        }
        this.addINQuery("t", field, values, "not in");
        return this;
    }

    @Override
    public Condition addNotInQuery(String field, List values) {
        return this.addNotInQuery(field, values.toArray(new Object[values.size()]));
    }

    @Override
    public Condition addBetweenQuery(String field, Object start, Object end) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` between ? and ? ) and ");
        this.parameterList.add(start);
        this.parameterList.add(end);
        return this;
    }

    @Override
    public Condition addQuery(String query) {
        this.whereBuilder.append("(" + query + ") and ");
        return this;
    }

    @Override
    public Condition addQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        if (value instanceof String) {
            this.addQuery(field, "like", value);
        } else {
            this.addQuery(field, "=", value);
        }
        return this;
    }

    @Override
    public Condition addQuery(String field, String operator, Object value) {
        if (value instanceof String) {
            this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` " + operator + " ?) and ");
            boolean hasContains = false;
            for (String pattern : patterns) {
                if (!((String)value).contains(pattern)) continue;
                this.parameterList.add(value);
                hasContains = true;
                break;
            }
            if (!hasContains) {
                this.parameterList.add("%" + value + "%");
            }
        } else {
            this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` " + operator + " ?) and ");
            this.parameterList.add(value);
        }
        return this;
    }

    @Override
    public Condition addJSONObjectQuery(JSONObject queryCondition) {
        String[] orders;
        Field[] fields;
        for (Field field : fields = ReflectionUtil.getFields(this._class)) {
            if (queryCondition.containsKey((Object)field.getName())) {
                this.addQuery(field.getName(), queryCondition.get((Object)field.getName()));
            }
            if (queryCondition.containsKey((Object)(field.getName() + "Start"))) {
                this.addQuery(field.getName(), ">=", queryCondition.get((Object)(field.getName() + "Start")));
            }
            if (queryCondition.containsKey((Object)(field.getName() + "End"))) {
                this.addQuery(field.getName(), "<=", queryCondition.get((Object)(field.getName() + "End")));
            }
            if (queryCondition.containsKey((Object)(field.getName() + "IN"))) {
                this.addInQuery(field.getName(), (List)queryCondition.getJSONArray(field.getName() + "IN"));
            }
            if (queryCondition.containsKey((Object)(field.getName() + "NOTNULL"))) {
                this.addNotNullQuery(field.getName());
            }
            if (queryCondition.containsKey((Object)(field.getName() + "NULL"))) {
                this.addNullQuery(field.getName());
            }
            if (!queryCondition.containsKey((Object)(field.getName() + "NOTEMPTY"))) continue;
            this.addNotEmptyQuery(field.getName());
        }
        for (String order : orders = new String[]{"_orderBy", "_orderByDesc"}) {
            if (!queryCondition.containsKey((Object)order)) continue;
            if (queryCondition.get((Object)order) instanceof String) {
                if ("_orderBy".equals(order)) {
                    this.orderBy(queryCondition.getString(order));
                    continue;
                }
                this.orderByDesc(queryCondition.getString(order));
                continue;
            }
            if (!(queryCondition.get((Object)order) instanceof String)) continue;
            JSONArray array = queryCondition.getJSONArray(order);
            for (int i = 0; i < array.size(); ++i) {
                if ("_orderBy".equals(order)) {
                    this.orderBy(queryCondition.getString(order));
                    continue;
                }
                this.orderByDesc(queryCondition.getString(order));
            }
        }
        if (queryCondition.containsKey((Object)"_pageNumber") && queryCondition.containsKey((Object)"_pageSize")) {
            this.page(queryCondition.getInteger("_pageNumber"), queryCondition.getInteger("_pageSize"));
        }
        return this;
    }

    @Override
    public Condition addUpdate(String field, Object value) {
        if (this.updateParameterList == null) {
            this.updateParameterList = new ArrayList();
        }
        this.setBuilder.append("t.`" + StringUtil.Camel2Underline(field) + "`=?,");
        this.updateParameterList.add(value);
        return this;
    }

    @Override
    public Condition addAggerate(String aggerate, String field) {
        field = StringUtil.Camel2Underline(field);
        this.aggerateColumnBuilder.append(aggerate + "(t.`" + field + "`) as `" + aggerate + "(" + field + ")`,");
        return this;
    }

    @Override
    public Condition addAggerate(String aggerate, String field, String alias) {
        field = StringUtil.Camel2Underline(field);
        this.aggerateColumnBuilder.append(aggerate + "(t.`" + field + "`) as `" + alias + "`,");
        return this;
    }

    @Override
    public Condition groupBy(String field) {
        this.groupByBuilder.append("t.`" + StringUtil.Camel2Underline(field) + "`,");
        return this;
    }

    @Override
    public <T> SubCondition<T> joinTable(Class<T> _class, String primaryField, String joinTableField) {
        String tableNameAlias = "t" + this.joinTableIndex++;
        String fieldName = this.getFirstClassFieldInMainClass(this._class, _class);
        AbstractSubCondition<T> subCondition = new AbstractSubCondition<T>(_class, tableNameAlias, primaryField, joinTableField, fieldName, this);
        this.subConditionList.add(subCondition);
        return subCondition;
    }

    @Override
    public <T> SubCondition<T> joinTable(Class<T> _class, String primaryField, String joinTableField, String compositField) {
        String tableNameAlias = "t" + this.joinTableIndex++;
        AbstractSubCondition<T> subCondition = new AbstractSubCondition<T>(_class, tableNameAlias, primaryField, joinTableField, compositField, this);
        this.subConditionList.add(subCondition);
        return subCondition;
    }

    @Override
    public Condition orderBy(String field) {
        this.orderByBuilder.append("t.`" + StringUtil.Camel2Underline(field) + "` asc,");
        return this;
    }

    @Override
    public Condition orderByDesc(String field) {
        this.orderByBuilder.append("t.`" + StringUtil.Camel2Underline(field) + "` desc,");
        return this;
    }

    @Override
    public Condition limit(long offset, long limit) {
        this.limit = "limit " + offset + "," + limit;
        return this;
    }

    @Override
    public Condition page(int pageNum, int pageSize) {
        this.limit = "limit " + (pageNum - 1) * pageSize + "," + pageSize;
        this.pageVo = new PageVo();
        this.pageVo.setPageSize(pageSize);
        this.pageVo.setCurrentPage(pageNum);
        return this;
    }

    @Override
    public Condition addColumn(String field) {
        field = StringUtil.Camel2Underline(field);
        this.columnBuilder.append("t.`" + field + "` as `t_" + field + "`,");
        return this;
    }

    protected Condition done() {
        if (this.columnBuilder.length() > 0) {
            this.columnBuilder.deleteCharAt(this.columnBuilder.length() - 1);
        }
        if (this.aggerateColumnBuilder.length() > 0) {
            this.aggerateColumnBuilder.deleteCharAt(this.aggerateColumnBuilder.length() - 1);
        }
        if (this.setBuilder.length() > 0) {
            this.setBuilder.deleteCharAt(this.setBuilder.length() - 1);
            this.setBuilder.insert(0, "set ");
        }
        if (this.whereBuilder.length() > 0) {
            this.whereBuilder.delete(this.whereBuilder.length() - 5, this.whereBuilder.length());
            this.whereBuilder.insert(0, "where ");
        }
        if ("group by ".equals(this.groupByBuilder.toString())) {
            this.groupByBuilder.setLength(0);
        } else {
            this.groupByBuilder.deleteCharAt(this.groupByBuilder.length() - 1);
        }
        if ("having ".equals(this.havingBuilder.toString())) {
            this.havingBuilder.setLength(0);
        } else {
            this.havingBuilder.delete(this.havingBuilder.length() - 5, this.havingBuilder.length());
        }
        if (this.orderByBuilder.length() > 0) {
            this.orderByBuilder.deleteCharAt(this.orderByBuilder.length() - 1);
            this.orderByBuilder.insert(0, "order by ");
        }
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            if (abstractSubCondition.whereBuilder.length() <= 0) continue;
            abstractSubCondition.whereBuilder.delete(abstractSubCondition.whereBuilder.length() - 5, abstractSubCondition.whereBuilder.length());
        }
        this.hasDone = true;
        return this;
    }

    @Override
    public long count() {
        this.assureDone();
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("select count(1) from " + this.tableName + " as t ");
        this.addJoinTableStatement();
        this.addWhereStatement();
        String sqlBack = this.sql;
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long count = -1L;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.sql);){
            this.addMainTableParameters(ps);
            this.addJoinTableParameters(ps);
            this.logger.debug("[Count]\u6267\u884cSQL:{}", (Object)this.sql);
            ResultSet resultSet = ps.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (ValidateUtil.isNotEmpty(sqlBack)) {
            this.sql = sqlBack;
        }
        return count;
    }

    @Override
    public long update() {
        this.assureDone();
        if (this.setBuilder.length() == 0) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528addUpdate()\u51fd\u6570!");
        }
        if (this.updateParameterList == null || this.updateParameterList.size() == 0) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528addUpdate()\u51fd\u6570!");
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("update " + this.tableName + " as t ");
        this.addJoinTableStatement();
        this.sqlBuilder.append(this.setBuilder.toString());
        this.addWhereStatement();
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long effect = -1L;
        try {
            Connection connection = this.abstractDAO.getConnection();
            PreparedStatement ps = connection.prepareStatement(this.sql);
            for (Object parameter : this.updateParameterList) {
                ps.setObject(this.parameterIndex++, parameter);
                this.replaceParameter(parameter);
            }
            this.addMainTableParameters(ps);
            this.addJoinTableParameters(ps);
            this.logger.debug("[Update]\u6267\u884cSQL:{}", (Object)this.sql);
            effect = ps.executeUpdate();
            ps.close();
            if (!this.abstractDAO.startTranscation) {
                connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effect;
    }

    @Override
    public long delete() {
        this.assureDone();
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("delete t from " + this.tableName + " as t ");
        this.addJoinTableStatement();
        this.addWhereStatement();
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long effect = -1L;
        try {
            Connection connection = this.abstractDAO.getConnection();
            PreparedStatement ps = connection.prepareStatement(this.sql);
            this.addMainTableParameters(ps);
            this.addJoinTableParameters(ps);
            this.logger.debug("[Delete]\u6267\u884cSQL:{}", (Object)this.sql);
            effect = ps.executeUpdate();
            ps.close();
            if (!this.abstractDAO.startTranscation) {
                connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effect;
    }

    @Override
    public T getOne() {
        List<T> list = this.getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<T> getList() {
        return this.getArray().toJavaList(this._class);
    }

    /*
     * Exception decompiling
     */
    @Override
    public JSONArray getArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <E> List<E> getValueList(Class<E> _class, String column) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public JSONArray getAggerateList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<T> getPartList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PageVo<T> getPagingList() {
        this.getPageVo();
        this.pageVo.setList(this.getList());
        return this.pageVo;
    }

    @Override
    public PageVo<T> getPartPagingList() {
        this.getPageVo();
        this.pageVo.setList(this.getPartList());
        return this.pageVo;
    }

    @Override
    public PageVo<T> getCompositPagingList() {
        this.getPageVo();
        this.pageVo.setList(this.getCompositList());
        return this.pageVo;
    }

    @Override
    public List<T> getCompositList() {
        JSONArray array = this.getCompositArray();
        return array.toJavaList(this._class);
    }

    /*
     * Exception decompiling
     */
    @Override
    public JSONArray getCompositArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public AbstractCondition clone() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            AbstractCondition abstractCondition = (AbstractCondition)ois.readObject();
            abstractCondition.dataSource = this.dataSource;
            abstractCondition.abstractDAO = this.abstractDAO;
            return abstractCondition;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toString() {
        return "[Condition]\u7c7b[" + this._class.getName() + "],where\u5b50\u53e5:[" + this.whereBuilder.toString() + "],\u53c2\u6570\u5217\u8868:[" + this.parameterList + "],\u6392\u5e8f:[" + this.orderByBuilder.toString() + "],\u5206\u9875:[" + this.limit + "]";
    }

    private PageVo<T> getPageVo() {
        if (this.pageVo == null) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528page()\u51fd\u6570!");
        }
        this.pageVo.setTotalSize(this.count());
        this.pageVo.setTotalPage((int)(this.pageVo.getTotalSize() / (long)this.pageVo.getPageSize()) + 1);
        this.pageVo.setHasMore(this.pageVo.getCurrentPage() < this.pageVo.getTotalPage());
        return this.pageVo;
    }

    protected void addMainTableParameters(PreparedStatement ps) throws SQLException {
        for (Object parameter : this.parameterList) {
            ps.setObject(this.parameterIndex, parameter);
            this.replaceParameter(parameter);
            ++this.parameterIndex;
        }
    }

    protected void addJoinTableStatement() {
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            AbstractSubCondition parentSubCondition = (AbstractSubCondition)abstractSubCondition.parentSubCondition;
            if (parentSubCondition == null) {
                this.sqlBuilder.append(abstractSubCondition.join + " `" + SQLUtil.classTableMap.get(abstractSubCondition._class.getName()) + "` as " + abstractSubCondition.tableAliasName + " on t." + StringUtil.Camel2Underline(abstractSubCondition.primaryField) + " = " + StringUtil.Camel2Underline(abstractSubCondition.tableAliasName) + "." + StringUtil.Camel2Underline(abstractSubCondition.joinTableField) + " ");
                continue;
            }
            this.sqlBuilder.append(abstractSubCondition.join + " `" + SQLUtil.classTableMap.get(abstractSubCondition._class.getName()) + "` as " + abstractSubCondition.tableAliasName + " on " + abstractSubCondition.tableAliasName + "." + StringUtil.Camel2Underline(abstractSubCondition.joinTableField) + " = " + StringUtil.Camel2Underline(parentSubCondition.tableAliasName) + "." + StringUtil.Camel2Underline(abstractSubCondition.primaryField) + " ");
        }
    }

    protected void addWhereStatement() {
        this.sqlBuilder.append(" " + this.whereBuilder.toString());
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            if (abstractSubCondition.whereBuilder.length() <= 0) continue;
            this.sqlBuilder.append(" and " + abstractSubCondition.whereBuilder.toString() + " ");
        }
    }

    protected void addJoinTableParameters(PreparedStatement ps) throws SQLException {
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            for (Object parameter : abstractSubCondition.parameterList) {
                ps.setObject(this.parameterIndex, parameter);
                this.replaceParameter(parameter);
                ++this.parameterIndex;
            }
        }
    }

    protected void replaceParameter(Object parameter) {
        String type;
        switch (type = parameter.getClass().getSimpleName().toLowerCase()) {
            case "int": 
            case "integer": 
            case "long": 
            case "boolean": {
                this.sql = this.sql.replaceFirst("\\?", parameter.toString());
                break;
            }
            case "string": {
                this.sql = this.sql.replaceFirst("\\?", "'" + parameter.toString() + "'");
                break;
            }
            default: {
                this.sql = this.sql.replaceFirst("\\?", parameter.toString());
            }
        }
    }

    protected void assureDone() {
        if (!this.hasDone) {
            this.done();
        }
        this.parameterIndex = 1;
    }

    private String getFirstClassFieldInMainClass(Class mainClass, Class _class) {
        Field[] fields = ReflectionUtil.getCompositField(mainClass, _class);
        if (fields == null || fields.length == 0) {
            return null;
        }
        if (fields.length == 1) {
            return fields[0].getName();
        }
        throw new IllegalArgumentException("\u7c7b[" + mainClass.getName() + "]\u5b58\u5728[" + fields.length + "]\u4e2a\u7c7b\u578b\u4e3a[" + _class.getName() + "]\u7684\u6210\u5458\u53d8\u91cf!");
    }

    private JSONObject getSubObject(Class _class, String tableAliasName, ResultSet resultSet) throws SQLException {
        Field[] subFields;
        JSONObject subObject = new JSONObject();
        for (Field field : subFields = ReflectionUtil.getFields(_class)) {
            if (field.getAnnotation(Ignore.class) != null) continue;
            this.setValue(tableAliasName, field, subObject, resultSet);
        }
        return subObject;
    }

    private void setValue(String tableAlias, Field field, JSONObject o, ResultSet resultSet) throws SQLException {
        String type;
        String columnName = tableAlias + "_" + StringUtil.Camel2Underline(field.getName());
        switch (type = field.getType().getSimpleName().toLowerCase()) {
            case "int": 
            case "integer": {
                o.put(field.getName(), (Object)resultSet.getInt(columnName));
                break;
            }
            case "long": {
                o.put(field.getName(), (Object)resultSet.getLong(columnName));
                break;
            }
            case "boolean": {
                o.put(field.getName(), (Object)resultSet.getBoolean(columnName));
                break;
            }
            default: {
                o.put(field.getName(), resultSet.getObject(columnName));
            }
        }
    }

    private void addINQuery(String tableAliasName, String field, Object[] values, String in) {
        int i;
        if (values[0] instanceof String) {
            for (i = 0; i < values.length; ++i) {
                values[i] = values[i].toString();
            }
        }
        this.parameterList.addAll(Arrays.asList(values));
        this.whereBuilder.append("(" + tableAliasName + "." + StringUtil.Camel2Underline(field) + " " + in + " (");
        for (i = 0; i < values.length; ++i) {
            this.whereBuilder.append("?,");
        }
        this.whereBuilder.deleteCharAt(this.whereBuilder.length() - 1);
        this.whereBuilder.append(") ) and ");
    }

    class SqliteSubCondition<T>
    extends AbstractSubCondition<T> {
        public SqliteSubCondition(Class<T> _class, String tableAliasName, String primaryField, String joinTableField, String compositField, Condition condition) {
            super(_class, tableAliasName, primaryField, joinTableField, compositField, condition);
        }

        @Override
        public SubCondition rightJoin() {
            throw new UnsupportedOperationException("RIGHT and FULL OUTER JOINs are not currently supported");
        }
    }

    class AbstractSubCondition<T>
    implements SubCondition<T>,
    Serializable {
        protected Class<T> _class;
        protected String tableAliasName;
        protected String primaryField;
        protected String joinTableField;
        protected String compositField;
        protected StringBuilder whereBuilder = new StringBuilder();
        protected List parameterList = new ArrayList();
        protected transient Condition condition;
        protected String join = "join";
        protected SubCondition parentSubCondition;

        public AbstractSubCondition(Class<T> _class, String tableAliasName, String primaryField, String joinTableField, String compositField, Condition condition) {
            this._class = _class;
            this.tableAliasName = tableAliasName;
            this.primaryField = primaryField;
            this.joinTableField = joinTableField;
            this.compositField = compositField;
            this.condition = condition;
        }

        @Override
        public SubCondition leftJoin() {
            this.join = "left outer join";
            return this;
        }

        @Override
        public SubCondition rightJoin() {
            this.join = "right outer join";
            return this;
        }

        @Override
        public <T> SubCondition<T> joinTable(Class<T> _class, String primaryField, String joinTableField) {
            String fieldName = AbstractCondition.this.getFirstClassFieldInMainClass(this._class, _class);
            AbstractSubCondition abstractSubCondition = (AbstractSubCondition)this.condition.joinTable(_class, primaryField, joinTableField, fieldName);
            abstractSubCondition.parentSubCondition = this;
            return abstractSubCondition;
        }

        @Override
        public <T> SubCondition<T> joinTable(Class<T> _class, String primaryField, String joinTableField, String compositField) {
            AbstractSubCondition abstractSubCondition = (AbstractSubCondition)this.condition.joinTable(_class, primaryField, joinTableField, compositField);
            abstractSubCondition.parentSubCondition = this;
            return abstractSubCondition;
        }

        @Override
        public SubCondition addNullQuery(String field) {
            this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` is null) and ");
            return this;
        }

        @Override
        public SubCondition addNotNullQuery(String field) {
            this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` is not null) and ");
            return this;
        }

        @Override
        public SubCondition addNotEmptyQuery(String field) {
            this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` is not null and " + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` != '') and ");
            return this;
        }

        @Override
        public SubCondition addInQuery(String field, Object[] values) {
            if (values == null || values.length == 0) {
                return this;
            }
            AbstractCondition.this.addINQuery(this.tableAliasName, field, values, "in");
            return this;
        }

        @Override
        public SubCondition addInQuery(String field, List values) {
            return this.addInQuery(field, values.toArray(new Object[values.size()]));
        }

        @Override
        public SubCondition addNotInQuery(String field, Object[] values) {
            if (values == null || values.length == 0) {
                return this;
            }
            AbstractCondition.this.addINQuery(this.tableAliasName, field, values, "not in");
            return this;
        }

        @Override
        public SubCondition addNotInQuery(String field, List values) {
            return this.addNotInQuery(field, values.toArray(new Object[values.size()]));
        }

        @Override
        public SubCondition addQuery(String query) {
            this.whereBuilder.append("(" + query + ") and ");
            return this;
        }

        @Override
        public SubCondition addQuery(String property, Object value) {
            if (value == null || value.toString().equals("")) {
                return this;
            }
            if (value instanceof String) {
                this.addQuery(property, "like", value);
            } else {
                this.addQuery(property, "=", value);
            }
            return this;
        }

        @Override
        public SubCondition addQuery(String property, String operator, Object value) {
            if (value instanceof String) {
                this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(property) + "` " + operator + " ?) and ");
                boolean hasContains = false;
                for (String pattern : patterns) {
                    if (!((String)value).contains(pattern)) continue;
                    this.parameterList.add(value);
                    hasContains = true;
                    break;
                }
                if (!hasContains) {
                    this.parameterList.add("%" + value + "%");
                }
            } else {
                this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(property) + "` " + operator + " ?) and ");
                this.parameterList.add(value);
            }
            return this;
        }

        @Override
        public SubCondition orderBy(String field) {
            AbstractCondition.this.orderByBuilder.append(this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` asc,");
            return this;
        }

        @Override
        public SubCondition orderByDesc(String field) {
            AbstractCondition.this.orderByBuilder.append(this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` desc,");
            return this;
        }

        @Override
        public SubCondition doneSubCondition() {
            return this;
        }

        @Override
        public Condition done() {
            return this.condition;
        }

        public SubCondition clone() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this);
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bis);
                AbstractSubCondition subCondition = (AbstractSubCondition)ois.readObject();
                subCondition.condition = this.condition;
                return subCondition;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

