/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.H2DAO;
import cn.schoolwow.quickdao.dao.MySQLDAO;
import cn.schoolwow.quickdao.dao.SQLiteDAO;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.util.ValidateUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAO {
    Logger logger = LoggerFactory.getLogger(QuickDAO.class);
    private static HashMap<String, Class> driverMapping = new HashMap();

    public static QuickDAO newInstance() {
        return new QuickDAO();
    }

    public QuickDAO dataSource(DataSource dataSource) {
        QuickDAOConfig.dataSource = dataSource;
        return this;
    }

    public QuickDAO packageName(String packageName) {
        QuickDAOConfig.packageNameMap.put(packageName, "");
        return this;
    }

    public QuickDAO packageName(String packageName, String prefix) {
        QuickDAOConfig.packageNameMap.put(packageName, prefix + "_");
        return this;
    }

    public QuickDAO ignorePackageName(String ignorePackageName) {
        if (QuickDAOConfig.ignorePackageNameList == null) {
            QuickDAOConfig.ignorePackageNameList = new ArrayList<String>();
        }
        QuickDAOConfig.ignorePackageNameList.add(ignorePackageName);
        return this;
    }

    public QuickDAO ignoreClass(Class _class) {
        if (QuickDAOConfig.ignoreClassList == null) {
            QuickDAOConfig.ignoreClassList = new ArrayList<Class>();
        }
        QuickDAOConfig.ignoreClassList.add(_class);
        return this;
    }

    public QuickDAO filter(Predicate<Class> predicate) {
        QuickDAOConfig.predicate = predicate;
        return this;
    }

    public QuickDAO foreignKey(boolean openForeignKey) {
        QuickDAOConfig.openForeignKey = openForeignKey;
        return this;
    }

    public QuickDAO autoCreateTable(boolean autoCreateTable) {
        QuickDAOConfig.autoCreateTable = autoCreateTable;
        return this;
    }

    public DAO build() {
        if (QuickDAOConfig.packageNameMap.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6e\u8981\u626b\u63cf\u7684\u5b9e\u4f53\u7c7b\u5305\u540d!");
        }
        if (ValidateUtil.isNull(QuickDAOConfig.dataSource)) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u6c60\u5c5e\u6027!");
        }
        AbstractDAO dao = null;
        try {
            Connection connection = QuickDAOConfig.dataSource.getConnection();
            String url = connection.getMetaData().getURL();
            this.logger.info("[\u6570\u636e\u6e90\u5730\u5740]{}", (Object)url);
            Set<String> keySet = driverMapping.keySet();
            for (String key : keySet) {
                if (!url.contains(key)) continue;
                dao = (AbstractDAO)driverMapping.get(key).getConstructor(DataSource.class).newInstance(QuickDAOConfig.dataSource);
                break;
            }
            if (dao == null) {
                throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u6e90\u6ca1\u6709\u5408\u9002\u7684\u9002\u914d\u5668.\u6570\u636e\u6e90\u5730\u5740:" + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dao.autoBuildDatabase();
        return dao;
    }

    static {
        driverMapping.put("jdbc:h2", H2DAO.class);
        driverMapping.put("jdbc:sqlite", SQLiteDAO.class);
        driverMapping.put("jdbc:mysql", MySQLDAO.class);
    }
}

