/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.util;

import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.Unique;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ReflectionUtil {
    private static JSONObject sqlCache = new JSONObject();

    public static Field getId(Class _class) throws NoSuchFieldException {
        Field id = _class.getDeclaredField("id");
        id.setAccessible(true);
        return id;
    }

    public static void setId(Object instance, long value) throws NoSuchFieldException, IllegalAccessException {
        Field id = ReflectionUtil.getId(instance.getClass());
        id.setLong(instance, value);
    }

    public static Field[] getFields(Class _class) {
        AccessibleObject[] fields = _class.getDeclaredFields();
        Field.setAccessible(fields, true);
        return fields;
    }

    public static boolean hasUniqueKey(Class _class) {
        String key = "hasUniqueKey_" + _class.getName();
        if (!sqlCache.containsKey((Object)key)) {
            List<Field> fieldList = Arrays.asList(ReflectionUtil.getFields(_class));
            sqlCache.put(key, (Object)fieldList.stream().anyMatch(field -> field.getAnnotation(Unique.class) != null));
        }
        return sqlCache.getBoolean(key);
    }

    public static boolean hasId(Object instance) throws NoSuchFieldException, IllegalAccessException {
        Class<?> _class = instance.getClass();
        Field id = _class.getDeclaredField("id");
        id.setAccessible(true);
        switch (id.getType().getSimpleName().toLowerCase()) {
            case "int": {
                return id.getInt(instance) > 0;
            }
            case "integer": {
                return id.get(instance) != null && id.getInt(instance) > 0;
            }
            case "long": {
                return (id.getType().isPrimitive() || id.get(instance) != null) && id.getLong(instance) > 0L;
            }
            case "string": {
                return id.get(instance) != null;
            }
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u4e3b\u952e\u7c7b\u578b:" + id.getType().getSimpleName().toLowerCase());
    }

    public static String setValueWithInsertIgnore(PreparedStatement ps, Object instance, String sql) throws SQLException, IllegalAccessException {
        int parameterIndex = 1;
        Field[] fields = ReflectionUtil.getFields(instance.getClass());
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("id") || fields[i].getAnnotation(Ignore.class) != null) continue;
            sql = sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        return sql;
    }

    public static String setValueWithUpdateById(PreparedStatement ps, Object instance, String sql) throws SQLException, IllegalAccessException, NoSuchFieldException {
        int parameterIndex = 1;
        Field[] fields = ReflectionUtil.getFields(instance.getClass());
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("id") || fields[i].getAnnotation(Ignore.class) != null) continue;
            sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, ReflectionUtil.getId(instance.getClass())));
        return sql;
    }

    public static String setValueWithUpdateByUniqueKey(PreparedStatement ps, Object instance, String sql) throws SQLException, IllegalAccessException {
        int i;
        int parameterIndex = 1;
        Field[] fields = ReflectionUtil.getFields(instance.getClass());
        for (i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("id") || fields[i].getAnnotation(Ignore.class) != null || fields[i].getAnnotation(Unique.class) != null) continue;
            sql = sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        for (i = 0; i < fields.length; ++i) {
            if (fields[i].getAnnotation(Unique.class) == null) continue;
            sql = sql.replaceFirst("\\?", ReflectionUtil.setParameter(instance, ps, parameterIndex, fields[i]));
            ++parameterIndex;
        }
        return sql;
    }

    public static <T> void mappingResultToList(ResultSet resultSet, List<T> instanceList, Class<T> _class, String column) throws SQLException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        while (resultSet.next()) {
            T instance = _class.getConstructor(String.class).newInstance(resultSet.getString(column));
            instanceList.add(instance);
        }
        resultSet.close();
    }

    public static <T> List<T> mappingResultToList(ResultSet resultSet, List<T> instanceList, Class<T> _class) throws SQLException, IllegalAccessException, InstantiationException {
        while (resultSet.next()) {
            Field[] fields;
            T instance = _class.newInstance();
            block15: for (Field field : fields = ReflectionUtil.getFields(_class)) {
                String type;
                if (field.getAnnotation(Ignore.class) != null) continue;
                String columnName = "t_" + StringUtil.Camel2Underline(field.getName());
                switch (type = field.getType().getSimpleName().toLowerCase()) {
                    case "int": {
                        field.setInt(instance, resultSet.getInt(columnName));
                        continue block15;
                    }
                    case "integer": {
                        field.setInt(instance, resultSet.getInt(columnName));
                        continue block15;
                    }
                    case "long": {
                        if (field.getType().isPrimitive()) {
                            field.setLong(instance, resultSet.getLong(columnName));
                            continue block15;
                        }
                        field.setLong(instance, resultSet.getLong(columnName));
                        continue block15;
                    }
                    case "boolean": {
                        if (field.getType().isPrimitive()) {
                            field.setBoolean(instance, resultSet.getBoolean(columnName));
                            continue block15;
                        }
                        field.setBoolean(instance, resultSet.getBoolean(columnName));
                        continue block15;
                    }
                    case "date": {
                        Object o = resultSet.getObject(columnName);
                        if (o instanceof Long) {
                            Date date = new Date((Long)o);
                            field.set(instance, date);
                            continue block15;
                        }
                        if (!(o instanceof Date)) continue block15;
                        field.set(instance, o);
                        continue block15;
                    }
                    default: {
                        field.set(instance, resultSet.getObject(columnName));
                    }
                }
            }
            instanceList.add(instance);
        }
        resultSet.close();
        return instanceList;
    }

    private static String setParameter(Object instance, PreparedStatement ps, int parameterIndex, Field field) throws SQLException, IllegalAccessException {
        switch (field.getType().getSimpleName().toLowerCase()) {
            case "int": {
                ps.setInt(parameterIndex, field.getInt(instance));
                return "" + field.getInt(instance);
            }
            case "integer": {
                ps.setObject(parameterIndex, field.get(instance));
                return "" + field.get(instance);
            }
            case "long": {
                if (field.getType().isPrimitive()) {
                    ps.setLong(parameterIndex, field.getLong(instance));
                    return "" + field.getLong(instance);
                }
                ps.setObject(parameterIndex, field.get(instance));
                return "" + field.get(instance);
            }
            case "boolean": {
                if (field.getType().isPrimitive()) {
                    ps.setBoolean(parameterIndex, field.getBoolean(instance));
                    return "" + field.getBoolean(instance);
                }
                ps.setObject(parameterIndex, field.get(instance));
                return "" + field.get(instance);
            }
            case "string": {
                ps.setString(parameterIndex, field.get(instance) == null ? null : field.get(instance).toString());
                return "'" + (field.get(instance) == null ? "" : field.get(instance).toString()) + "'";
            }
        }
        ps.setObject(parameterIndex, field.get(instance));
        return "'" + field.get(instance) + "'";
    }
}

