/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.AbstractDAO;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class SQLiteDAO
extends AbstractDAO {
    public SQLiteDAO(DataSource dataSource) {
        super(dataSource);
        this.fieldMapping.put("long", "INTEGER");
    }

    @Override
    protected String getSyntax(AbstractDAO.Syntax syntax) {
        switch (syntax) {
            case AutoIncrement: {
                return "autoincrement";
            }
            case InsertIgnore: {
                return "insert or ignore into ";
            }
        }
        return null;
    }

    @Override
    protected String getUniqueStatement(String tableName, List<String> columns) {
        StringBuilder uniqueSQLBuilder = new StringBuilder("create index " + tableName + "_");
        columns.stream().forEach(column -> uniqueSQLBuilder.append(column + "_"));
        uniqueSQLBuilder.deleteCharAt(uniqueSQLBuilder.length() - 1);
        uniqueSQLBuilder.append(" on " + tableName + "(");
        columns.stream().forEach(column -> uniqueSQLBuilder.append("`" + column + "`,"));
        uniqueSQLBuilder.deleteCharAt(uniqueSQLBuilder.length() - 1);
        uniqueSQLBuilder.append(");");
        return uniqueSQLBuilder.toString();
    }

    @Override
    public JSONArray getDatabaseInfo(Connection connection) throws SQLException {
        PreparedStatement tablePs = connection.prepareStatement("select name from sqlite_master where type='table';");
        ResultSet tableRs = tablePs.executeQuery();
        JSONArray entityList = new JSONArray();
        while (tableRs.next()) {
            JSONObject entity = new JSONObject();
            entity.put("tableName", (Object)tableRs.getString(1));
            JSONArray properties = new JSONArray();
            PreparedStatement propertyPs = connection.prepareStatement("PRAGMA table_info(" + tableRs.getString(1) + ")");
            ResultSet propertiesRs = propertyPs.executeQuery();
            while (propertiesRs.next()) {
                JSONObject property = new JSONObject();
                property.put("column", (Object)propertiesRs.getString("name"));
                property.put("columnType", (Object)propertiesRs.getString("type"));
                property.put("notNull", (Object)"1".equals(propertiesRs.getString("notnull")));
                if (null != propertiesRs.getString("dflt_value")) {
                    property.put("default", (Object)propertiesRs.getString("dflt_value"));
                }
                properties.add((Object)property);
            }
            entity.put("properties", (Object)properties);
            entityList.add((Object)entity);
            propertiesRs.close();
            propertyPs.close();
        }
        tableRs.close();
        tablePs.close();
        connection.close();
        return entityList;
    }
}

