/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.DefaultValue;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.NotNull;
import cn.schoolwow.quickdao.annotation.Unique;
import cn.schoolwow.quickdao.condition.AbstractCondition;
import cn.schoolwow.quickdao.condition.Condition;
import cn.schoolwow.quickdao.condition.SqliteCondition;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.SQLiteDAO;
import cn.schoolwow.quickdao.util.ReflectionUtil;
import cn.schoolwow.quickdao.util.SQLUtil;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickdao.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDAO
implements DAO {
    Logger logger = LoggerFactory.getLogger(AbstractDAO.class);
    protected Map<String, String> fieldMapping = new HashMap<String, String>();
    private DataSource dataSource;

    public AbstractDAO(DataSource dataSource) {
        this.dataSource = dataSource;
        this.fieldMapping.put("string", "VARCHAR(255)");
        this.fieldMapping.put("boolean", "BOOLEAN");
        this.fieldMapping.put("byte", "TINYINT");
        this.fieldMapping.put("short", "SMALLINT");
        this.fieldMapping.put("int", "INTEGER");
        this.fieldMapping.put("integer", "INTEGER");
        this.fieldMapping.put("long", "BIGINT");
        this.fieldMapping.put("float", "FLOAT");
        this.fieldMapping.put("double", "DOUBLE");
        this.fieldMapping.put("date", "DATETIME");
        this.fieldMapping.put("time", "TIME");
        this.fieldMapping.put("timestamp", "TIMESTAMP");
    }

    protected abstract String getSyntax(Syntax var1);

    protected abstract String getUniqueStatement(String var1, List<String> var2);

    @Override
    public <T> T fetch(Class<T> _class, long id) {
        return this.fetch(_class, "id", id);
    }

    @Override
    public <T> T fetch(Class<T> _class, String property, Object value) {
        List<T> instanceList = this.fetchList(_class, property, value);
        if (ValidateUtil.isNotEmpty(instanceList)) {
            return instanceList.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> fetchList(Class<T> _class, String property, Object value) {
        try {
            Connection connection = this.dataSource.getConnection();
            String fetchSQL = SQLUtil.fetch(_class, property);
            PreparedStatement ps = connection.prepareStatement(fetchSQL);
            switch (value.getClass().getSimpleName().toLowerCase()) {
                case "int": {
                    ps.setInt(1, (Integer)value);
                    break;
                }
                case "integer": {
                    ps.setObject(1, (Integer)value);
                    break;
                }
                case "long": {
                    if (value.getClass().isPrimitive()) {
                        ps.setLong(1, (Long)value);
                        break;
                    }
                    ps.setObject(1, value);
                    break;
                }
                case "boolean": {
                    if (value.getClass().isPrimitive()) {
                        ps.setBoolean(1, (Boolean)value);
                        break;
                    }
                    ps.setObject(1, value);
                    break;
                }
                case "string": {
                    ps.setString(1, value == null ? "" : value.toString());
                    break;
                }
                default: {
                    ps.setObject(1, value);
                }
            }
            int count = (int)this.query(_class).addQuery(property, value).count();
            ArrayList instanceList = new ArrayList(count);
            ResultSet resultSet = ps.executeQuery();
            this.logger.debug("[\u6839\u636e\u5c5e\u6027{}=>{}\u83b7\u53d6\u5bf9\u8c61]\u6267\u884csql:{}", new Object[]{property, value, fetchSQL.replace("?", value.toString())});
            ReflectionUtil.mappingResultToList(resultSet, instanceList, _class);
            ps.close();
            connection.close();
            return instanceList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <T> Condition<T> query(Class<T> _class) {
        if (this instanceof SQLiteDAO) {
            return new SqliteCondition((Class)_class, this.dataSource);
        }
        return new AbstractCondition<T>(_class, this.dataSource);
    }

    @Override
    public long save(Object instance) {
        if (instance == null) {
            return 0L;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            Class<?> _class = instance.getClass();
            PreparedStatement ps = null;
            long effect = 0L;
            if (ReflectionUtil.hasUniqueKey(_class)) {
                Field[] fields;
                String updateByUniqueKey = SQLUtil.updateByUniqueKey(instance.getClass());
                ps = connection.prepareStatement(updateByUniqueKey);
                this.logger.debug("[\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateByUniqueKey(ps, instance, updateByUniqueKey));
                effect = ps.executeUpdate();
                Condition<?> condition = this.query(instance.getClass());
                for (Field field : fields = ReflectionUtil.getFields(_class)) {
                    if (field.getAnnotation(Unique.class) == null) continue;
                    condition.addQuery(StringUtil.Camel2Underline(field.getName()), field.get(instance));
                }
                List<Long> ids = condition.getValueList(Long.class, "id");
                if (ids.size() > 0) {
                    ReflectionUtil.setId(instance, ids.get(0));
                }
            } else if (ReflectionUtil.hasId(instance)) {
                String updateById = SQLUtil.updateById(instance.getClass());
                ps = connection.prepareStatement(updateById);
                this.logger.debug("[\u6839\u636eid\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateById(ps, instance, updateById));
                effect = ps.executeUpdate();
            } else {
                String insertIgnore = SQLUtil.insertIgnore(instance.getClass(), this.getSyntax(Syntax.InsertIgnore));
                ps = connection.prepareStatement(insertIgnore, 1);
                this.logger.debug("[\u6267\u884c\u63d2\u5165\u64cd\u4f5c]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithInsertIgnore(ps, instance, insertIgnore));
                effect = ps.executeUpdate();
                if (effect > 0L) {
                    ResultSet rs = ps.getGeneratedKeys();
                    rs.next();
                    long id = rs.getLong(1);
                    ReflectionUtil.setId(instance, id);
                    rs.close();
                }
            }
            ps.close();
            connection.close();
            return effect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public long save(List instanceList) {
        if (instanceList == null || instanceList.size() == 0) {
            return 0L;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            String updateByUniqueKey = SQLUtil.updateByUniqueKey(instanceList.get(0).getClass());
            PreparedStatement _updateByUniqueKeyPs = null;
            if (ReflectionUtil.hasUniqueKey(instanceList.get(0).getClass())) {
                _updateByUniqueKeyPs = connection.prepareStatement(updateByUniqueKey);
            }
            PreparedStatement updateByUniqueKeyPs = _updateByUniqueKeyPs;
            String updateById = SQLUtil.updateById(instanceList.get(0).getClass());
            PreparedStatement updateByIdPs = connection.prepareStatement(updateById);
            String insertIgnore = SQLUtil.insertIgnore(instanceList.get(0).getClass(), this.getSyntax(Syntax.InsertIgnore));
            PreparedStatement insertIgnorePs = connection.prepareStatement(insertIgnore);
            instanceList.stream().forEach(instance -> {
                try {
                    if (ReflectionUtil.hasUniqueKey(instance.getClass())) {
                        this.logger.debug("[\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateByUniqueKey(updateByUniqueKeyPs, instance, updateByUniqueKey));
                        updateByUniqueKeyPs.addBatch();
                    } else if (ReflectionUtil.hasId(instance)) {
                        this.logger.debug("[\u6839\u636eid\u66f4\u65b0]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithUpdateById(updateByIdPs, instance, updateById));
                        updateByIdPs.addBatch();
                    } else {
                        this.logger.debug("[\u6267\u884c\u63d2\u5165\u64cd\u4f5c]\u6267\u884cSQL:{}", (Object)ReflectionUtil.setValueWithInsertIgnore(insertIgnorePs, instance, insertIgnore));
                        insertIgnorePs.addBatch();
                    }
                }
                catch (Exception e) {
                    this.logger.warn("[\u63d2\u5165\u5355\u4e2a\u8bb0\u5f55\u5931\u8d25]{}", (Object)JSON.toJSONString((Object)instance));
                    e.printStackTrace();
                }
            });
            long effect = 0L;
            PreparedStatement[] preparedStatements = new PreparedStatement[]{updateByUniqueKeyPs, updateByIdPs, insertIgnorePs};
            for (int i = 0; i < preparedStatements.length; ++i) {
                int[] results;
                if (preparedStatements[i] == null) continue;
                int[] nArray = results = preparedStatements[i].executeBatch();
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    long result = nArray[j];
                    effect += result;
                }
                preparedStatements[i].close();
            }
            connection.commit();
            connection.setAutoCommit(true);
            connection.close();
            return effect;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return -1L;
        }
    }

    @Override
    public long save(Object[] instances) {
        return this.save(Arrays.asList(instances));
    }

    @Override
    public long delete(Class _class, long id) {
        return this.delete(_class, "id", id);
    }

    @Override
    public long delete(Class _class, String property, Object value) {
        try {
            Connection connection = this.dataSource.getConnection();
            String deleteSQL = SQLUtil.delete(_class, property);
            PreparedStatement ps = connection.prepareStatement(deleteSQL);
            ps.setObject(1, value);
            this.logger.debug("[\u6839\u636e\u5c5e\u6027{}=>{}\u5220\u9664]\u6267\u884cSQL:{}", new Object[]{property, value, deleteSQL.replace("?", value.toString())});
            long effect = ps.executeUpdate();
            ps.close();
            connection.close();
            return effect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public long clear(Class _class) {
        try {
            Connection connection = this.dataSource.getConnection();
            String sql = "delete from " + StringUtil.Camel2Underline(_class.getSimpleName());
            this.logger.debug("[\u5220\u9664{}\u8868]\u6267\u884cSQL:{}", (Object)_class.getSimpleName(), (Object)sql);
            PreparedStatement ps = connection.prepareStatement(sql);
            long effect = ps.executeUpdate();
            ps.close();
            connection.close();
            return effect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    protected JSONArray getEntityInfo(String packageName, Predicate<Class> predicate) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = classLoader.getResources(packageName.replace(".", "/"));
        List<Object> classes = new ArrayList();
        String packageNamePath = packageName.replace(".", "/");
        while (enumeration.hasMoreElements()) {
            JarFile jarFile;
            JarURLConnection jarURLConnection;
            URL url = enumeration.nextElement();
            if ("file".equals(url.getProtocol())) {
                String packagePath = url.getPath().replaceAll("%20", " ");
                File file2 = new File(packagePath);
                if (!file2.isDirectory()) continue;
                for (File file22 : file2.listFiles(file -> file.isFile() && file.getName().endsWith(".class"))) {
                    String className = packageName + "." + file22.getName().substring(0, file22.getName().length() - 6);
                    classes.add(classLoader.loadClass(className));
                }
                continue;
            }
            if (!"jar".equals(url.getProtocol()) || null == (jarURLConnection = (JarURLConnection)url.openConnection()) || null == (jarFile = jarURLConnection.getJarFile())) continue;
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                classes.add(classLoader.loadClass(className));
            }
        }
        if (classes.size() == 0) {
            return new JSONArray();
        }
        if (predicate != null) {
            classes = classes.stream().filter(predicate).collect(Collectors.toList());
        }
        JSONArray entityList = new JSONArray();
        for (Class clazz : classes) {
            JSONObject entity = new JSONObject();
            entity.put("ignore", (Object)(clazz.getDeclaredAnnotation(Ignore.class) != null ? 1 : 0));
            entity.put("tableName", (Object)StringUtil.Camel2Underline(clazz.getSimpleName()));
            entity.put("className", (Object)clazz.getSimpleName());
            AccessibleObject[] fields = clazz.getDeclaredFields();
            Field.setAccessible(fields, true);
            JSONArray properties = new JSONArray();
            for (int i = 0; i < fields.length; ++i) {
                JSONObject property = new JSONObject();
                property.put("ignore", (Object)(fields[i].getDeclaredAnnotation(Ignore.class) != null ? 1 : 0));
                property.put("column", (Object)StringUtil.Camel2Underline(((Field)fields[i]).getName()));
                property.put("unique", (Object)(fields[i].getDeclaredAnnotation(Unique.class) != null ? 1 : 0));
                property.put("notNull", (Object)(fields[i].getDeclaredAnnotation(NotNull.class) != null ? 1 : 0));
                if ("id".equals(property.getString("column"))) {
                    property.put("unique", (Object)true);
                    property.put("notNull", (Object)true);
                }
                if (fields[i].getDeclaredAnnotation(ColumnType.class) != null) {
                    property.put("columnType", (Object)fields[i].getDeclaredAnnotation(ColumnType.class).value());
                }
                if (fields[i].getDeclaredAnnotation(DefaultValue.class) != null) {
                    property.put("default", (Object)fields[i].getDeclaredAnnotation(DefaultValue.class).value());
                }
                property.put("type", (Object)((Field)fields[i]).getType().getSimpleName().toLowerCase());
                properties.add((Object)property);
            }
            entity.put("properties", (Object)properties);
            entityList.add((Object)entity);
        }
        return entityList;
    }

    protected JSONArray getDatabaseInfo(Connection connection) throws SQLException {
        PreparedStatement tablePs = connection.prepareStatement("show tables;");
        ResultSet tableRs = tablePs.executeQuery();
        JSONArray entityList = new JSONArray();
        while (tableRs.next()) {
            JSONObject entity = new JSONObject();
            entity.put("tableName", (Object)tableRs.getString(1));
            JSONArray properties = new JSONArray();
            PreparedStatement propertyPs = connection.prepareStatement("show columns from `" + tableRs.getString(1) + "`");
            ResultSet propertiesRs = propertyPs.executeQuery();
            while (propertiesRs.next()) {
                JSONObject property = new JSONObject();
                property.put("column", (Object)propertiesRs.getString("Field"));
                property.put("columnType", (Object)propertiesRs.getString("Type"));
                property.put("notNull", (Object)"NO".equals(propertiesRs.getString("Null")));
                property.put("unique", (Object)"UNI".equals(propertiesRs.getString("Key")));
                if (null != propertiesRs.getString("Default")) {
                    property.put("default", (Object)propertiesRs.getString("Default"));
                }
                properties.add((Object)property);
            }
            entity.put("properties", (Object)properties);
            entityList.add((Object)entity);
            propertiesRs.close();
            propertyPs.close();
        }
        tableRs.close();
        tablePs.close();
        connection.close();
        return entityList;
    }

    public void autoBuildDatabase(String packageName) {
        Predicate predicate = null;
        this.autoBuildDatabase(packageName, predicate);
    }

    public void autoBuildDatabase(String packageName, String regexPattern) {
        if (ValidateUtil.isEmpty(regexPattern)) {
            throw new IllegalArgumentException("regexPattern\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Pattern pattern = Pattern.compile(regexPattern);
        Predicate<Class> predicate = c -> {
            Matcher m = pattern.matcher(c.getName());
            return !m.matches();
        };
        this.logger.info("[\u6839\u636e\u6b63\u5219\u8fc7\u6ee4\u5b9e\u4f53\u7c7b]{}", (Object)regexPattern);
        this.autoBuildDatabase(packageName, predicate);
    }

    public void autoBuildDatabase(String packageName, String[] excludePackageNames) {
        if (ValidateUtil.isEmpty(excludePackageNames)) {
            throw new IllegalArgumentException("excludePackageNames\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Predicate<Class> predicate = c -> {
            boolean result = true;
            for (String excludePackageName : excludePackageNames) {
                if (!c.getName().contains(excludePackageName)) continue;
                result = false;
                break;
            }
            return result;
        };
        this.logger.info("[\u6839\u636e\u5305\u540d\u6392\u9664]{}", JSON.toJSON((Object)excludePackageNames));
        this.autoBuildDatabase(packageName, predicate);
    }

    public void autoBuildDatabase(String packageName, Predicate predicate) {
        this.logger.trace("[\u81ea\u52a8\u5efa\u8868\u5f00\u59cb\u6267\u884c]");
        if (ValidateUtil.isEmpty(packageName)) {
            throw new IllegalArgumentException("packageName\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            JSONArray dbEntityList = this.getDatabaseInfo(this.dataSource.getConnection());
            JSONArray entityList = this.getEntityInfo(packageName, predicate);
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            for (int i = 0; i < entityList.size(); ++i) {
                JSONObject source = entityList.getJSONObject(i);
                String className = source.getString("className");
                if (source.getBoolean("ignore").booleanValue()) {
                    this.logger.debug("[\u5ffd\u7565\u5b9e\u4f53\u7c7b{}]\u8be5\u5b9e\u4f53\u7c7b\u88abIgnore\u6ce8\u89e3\u4fee\u9970!", (Object)className);
                    continue;
                }
                String tableName = source.getString("tableName");
                JSONObject target = this.getValue(dbEntityList, "tableName", tableName);
                ArrayList<String> uniqueColumnList = new ArrayList<String>();
                if (target == null && !source.getBoolean("ignore").booleanValue()) {
                    StringBuilder builder = new StringBuilder("create table `" + tableName + "`(");
                    JSONArray properties = source.getJSONArray("properties");
                    for (int j = 0; j < properties.size(); ++j) {
                        String columnType;
                        JSONObject property = properties.getJSONObject(j);
                        String column = property.getString("column");
                        String string = columnType = property.containsKey((Object)"columnType") ? property.getString("columnType") : this.fieldMapping.get(property.getString("type"));
                        if ("id".equals(column)) {
                            builder.append(column + " " + columnType + " primary key " + this.getSyntax(Syntax.AutoIncrement));
                        } else {
                            builder.append("`" + column + "` " + columnType);
                            if (property.containsKey((Object)"default")) {
                                builder.append(" default " + property.getString("default"));
                            }
                            if (property.getBoolean("notNull").booleanValue()) {
                                builder.append(" not null ");
                            }
                            if (property.getBoolean("unique").booleanValue()) {
                                uniqueColumnList.add(column);
                            }
                        }
                        if (j == properties.size() - 1) continue;
                        builder.append(",");
                    }
                    builder.append(")");
                    String sql = builder.toString().replaceAll("\\s+", " ");
                    this.logger.debug("[\u751f\u6210\u65b0\u8868{}=>{}]\u6267\u884csql:{}", new Object[]{className, tableName, sql});
                    connection.prepareStatement(sql).executeUpdate();
                } else {
                    JSONArray sourceProperties = source.getJSONArray("properties");
                    JSONArray targetProperties = target.getJSONArray("properties");
                    this.addNewColumn(connection, tableName, uniqueColumnList, sourceProperties, targetProperties);
                }
                if (uniqueColumnList.size() <= 0) continue;
                String uniqueSQL = this.getUniqueStatement(tableName, uniqueColumnList);
                this.logger.debug("[\u4e3a\u8868{}\u751f\u6210\u552f\u4e00\u7ea6\u675f]\u6267\u884csql:{}", (Object)tableName, (Object)uniqueSQL);
                connection.prepareStatement(uniqueSQL).executeUpdate();
            }
            connection.commit();
            connection.setAutoCommit(true);
            connection.close();
            this.logger.trace("[\u81ea\u52a8\u5efa\u8868\u5b8c\u6210]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addNewColumn(Connection connection, String tableName, List<String> uniqueColumnList, JSONArray sourceProperties, JSONArray targetProperties) throws SQLException {
        for (int j = 0; j < sourceProperties.size(); ++j) {
            JSONObject sourceProperty = sourceProperties.getJSONObject(j);
            JSONObject targetProperty = this.getValue(targetProperties, "column", sourceProperty.getString("column"));
            if (targetProperty != null) continue;
            String column = sourceProperty.getString("column");
            String columnType = sourceProperty.containsKey((Object)"columnType") ? sourceProperty.getString("columnType") : this.fieldMapping.get(sourceProperty.getString("type"));
            StringBuilder builder = new StringBuilder();
            builder.append("alter table " + tableName + " add column `" + column + "` " + columnType);
            if (sourceProperty.containsKey((Object)"default")) {
                builder.append(" default " + sourceProperty.getString("default"));
            }
            String sql = builder.toString().replaceAll("\\s+", " ");
            this.logger.debug("[\u5728\u8868{}\u6dfb\u52a0\u65b0\u5217{}]({}) \u6267\u884csql:[{}],\u6267\u884c\u7ed3\u679c:{}", new Object[]{tableName, column, columnType, sql, connection.prepareStatement(sql).executeUpdate()});
            if (!sourceProperty.getBoolean("unique").booleanValue()) continue;
            uniqueColumnList.add(column);
        }
    }

    protected JSONObject getValue(JSONArray array, String propertyName, String value) {
        for (int i = 0; i < array.size(); ++i) {
            if (!array.getJSONObject(i).getString(propertyName).equals(value)) continue;
            return array.getJSONObject(i);
        }
        return null;
    }

    protected static enum Syntax {
        AutoIncrement,
        InsertIgnore;

    }
}

