/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.condition;

import cn.schoolwow.quickdao.condition.AbstractCondition;
import cn.schoolwow.quickdao.condition.Condition;
import cn.schoolwow.quickdao.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;

public class SqliteCondition
extends AbstractCondition {
    public SqliteCondition(Class _class, DataSource dataSource) {
        super(_class, dataSource);
    }

    @Override
    public Condition addUpdate(String property, Object value) {
        if (this.updateParameterList == null) {
            this.updateParameterList = new ArrayList();
        }
        this.setBuilder.append("`" + StringUtil.Camel2Underline(property) + "`=?,");
        this.updateParameterList.add(value);
        return this;
    }

    @Override
    public long update() {
        if (!this.hasDone) {
            this.done();
        }
        if (this.setBuilder.length() == 0) {
            this.logger.warn("\u8bf7\u5148\u8c03\u7528addUpdate\u65b9\u6cd5!");
            return 0L;
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("update " + this.tableName + " " + this.setBuilder.toString() + " ");
        this.sqlBuilder.append(this.whereBuilder.toString().replaceAll("t\\.", ""));
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long effect = -1L;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.sql);){
            int parameterIndex = 1;
            if (this.updateParameterList != null && this.updateParameterList.size() > 0) {
                for (Object parameter : this.updateParameterList) {
                    ps.setObject(parameterIndex++, parameter);
                    this.replaceParameter(parameter);
                }
            }
            for (Object parameter : this.parameterList) {
                ps.setObject(parameterIndex++, parameter);
                this.replaceParameter(parameter);
            }
            this.logger.debug("[Update]\u6267\u884cSQL:{}", (Object)this.sql);
            effect = ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effect;
    }

    @Override
    public long delete() {
        if (!this.hasDone) {
            this.done();
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("delete from " + this.tableName + " ");
        this.sqlBuilder.append(this.whereBuilder.toString().replaceAll("t\\.", ""));
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long effect = -1L;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.sql);){
            for (int i = 0; i < this.parameterList.size(); ++i) {
                ps.setObject(i + 1, this.parameterList.get(i));
                this.replaceParameter(this.parameterList.get(i));
            }
            this.logger.debug("[Delete]\u6267\u884cSQL:{}", (Object)this.sql);
            effect = ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effect;
    }
}

