/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.condition;

import cn.schoolwow.quickdao.condition.Condition;
import cn.schoolwow.quickdao.condition.SubCondition;
import cn.schoolwow.quickdao.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCondition<T>
implements Condition<T> {
    Logger logger = LoggerFactory.getLogger(AbstractCondition.class);
    protected StringBuilder columnBuilder = new StringBuilder();
    protected StringBuilder setBuilder = new StringBuilder();
    protected StringBuilder whereBuilder = new StringBuilder();
    protected StringBuilder groupByBuilder = new StringBuilder("group by ");
    protected StringBuilder havingBuilder = new StringBuilder("having ");
    protected StringBuilder orderByBuilder = new StringBuilder();
    protected String limit = "";
    protected List parameterList = new ArrayList();
    protected List updateParameterList;
    protected Class<T> _class;
    protected DataSource dataSource;
    protected StringBuilder sqlBuilder = new StringBuilder();
    protected String sql;
    private int joinTableIndex = 1;
    private List<AbstractSubCondition> subConditionList = new ArrayList<AbstractSubCondition>();
    protected String tableName = null;
    protected boolean hasDone = false;
    private static String[] patterns = new String[]{"%", "_", "[", "[^", "[!", "]"};

    public AbstractCondition(Class<T> _class, DataSource dataSource) {
        this._class = _class;
        this.tableName = StringUtil.Camel2Underline(_class.getSimpleName());
        this.dataSource = dataSource;
    }

    @Override
    public Condition addNullQuery(String field) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` is null or t.`" + StringUtil.Camel2Underline(field) + "` = '') and ");
        return this;
    }

    @Override
    public Condition addNotNullQuery(String field) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` is not null) and ");
        return this;
    }

    @Override
    public Condition addNotEmptyQuery(String field) {
        this.whereBuilder.append("(t.`" + StringUtil.Camel2Underline(field) + "` is not null and t.`" + StringUtil.Camel2Underline(field) + "` != '') and ");
        return this;
    }

    @Override
    public Condition addInQuery(String field, Object[] values) {
        int i;
        if (values == null || values.length == 0) {
            return this;
        }
        if (values[0] instanceof String) {
            for (i = 0; i < values.length; ++i) {
                values[i] = values[i].toString();
            }
        }
        this.parameterList.addAll(Arrays.asList(values));
        this.whereBuilder.append("(t." + StringUtil.Camel2Underline(field) + " in (");
        for (i = 0; i < values.length; ++i) {
            this.whereBuilder.append("?,");
        }
        this.whereBuilder.deleteCharAt(this.whereBuilder.length() - 1);
        this.whereBuilder.append(") ) and ");
        return this;
    }

    @Override
    public Condition addInQuery(String field, List values) {
        return this.addInQuery(field, values.toArray(new Object[values.size()]));
    }

    @Override
    public Condition addQuery(String query) {
        this.whereBuilder.append("(" + query + ") and ");
        return this;
    }

    @Override
    public Condition addQuery(String property, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        if (value instanceof String) {
            this.addQuery(property, "like", value);
        } else {
            this.addQuery(property, "=", value);
        }
        return this;
    }

    @Override
    public Condition addQuery(String property, String operator, Object value) {
        if (value instanceof String) {
            this.whereBuilder.append("(t.`" + property + "` " + operator + " ?) and ");
            boolean hasContains = false;
            for (String pattern : patterns) {
                if (!((String)value).contains(pattern)) continue;
                this.parameterList.add(value);
                hasContains = true;
                break;
            }
            if (!hasContains) {
                this.parameterList.add("%" + value + "%");
            }
        } else {
            this.whereBuilder.append("(t.`" + property + "` " + operator + " ?) and ");
            this.parameterList.add(value);
        }
        return this;
    }

    @Override
    public Condition addUpdate(String property, Object value) {
        if (this.updateParameterList == null) {
            this.updateParameterList = new ArrayList();
        }
        this.setBuilder.append("t.`" + StringUtil.Camel2Underline(property) + "`=?,");
        this.updateParameterList.add(value);
        return this;
    }

    @Override
    public <T> SubCondition<T> joinTable(Class<T> _class, String primaryField, String joinTableField) {
        String tableNameAlias = "t" + this.joinTableIndex;
        ++this.joinTableIndex;
        AbstractSubCondition<T> subCondition = new AbstractSubCondition<T>(_class, tableNameAlias, primaryField, joinTableField, this);
        this.subConditionList.add(subCondition);
        return subCondition;
    }

    @Override
    public Condition orderBy(String field) {
        this.orderByBuilder.append("t.`" + field + "` asc,");
        return this;
    }

    @Override
    public Condition orderByDesc(String field) {
        this.orderByBuilder.append("t.`" + field + "` desc,");
        return this;
    }

    @Override
    public Condition limit(long offset, long limit) {
        this.limit = "limit " + offset + "," + limit;
        return this;
    }

    @Override
    public Condition page(int pageNum, int pageSize) {
        this.limit = "limit " + (pageNum - 1) * pageSize + "," + pageSize;
        return this;
    }

    @Override
    public Condition addColumn(String field) {
        this.columnBuilder.append("t." + StringUtil.Camel2Underline(field) + ",");
        return this;
    }

    protected Condition done() {
        if (this.columnBuilder.length() > 0) {
            this.columnBuilder.deleteCharAt(this.columnBuilder.length() - 1);
        }
        if (this.setBuilder.length() > 0) {
            this.setBuilder.deleteCharAt(this.setBuilder.length() - 1);
            this.setBuilder.insert(0, "set ");
        }
        if (this.whereBuilder.length() > 0) {
            this.whereBuilder.delete(this.whereBuilder.length() - 5, this.whereBuilder.length());
            this.whereBuilder.insert(0, "where ");
        }
        if ("group by ".equals(this.groupByBuilder.toString())) {
            this.groupByBuilder.setLength(0);
        } else {
            this.groupByBuilder.deleteCharAt(this.groupByBuilder.length() - 1);
        }
        if ("having ".equals(this.havingBuilder.toString())) {
            this.havingBuilder.setLength(0);
        } else {
            this.havingBuilder.delete(this.havingBuilder.length() - 5, this.havingBuilder.length());
        }
        if (this.orderByBuilder.length() > 0) {
            this.orderByBuilder.deleteCharAt(this.orderByBuilder.length() - 1);
            this.orderByBuilder.insert(0, "order by ");
        }
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            if (abstractSubCondition.whereBuilder.length() <= 0) continue;
            abstractSubCondition.whereBuilder.delete(abstractSubCondition.whereBuilder.length() - 5, abstractSubCondition.whereBuilder.length());
        }
        this.hasDone = true;
        return this;
    }

    @Override
    public long count() {
        if (!this.hasDone) {
            this.done();
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("select count(1) from `" + this.tableName + "` as t ");
        this.addJoinTableStatement();
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long count = -1L;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.sql);){
            for (int i = 0; i < this.parameterList.size(); ++i) {
                ps.setObject(i + 1, this.parameterList.get(i));
                this.replaceParameter(this.parameterList.get(i));
            }
            this.addJoinTableParamters(ps);
            this.logger.debug("[Count]\u6267\u884cSQL:{}", (Object)this.sql);
            ResultSet resultSet = ps.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public long update() {
        if (!this.hasDone) {
            this.done();
        }
        if (this.setBuilder.length() == 0) {
            this.logger.warn("\u8bf7\u5148\u8c03\u7528addUpdate\u65b9\u6cd5!");
            return 0L;
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("update " + this.tableName + " as t " + this.setBuilder.toString() + " ");
        this.addJoinTableStatement();
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long effect = -1L;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.sql);){
            int parameterIndex = 1;
            if (this.updateParameterList != null && this.updateParameterList.size() > 0) {
                for (Object parameter : this.updateParameterList) {
                    ps.setObject(parameterIndex++, parameter);
                    this.replaceParameter(parameter);
                }
            }
            for (Object parameter : this.parameterList) {
                ps.setObject(parameterIndex++, parameter);
                this.replaceParameter(parameter);
            }
            this.addJoinTableParamters(ps);
            this.logger.debug("[Update]\u6267\u884cSQL:{}", (Object)this.sql);
            effect = ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effect;
    }

    @Override
    public long delete() {
        if (!this.hasDone) {
            this.done();
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("delete t from " + this.tableName + " as t ");
        this.addJoinTableStatement();
        this.sql = this.sqlBuilder.toString().replaceAll("\\s+", " ");
        long effect = -1L;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.sql);){
            for (int i = 0; i < this.parameterList.size(); ++i) {
                ps.setObject(i + 1, this.parameterList.get(i));
                this.replaceParameter(this.parameterList.get(i));
            }
            this.addJoinTableParamters(ps);
            this.logger.debug("[Delete]\u6267\u884cSQL:{}", (Object)this.sql);
            effect = ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effect;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<T> getList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<T> getValueList(Class<T> _class, String column) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addJoinTableStatement() {
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            String subTableName = StringUtil.Camel2Underline(abstractSubCondition._class.getSimpleName());
            this.sqlBuilder.append("join " + subTableName + " as " + abstractSubCondition.tableAliasName + " on t." + StringUtil.Camel2Underline(abstractSubCondition.primaryField) + " = " + StringUtil.Camel2Underline(abstractSubCondition.tableAliasName) + "." + abstractSubCondition.joinTableField + " ");
        }
        this.sqlBuilder.append(this.whereBuilder.toString());
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            if (abstractSubCondition.whereBuilder.length() <= 0) continue;
            this.sqlBuilder.append(" and " + abstractSubCondition.whereBuilder.toString() + " ");
        }
    }

    private void addJoinTableParamters(PreparedStatement ps) throws SQLException {
        int parameterIndex = this.parameterList.size() + 1;
        for (AbstractSubCondition abstractSubCondition : this.subConditionList) {
            for (Object parameter : abstractSubCondition.parameterList) {
                ps.setObject(parameterIndex++, parameter);
                this.replaceParameter(parameter);
            }
        }
    }

    protected void replaceParameter(Object parameter) {
        String type;
        switch (type = parameter.getClass().getSimpleName().toLowerCase()) {
            case "int": 
            case "integer": 
            case "long": 
            case "boolean": {
                this.sql = this.sql.replaceFirst("\\?", parameter.toString());
                break;
            }
            case "string": {
                this.sql = this.sql.replaceFirst("\\?", "'" + parameter.toString() + "'");
                break;
            }
            default: {
                this.sql = this.sql.replaceFirst("\\?", parameter.toString());
            }
        }
    }

    class AbstractSubCondition<T>
    implements SubCondition<T> {
        private Class<T> _class;
        private String tableAliasName;
        private String primaryField;
        private String joinTableField;
        private StringBuilder whereBuilder = new StringBuilder();
        private List parameterList = new ArrayList();
        private Condition condition;

        public AbstractSubCondition(Class<T> _class, String tableAliasName, String primaryField, String joinTableField, Condition condition) {
            this._class = _class;
            this.tableAliasName = tableAliasName;
            this.primaryField = primaryField;
            this.joinTableField = joinTableField;
            this.condition = condition;
        }

        @Override
        public SubCondition addNullQuery(String field) {
            this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` is null or " + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` = '') and ");
            return this;
        }

        @Override
        public SubCondition addNotNullQuery(String field) {
            this.whereBuilder.append("(" + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` is not null and " + this.tableAliasName + ".`" + StringUtil.Camel2Underline(field) + "` != '') and ");
            return this;
        }

        @Override
        public SubCondition addInQuery(String field, Object[] values) {
            if (values == null || values.length == 0) {
                return this;
            }
            this.parameterList.addAll(Arrays.asList(values));
            this.whereBuilder.append("(" + this.tableAliasName + "." + StringUtil.Camel2Underline(field) + " in (");
            for (int i = 0; i < values.length; ++i) {
                this.whereBuilder.append("?,");
            }
            this.whereBuilder.deleteCharAt(this.whereBuilder.length() - 1);
            this.whereBuilder.append(") ) and ");
            return this;
        }

        @Override
        public SubCondition addInQuery(String field, List values) {
            return this.addInQuery(field, values.toArray(new Object[values.size()]));
        }

        @Override
        public SubCondition addQuery(String query) {
            this.whereBuilder.append("(" + query + ") and ");
            return this;
        }

        @Override
        public SubCondition addQuery(String property, Object value) {
            if (value == null || value.toString().equals("")) {
                return this;
            }
            if (value instanceof String) {
                this.addQuery(property, "like", value);
            } else {
                this.addQuery(property, "=", value);
            }
            return this;
        }

        @Override
        public SubCondition addQuery(String property, String operator, Object value) {
            if (value instanceof String) {
                this.whereBuilder.append("(" + this.tableAliasName + ".`" + property + "` " + operator + " ?) and ");
                boolean hasContains = false;
                for (String pattern : patterns) {
                    if (!((String)value).contains(pattern)) continue;
                    this.parameterList.add(value);
                    hasContains = true;
                    break;
                }
                if (!hasContains) {
                    this.parameterList.add("%" + value + "%");
                }
            } else {
                this.whereBuilder.append("(" + this.tableAliasName + ".`" + property + "` " + operator + " ?) and ");
                this.parameterList.add(value);
            }
            return this;
        }

        @Override
        public Condition done() {
            return this.condition;
        }
    }
}

