/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.dao.AbstractDAO;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.MySQLDAO;
import cn.schoolwow.quickdao.dao.SQLiteDAO;
import cn.schoolwow.quickdao.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAO {
    Logger logger = LoggerFactory.getLogger(QuickDAO.class);
    private static HashMap<String, Class> driverMapping = new HashMap();
    private DataSource dataSource;
    private String packageName;
    private String regexPattern;
    private String[] excludePackageNames;
    private Predicate<Class> predicate;

    public static QuickDAO newInstance() {
        return new QuickDAO();
    }

    public QuickDAO dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public QuickDAO packageName(String packageName) {
        this.packageName = packageName;
        this.logger.debug("[\u8bbe\u7f6e\u5b9e\u4f53\u7c7b\u5305]{}", (Object)packageName);
        return this;
    }

    public QuickDAO filter(String regexPattern) {
        this.regexPattern = regexPattern;
        this.logger.debug("[\u8fc7\u6ee4\u5305-\u6b63\u5219\u8868\u8fbe\u5f0f]{}", (Object)regexPattern);
        return this;
    }

    public QuickDAO filter(String[] excludePackageNames) {
        this.excludePackageNames = excludePackageNames;
        this.logger.debug("[\u8fc7\u6ee4\u5305-\u6b63\u5219\u8868\u8fbe\u5f0f]{}", (Object)JSON.toJSONString((Object)excludePackageNames));
        return this;
    }

    public QuickDAO filter(Predicate<Class> predicate) {
        this.predicate = predicate;
        this.logger.debug("[\u8fc7\u6ee4\u5305-\u51fd\u6570\u5f0f\u63a5\u53e3]{}", predicate);
        return this;
    }

    public DAO build() {
        if (ValidateUtil.isNull(this.packageName) || ValidateUtil.isNull(this.dataSource)) {
            throw new IllegalArgumentException("packageName\u548cdataSource\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        AbstractDAO dao = null;
        try {
            Connection connection = this.dataSource.getConnection();
            String url = connection.getMetaData().getURL();
            this.logger.info("[\u6570\u636e\u6e90\u5730\u5740]{}", (Object)url);
            Set<String> keySet = driverMapping.keySet();
            for (String key : keySet) {
                if (!url.contains(key)) continue;
                dao = (AbstractDAO)driverMapping.get(key).getConstructor(DataSource.class).newInstance(this.dataSource);
                break;
            }
            if (dao == null) {
                throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u6e90\u6ca1\u6709\u5408\u9002\u7684\u9002\u914d\u5668.\u6570\u636e\u6e90\u5730\u5740:" + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ValidateUtil.isNotEmpty(this.regexPattern)) {
            dao.autoBuildDatabase(this.packageName, this.regexPattern);
        } else if (ValidateUtil.isNotEmpty(this.excludePackageNames)) {
            dao.autoBuildDatabase(this.packageName, this.excludePackageNames);
        } else if (ValidateUtil.isNull(this.predicate)) {
            dao.autoBuildDatabase(this.packageName, this.predicate);
        } else {
            dao.autoBuildDatabase(this.packageName);
        }
        return dao;
    }

    static {
        driverMapping.put("jdbc:h2", MySQLDAO.class);
        driverMapping.put("jdbc:sqlite", SQLiteDAO.class);
        driverMapping.put("jdbc:mysql", MySQLDAO.class);
    }
}

