userBlockMap["quickapi|clazz|API"] = {
    "operations": {
        "viewAPIParameterList": {
            "type": "button",
            "label": "参数列表",
            "props": {
                "type": "primary",
            },
            "show": function (row) {
                return row["parameterCount"]>0;
            },
            "event": "viewAPIParameterList"
        },
        "viewParameterEntityList": {
            "type": "button",
            "label": "请求参数实体",
            "props": {
                "type": "primary",
            },
            "show": function (row) {
                return row["parameterEntityNameList"].length>0;
            },
            "event": "viewParameterEntityList"
        },
        "viewReturnEntityList": {
            "type": "button",
            "label": "返回参数实体",
            "props": {
                "type": "primary",
            },
            "show": function (row) {
                return row["returnEntityNameList"].length>0;
            },
            "event": "viewReturnEntityList"
        },
        "copyAPIList": {
            "event": "copyAPIList"
        },
        "executeHttpRequest": {
            "type": "button",
            "label": "执行请求",
            "props": {
                "type": "primary",
            },
            "event": "executeHttpRequest"
        },
    },
    "actions":{
        viewAPIParameterList(params){
            let row = params.$prevReturn;
            this.callAction("routerPush", {
                "path": "/api/quickapi|clazz|APIParameter",
                "query": {
                    "controllerClassName": row["controllerClassName"],
                    "methodName": row["methodName"]
                }
            });
        },
        viewParameterEntityList(params){
            let row = params.$prevReturn;
            this.callAction("routerPush", {
                "path": "/entity/quickapi|clazz|ParameterEntity",
                "query": {
                    "className": "in:"+row["parameterEntityNameList"].join(",")
                }
            });
        },
        viewReturnEntityList(params){
            let row = params.$prevReturn;
            this.callAction("routerPush", {
                "path": "/entity/quickapi|clazz|ReturnEntity",
                "query": {
                    "entityClassName": "in:"+row["returnEntityNameList"].join(",")
                }
            });
        },
        copyAPIList(params){
            return ams.utils.sendRequestWithResponse(this, {
                "method": "POST",
                "url": "/copyAPIList",
            }, (response)=>{
                let body = JSON.stringify(response["data"]["body"]);
                setClipBoard(body);
                this.$message.success("接口列表内容已复制到剪贴板");
            });
        },
        executeHttpRequest(params){
            let row = params.$prevReturn;
            let contentType = row["contentType"];
            if(null!=contentType&&contentType!==""){
                switch (row["contentType"]) {
                    case "application/x-www-form-urlencoded":{contentType = "form";}break;
                    case "application/json":{contentType = "json";}break;
                    default:{
                        this.$message.error("不支持执行该类型请求!类型:"+contentType);
                    }
                }
            }else{
                contentType = "form";
            }

            let headerMap = row["headerMap"];
            try {
                let list = JSON.parse(localStorage.getItem("globalHeader"));
                for(let i=0;i<list.length;i++){
                    let o = list[i];
                    if(headerMap.hasOwnProperty(o["headerName"])){
                        headerMap["headerMap"] = o["headerValue"];
                    }
                }
            }catch (e) {

            }

            let body = null==row["body"]?null:JSON.stringify(row["body"]);
            let query = {
                "method": row["requestMethod"],
                "url": row["url"],
                "contentType": contentType,
                "headerMap": JSON.stringify(headerMap),
                "body": body
            };
            localStorage.setItem("executeHttpRequest", JSON.stringify(query));
            this.callAction("routerPush", {
                "path": "/execute/quickapi|form|executeHttpRequest",
            });
        }
    },
    "headerNames": "description,requestMethod,url,contentType,parameterCount,returnClassName,headerMap"
};