package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.web.bind.annotation.RequestHeader;

import java.lang.reflect.Parameter;

public class GetRequestHeaderAnnotationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        API api = (API) flowContext.checkData("api");
        Parameter parameter = (Parameter) flowContext.checkData("parameter");
        String parameterName = (String) flowContext.getData("parameterName", parameter.getName());

        RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
        if(null==requestHeader){
            return;
        }
        api.headerMap.put(requestHeader.value(), parameterName);
        flowContext.putTemporaryData("handleFlag", true);
    }

    @Override
    public String name() {
        return "读取RequestHeader注解";
    }
}
