package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Parameter;

public class GetByRequestPartAnnotationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        API api = (API) flowContext.checkData("api");
        Parameter parameter = (Parameter) flowContext.checkData("parameter");

        RequestPart requestPart = parameter.getAnnotation(RequestPart.class);
        if(null==requestPart){
            return;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.annotationParameterName = requestPart.value();
        if(StringUtils.isEmpty(apiParameter.annotationParameterName)){
            apiParameter.annotationParameterName = requestPart.name();
        }
        apiParameter.required = requestPart.required();
        if(MultipartFile.class.getName().equals(parameter.getType().getName())){
            apiParameter.requestType = "file";
        }
        apiParameter.position = "body";
        api.contentType = "multipart/form-data";

        flowContext.putTemporaryData("apiParameter", apiParameter);
        flowContext.brokenCurrentCompositeBusiness("读取参数信息完成");
    }

    @Override
    public String name() {
        return "通过RequestPart注解获取参数";
    }
}
