package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ValueConstants;

import java.lang.reflect.Parameter;

public class GetByRequestParamAnnotationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        API api = (API) flowContext.checkData("api");
        Parameter parameter = (Parameter) flowContext.checkData("parameter");

        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        if(null==requestParam){
            return;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.annotationParameterName = requestParam.value();
        if(StringUtils.isEmpty(apiParameter.annotationParameterName)){
            apiParameter.annotationParameterName = requestParam.name();
        }
        if(!requestParam.defaultValue().equals(ValueConstants.DEFAULT_NONE)){
            apiParameter.defaultValue = requestParam.defaultValue();
        }
        apiParameter.required = requestParam.required();
        apiParameter.position = "query";
        if("POST".equalsIgnoreCase(api.requestMethod)
                ||"PUT".equalsIgnoreCase(api.requestMethod)
                ||"PATCH".equalsIgnoreCase(api.requestMethod)
        ){
            apiParameter.position = "body";
        }
        api.contentType = "application/x-www-form-urlencoded";
        if(null==api.body){
            api.body = new JSONObject();
        }
        api.body.put(apiParameter.annotationParameterName, parameter.getName());

        flowContext.putTemporaryData("apiParameter", apiParameter);
        flowContext.brokenCurrentCompositeBusiness("读取参数信息完成");
    }

    @Override
    public String name() {
        return "通过RequestParam注解获取参数";
    }
}
