package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import org.springframework.web.bind.annotation.RequestBody;

import java.lang.reflect.Parameter;

public class GetByRequestBodyAnnotationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        API api = (API) flowContext.checkData("api");
        Parameter parameter = (Parameter) flowContext.checkData("parameter");

        RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
        if(null==requestBody){
            return;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.required = requestBody.required();
        apiParameter.position = "body";
        apiParameter.requestType = "text";
        api.contentType = "application/json";
        Object instance = parameter.getType().newInstance();
        api.body = JSON.parseObject(JSON.toJSONString(instance));

        flowContext.putTemporaryData("apiParameter", apiParameter);
        flowContext.brokenCurrentCompositeBusiness("读取参数信息完成");
    }

    @Override
    public String name() {
        return "通过RequestBody注解获取参数";
    }
}
