package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;

import java.lang.reflect.Parameter;

public class GetByPathVariableAnnotationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Parameter parameter = (Parameter) flowContext.checkData("parameter");

        PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
        if(null==pathVariable){
            return;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.annotationParameterName = pathVariable.value();
        if(StringUtils.isEmpty(apiParameter.annotationParameterName)){
            apiParameter.annotationParameterName = pathVariable.name();
        }
        apiParameter.required = pathVariable.required();
        apiParameter.position = "path";

        flowContext.putTemporaryData("apiParameter", apiParameter);
        flowContext.brokenCurrentCompositeBusiness("读取参数信息完成");
    }

    @Override
    public String name() {
        return "通过PathVariable注解获取参数";
    }
}
