package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Parameter;

public class GetByMultipartFileFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        API api = (API) flowContext.checkData("api");
        Parameter parameter = (Parameter) flowContext.checkData("parameter");

        String multipartFileClassName = MultipartFile.class.getName();
        String parameterTypeClassName = parameter.getType().getName();
        if(multipartFileClassName.equalsIgnoreCase(parameterTypeClassName)
                ||(parameterTypeClassName.startsWith("[L")&&parameterTypeClassName.contains(multipartFileClassName))
        ){
            APIParameter apiParameter = new APIParameter();
            apiParameter.position = "body";
            apiParameter.requestType = "file";
            api.contentType = "multipart/form-data";

            flowContext.putTemporaryData("apiParameter", apiParameter);
            flowContext.brokenCurrentCompositeBusiness("读取参数信息完成");
        }
    }

    @Override
    public String name() {
        return "通过MultipartFile类型获取参数";
    }
}
