package cn.schoolwow.quickapi.flow.parameter;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.lang.reflect.Parameter;

public class GetByAPIParameterFunctionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");
        API api = (API) flowContext.checkData("api");
        Parameter parameter = (Parameter) flowContext.checkData("parameter");

        if(null!=quickAPIOption&&null!=quickAPIOption.apiParameterFunction){
            APIParameter apiParameter = quickAPIOption.apiParameterFunction.apply(api,parameter);
            flowContext.putTemporaryData("apiParameter", apiParameter);
            flowContext.brokenCurrentCompositeBusiness("读取参数信息完成");
        }
    }

    @Override
    public String name() {
        return "根据APIParameterFunction配置参数获取参数";
    }
}
