package cn.schoolwow.quickapi.flow.initial;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Arrays;

public class SetAPIEntityAndFieldListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        //设置请求参数列表
        {
            for(API api:apiDocument.apiList){
                for(String parameterEntityName:api.parameterEntityNameList){
                    APIEntity apiEntity = apiDocument.apiEntityMap.get(parameterEntityName);
                    apiDocument.parameterEntityList.add(apiEntity);
                }
            }
        }
        //设置返回参数列表
        {
            for(API api:apiDocument.apiList){
                for(String returnEntityName:api.returnEntityNameList){
                    APIEntity apiEntity = apiDocument.apiEntityMap.get(returnEntityName);
                    apiDocument.returnEntityList.add(apiEntity);
                }
            }
        }
        //设置字段列表
        {
            for(APIEntity apiEntity:apiDocument.apiEntityMap.values()){
                apiDocument.apiFieldList.addAll(Arrays.asList(apiEntity.apiFields));
            }
        }

        //设置API参数关联接口名称
        for(APIParameter apiParameter:apiDocument.apiParameterList){
            apiParameter.apiName = apiParameter.api.description;
        }
    }

    @Override
    public String name() {
        return "设置实体类列表和字段列表";
    }
}
