package cn.schoolwow.quickapi.flow.initial;

import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class HandleConsumerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");

        if(null!=quickAPIOption&&null!=quickAPIOption.apiControllerConsumer){
            for(APIController apiController:apiDocument.apiControllerList){
                quickAPIOption.apiControllerConsumer.accept(apiController);
            }
        }
        if(null!=quickAPIOption&&null!=quickAPIOption.apiEntityConsumer){
            for(APIEntity apiEntity:apiDocument.apiEntityMap.values()){
                quickAPIOption.apiEntityConsumer.accept(apiEntity);
            }
        }
    }

    @Override
    public String name() {
        return "处理用户自定义处理器";
    }
}
