package cn.schoolwow.quickapi.flow.initial;

import cn.schoolwow.quickapi.domain.*;
import cn.schoolwow.quickapi.util.JavaDocUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.sun.javadoc.*;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GetJavaDocFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");

        String sourcePath = System.getProperty("user.dir") + "/src/main/java";
        if(null!=quickAPIOption&&null!=quickAPIOption.sourcePath&&Files.notExists(Paths.get(quickAPIOption.sourcePath))){
            sourcePath = quickAPIOption.sourcePath;
        }
        ClassDoc[] classDocs = JavaDocUtil.getJavaDoc(sourcePath, flowContext);
        handleAPIController(classDocs,flowContext);
        handleAPIEntity(classDocs,flowContext);
    }

    @Override
    public String name() {
        return "获取javadoc文档注释";
    }

    /**
     * 处理APIController
     * @param classDocs javadoc注释
     * */
    private void handleAPIController(ClassDoc[] classDocs, FlowContext flowContext){
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        for (APIController apiController : apiDocument.apiControllerList) {
            for (ClassDoc classDoc : classDocs) {
                //判断控制器类名是否匹配
                if (!apiController.className.equals(classDoc.qualifiedName())) {
                    continue;
                }
                matchAPIController(apiController, classDoc, flowContext);
                //匹配方法
                MethodDoc[] methodDocs = classDoc.methods();
                for (API api : apiDocument.apiList) {
                    for (MethodDoc methodDoc : methodDocs) {
                        //方法名和参数类型,个数匹配才算匹配
                        if(!api.method.getName().equals(methodDoc.name())){
                            continue;
                        }
                        if(api.method.getParameterCount()!=methodDoc.parameters().length){
                            continue;
                        }
                        matchAPI(api, methodDoc, flowContext);
                        //获取参数信息
                        ParamTag[] paramTags = methodDoc.paramTags();
                        for (APIParameter apiParameter : apiDocument.apiParameterList) {
                            for (ParamTag paramTag : paramTags) {
                                if (null!=apiParameter.parameter&&apiParameter.name.equals(paramTag.parameterName())) {
                                   matchAPIParameter(apiParameter, paramTag);
                                    break;
                                }
                            }
                        }
                        //获取抛出异常信息
                        ThrowsTag[] throwsTags = methodDoc.throwsTags();
                        if (null != throwsTags && throwsTags.length > 0) {
                            for(APIException apiException:api.apiExceptions){
                                for (int i = 0; i < throwsTags.length; i++) {
                                    if(apiException.className.equalsIgnoreCase(throwsTags[i].exceptionName())){
                                        matchAPIException(apiException, throwsTags[i]);
                                        break;
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    /**
     * 处理APIEntity
     * @param classDocs javadoc注释
     * */
    private void handleAPIEntity(ClassDoc[] classDocs, FlowContext flowContext){
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        for (APIEntity apiEntity : apiDocument.apiEntityMap.values()) {
            for (ClassDoc classDoc : classDocs) {
                if (apiEntity.className.equals(classDoc.qualifiedName())) {
                    apiEntity.setDescription(classDoc.commentText());
                    Tag[] authorTags = classDoc.tags("author");
                    if (null != authorTags && authorTags.length > 0) {
                        apiEntity.author = authorTags[0].text();
                    }
                    Tag[] sinceTags = classDoc.tags("since");
                    if (null != sinceTags && sinceTags.length > 0) {
                        apiEntity.since = sinceTags[0].text();
                    }
                    for (APIField apiField : apiEntity.apiFields) {
                        for (FieldDoc fieldDoc : getAllFieldDoc(classDoc)) {
                            if (apiField.name.equals(fieldDoc.name())) {
                                apiField.setDescription(fieldDoc.commentText());
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    /**
     * 获得该类所有字段(包括父类字段)
     * @param classDoc 类文档
     * */
    public FieldDoc[] getAllFieldDoc(ClassDoc classDoc){
        List<FieldDoc> fieldDocList = new ArrayList<>();
        ClassDoc tempClassDoc = classDoc;
        while (null != tempClassDoc) {
            FieldDoc[] fieldDocs = tempClassDoc.fields();
            //排除静态变量和常量
            for(FieldDoc fieldDoc:fieldDocs){
                if(Modifier.isFinal(fieldDoc.modifierSpecifier())||Modifier.isStatic(fieldDoc.modifierSpecifier())){
                    continue;
                }
                fieldDocList.add(fieldDoc);
            }
            tempClassDoc = tempClassDoc.superclass();
            if (null!=tempClassDoc&&"java.lang.Object".equals(tempClassDoc.qualifiedName())) {
                break;
            }
        }
        return fieldDocList.toArray(new FieldDoc[0]);
    }

    private void matchAPIController(APIController apiController, ClassDoc classDoc, FlowContext flowContext){
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");

        apiController.setDescription(classDoc.getRawCommentText());
        //添加描述
        if(null!=quickAPIOption&&null!=quickAPIOption.classDocConsumer){
            quickAPIOption.classDocConsumer.accept(classDoc,apiController);
        }
    }

    private void matchAPI(API api, MethodDoc methodDoc, FlowContext flowContext){
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");

        api.setDescription(methodDoc.commentText());
        Tag[] authorTags = methodDoc.tags("author");
        if (null != authorTags && authorTags.length > 0) {
            api.author = authorTags[0].text();
        }
        Tag[] sinceTags = methodDoc.tags("since");
        if (null != sinceTags && sinceTags.length > 0) {
            api.since = sinceTags[0].text();
        }

        if(null!=quickAPIOption&&null!=quickAPIOption.methodDocConsumer){
            quickAPIOption.methodDocConsumer.accept(methodDoc,api);
        }
    }

    private void matchAPIParameter(APIParameter apiParameter, ParamTag paramTag){
        apiParameter.description = paramTag.parameterComment();
    }

    private void matchAPIException(APIException apiException, ThrowsTag throwsTag){
        apiException.description = throwsTag.exceptionComment();
    }
}
