package cn.schoolwow.quickapi.flow.initial;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.flow.parameter.*;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

public class GetAPIParameterFlow implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(GetAPIParameterFlow.class);

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        for(API api:apiDocument.apiList){
            //参数原始名称
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] parameterRawNames = u.getParameterNames(api.method);
            //API参数
            List<APIParameter> apiParameterList = new ArrayList<>();
            //方法参数
            Parameter[] parameters = api.method.getParameters();
            for(int i=0;i<parameters.length;i++){
                Parameter parameter = parameters[i];

                //处理非参数注解
                flowContext.startFlow("处理非请求参数注解")
                        .putCurrentCompositeFlowData("api", api)
                        .putCurrentCompositeFlowData("parameter", parameter)
                        .putCurrentCompositeFlowData("parameterName", parameterRawNames[i])
                        .next(new GetRequestHeaderAnnotationFlow())
                        .execute();
                if(flowContext.containKey("handleFlag")){
                    flowContext.removeData("handleFlag");
                    continue;
                }

                flowContext.startFlow("获取参数信息")
                        .putCurrentCompositeFlowData("api", api)
                        .putCurrentCompositeFlowData("parameter", parameter)
                        .putCurrentCompositeFlowData("parameterName", parameterRawNames[i])
                        .next(new GetByPathVariableAnnotationFlow())
                        .next(new GetByRequestParamAnnotationFlow())
                        .next(new GetByRequestBodyAnnotationFlow())
                        .next(new GetByRequestPartAnnotationFlow())
                        .next(new GetByMultipartFileFlow())
                        .next(new GetByAPIParameterFunctionFlow())
                        .execute();
                APIParameter apiParameter = (APIParameter) flowContext.getData("apiParameter");
                if(null==apiParameter){
                    //不支持处理该参数
                    logger.warn("[不支持处理该参数]方法名:{},参数名:{}",api.method.getName(),parameter.getName());
                    logger.warn("流程路径\r\n{}", flowContext.getFlowTrace());
                    continue;
                }
                apiParameter.controllerClassName = api.controllerClassName;
                apiParameter.methodName = api.methodName;
                apiParameter.name = parameterRawNames[i];
                apiParameter.typeClassName = parameter.getType().getName();
                apiParameter.parameter = parameters[i];
                apiParameter.api = api;
                apiParameterList.add(apiParameter);
            }
            api.parameterCount = apiParameterList.size();
            apiDocument.apiParameterList.addAll(apiParameterList);
        }
    }

    @Override
    public String name() {
        return "获取API参数列表";
    }
}
