package cn.schoolwow.quickapi.flow.initial;

import cn.schoolwow.quickapi.domain.*;
import cn.schoolwow.quickapi.util.QuickAPIUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;

public class GetAPIEntityFlow implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(GetAPIEntityFlow.class);

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");
        if(null==quickAPIOption||null==quickAPIOption.apiEntityPredicate){
            flowContext.brokenCurrentFlow("未配置需扫描实体类信息");
            return;
        }

        //添加API返回值实体类信息
        for(API api:apiDocument.apiList){
            api.returnEntityNameList.addAll(getRecycleAPIEntity(api.method.getReturnType(),flowContext));
            api.returnEntityNameList.addAll(getGenericTypeRecycleClassName(api.method.getGenericReturnType(),flowContext));
        }

        //添加API参数实体类信息
        for(APIParameter apiParameter:apiDocument.apiParameterList){
            apiParameter.api.parameterEntityNameList.addAll(getRecycleAPIEntity(apiParameter.parameter.getType(),flowContext));
            apiParameter.api.parameterEntityNameList.addAll(getGenericTypeRecycleClassName(apiParameter.parameter.getType(),flowContext));
        }
    }

    @Override
    public String name() {
        return "获取接口关联实体类信息";
    }

    /**
     * 获取所有相关实体类信息
     * */
    private Set<String> getRecycleAPIEntity(Class rootClazz, FlowContext flowContext) {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");
        QuickAPIOption quickAPIOption = (QuickAPIOption) flowContext.getData("quickAPIOption");

        Set<String> classNameSet = new HashSet<>();
        if(null==rootClazz){
            return classNameSet;
        }
        Stack<Class> apiEntityClassStack = new Stack();
        apiEntityClassStack.push(rootClazz);
        while(!apiEntityClassStack.isEmpty()){
            Class clazz = apiEntityClassStack.pop();
            if(null==quickAPIOption||!quickAPIOption.apiEntityPredicate.test(clazz)){
                continue;
            }
            APIEntity apiEntity = getAPIEntity(clazz);
            classNameSet.add(apiEntity.className);
            if(!apiDocument.apiEntityMap.containsKey(apiEntity.className)){
                apiDocument.apiEntityMap.put(apiEntity.className,apiEntity);
            }
            for(APIField apiField:apiEntity.apiFields){
                if(!classNameSet.contains(apiField.field.getType().getName())){
                    apiEntityClassStack.push(apiField.field.getType());
                }
                if(null!=apiField.genericTypeClassName&&!classNameSet.contains(apiField.genericTypeClassName)){
                    if(!"T".equalsIgnoreCase(apiField.genericTypeClassName)){
                        try {
                            apiEntityClassStack.push(ClassLoader.getSystemClassLoader().loadClass(apiField.genericTypeClassName));
                        } catch (ClassNotFoundException e) {
                            logger.warn("[找不到字段泛型类]{}",e.getMessage());
                        }
                    }
                }
            }
        }
        return classNameSet;
    }

    /**
     * 获取泛型关联类对象
     * @param type 泛型类型
     * */
    private Set<String> getGenericTypeRecycleClassName(Type type, FlowContext flowContext) {
        List<Class> classList = new ArrayList<>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType) type;
            Type genericType = pType.getActualTypeArguments()[0];
            String typeName = genericType.getTypeName();
            while(typeName.contains("<")){
                try {
                    classList.add(ClassLoader.getSystemClassLoader().loadClass(typeName.substring(0,typeName.indexOf("<"))));
                } catch (ClassNotFoundException e) {
                    logger.warn("[找不到参数或返回值泛型类]{}",e.getMessage());
                }
                typeName = typeName.substring(typeName.indexOf("<")+1,typeName.length()-1);
            }
            try {
                classList.add(ClassLoader.getSystemClassLoader().loadClass(typeName));
            } catch (ClassNotFoundException e) {
                logger.warn("[找不到参数或返回值泛型类]{}",e.getMessage());
            }
        }
        Set<String> classNameSet = new HashSet<>();
        for(Class clazz:classList){
            classNameSet.addAll(getRecycleAPIEntity(clazz,flowContext));
        }
        return classNameSet;
    }

    /**提取APIEntity*/
    private APIEntity getAPIEntity(Class clazz) {
        if(null!=clazz.getComponentType()){
            clazz = clazz.getComponentType();
        }

        APIEntity apiEntity = new APIEntity();
        apiEntity.clazz = clazz;
        apiEntity.className = clazz.getName();
        apiEntity.simpleName = clazz.getSimpleName();

        Field[] fields = QuickAPIUtil.getAllField(clazz);
        APIField[] apiFields = new APIField[fields.length];
        for (int i = 0; i < fields.length; i++) {
            APIField apiField = new APIField();
            apiField.entityClassName = clazz.getName();
            apiField.field = fields[i];
            apiField.name = fields[i].getName();
            apiField.className = fields[i].getType().getName();
            //处理泛型
            Type fieldType = fields[i].getGenericType();
            if (fieldType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType) fieldType;
                Type genericType = pType.getActualTypeArguments()[0];
                apiField.genericTypeClassName = genericType.getTypeName();
            }
            apiFields[i] = apiField;
        }
        apiEntity.apiFields = apiFields;
        return apiEntity;
    }
}
