package cn.schoolwow.quickapi.flow.initial;

import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class GetAPIControllerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        scanPackageClass(flowContext);
        filterClass(flowContext);
        setPrefix(flowContext);
    }

    @Override
    public String name() {
        return "获取控制器列表";
    }

    /**
     * 获取项目中所有的类
     * */
    public void scanPackageClass(FlowContext flowContext) throws Exception{
        Enumeration<URL> urlEnumeration = ClassLoader.getSystemClassLoader().getResources("");
        while(urlEnumeration.hasMoreElements()){
            URL url = urlEnumeration.nextElement();
            if(url==null){
                continue;
            }
            switch (url.getProtocol()) {
                case "file":{getByFile(url, flowContext);}break;
                case "jar":{getByJar(url, flowContext);}break;
                default:{
                    throw new UnsupportedOperationException("不支持的url协议!当前url协议:"+url.getProtocol());
                }
            }
        }
    }

    private void filterClass(FlowContext flowContext) throws ClassNotFoundException {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        Iterator<APIController> iterator = apiDocument.apiControllerList.iterator();
        while(iterator.hasNext()){
            APIController apiController = iterator.next();
            Class clazz = ClassLoader.getSystemClassLoader().loadClass(apiController.className);
            if(null==clazz.getAnnotation(Controller.class)
                    &&null==clazz.getAnnotation(RestController.class)
            ){
                iterator.remove();
                continue;
            }
            apiController.clazz = clazz;
            if(null!=apiController.clazz.getAnnotation(Deprecated.class)){
                apiController.deprecated = true;
            }
        }
    }

    private void setPrefix(FlowContext flowContext) throws ClassNotFoundException {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        for(APIController apiController:apiDocument.apiControllerList){
            Class clazz = ClassLoader.getSystemClassLoader().loadClass(apiController.className);
            RequestMapping requestMapping = (RequestMapping) clazz.getDeclaredAnnotation(RequestMapping.class);
            if(null!=requestMapping){
                apiController.prefix = requestMapping.value()[0];
            }
        }
    }

    private void getByFile(URL url, FlowContext flowContext) throws IOException {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        File directoryFile = new File(url.getFile());
        //TODO 对于有空格或者中文路径会无法识别
        if (!directoryFile.isDirectory()) {
            throw new IllegalArgumentException("包名不是合法的文件夹!" + url.getFile());
        }
        Files.walkFileTree(directoryFile.toPath(),new SimpleFileVisitor<Path>(){
            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                File file = path.toFile();
                if(file.getName().endsWith(".class")){
                    String className = file.getAbsolutePath().substring(0,file.getAbsolutePath().length()-6).substring(directoryFile.getAbsolutePath().length()+1).replace('/','.').replace('\\','.');
                    APIController apiController = new APIController();
                    apiController.className = className;
                    apiController.createdTime = new Timestamp(file.lastModified());
                    apiDocument.apiControllerList.add(apiController);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void getByJar(URL url, FlowContext flowContext) throws IOException {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");

        JarURLConnection jarURLConnection = (JarURLConnection) url.openConnection();
        if (null != jarURLConnection) {
            JarFile jarFile = jarURLConnection.getJarFile();
            if (null != jarFile) {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if(jarEntryName.endsWith(".class")){
                        String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                        APIController apiController = new APIController();
                        apiController.className = className;
                        apiController.createdTime = new Timestamp(jarEntry.getLastModifiedTime().to(TimeUnit.MILLISECONDS));
                        apiDocument.apiControllerList.add(apiController);
                    }
                }
            }
        }
    }
}
