package cn.schoolwow.quickapi.flow.controller;

import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        APIDocument apiDocument = (APIDocument) flowContext.checkData("apiDocument");
        Class clazz = (Class) flowContext.checkData("clazz");
        String type = (String) flowContext.getData("type");

        if(null!=type){
            switch (type){
                case "ParameterEntity":{flowContext.putTemporaryData("list", apiDocument.parameterEntityList);}break;
                case "ReturnEntity":{flowContext.putTemporaryData("list", apiDocument.returnEntityList);}break;
                default:{
                    throw new IllegalArgumentException("不支持该类型!类型名:"+type);
                }
            }
            return;
        }

        switch (clazz.getSimpleName()){
            case "APIController":{flowContext.putTemporaryData("list", apiDocument.apiControllerList);}break;
            case "API":{flowContext.putTemporaryData("list", apiDocument.apiList);}break;
            case "APIParameter":{flowContext.putTemporaryData("list", apiDocument.apiParameterList);}break;
            case "APIField":{flowContext.putTemporaryData("list", apiDocument.apiFieldList);}break;
            default:{
                throw new IllegalArgumentException("不支持该类型!类型名:"+clazz.getSimpleName());
            }
        }
    }

    @Override
    public String name() {
        return "获取APIController列表";
    }

}
